/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bandwidthmgr;

import com.google.common.base.Preconditions;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.bandwidthmgr.BandwidthManager;
import org.onosproject.bandwidthmgr.api.BandwidthMgmtStore;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.LinkKey;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.pcep.api.TeLinkConfig;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedBandwidthMgmtStore
implements BandwidthMgmtStore {
    private static final Logger log = LoggerFactory.getLogger(BandwidthManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService netCfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private InternalConfigListener cfgListener = new InternalConfigListener();
    private ConsistentMap<LinkKey, Double> teCost;
    private ConsistentMap<LinkKey, Set<Double>> unResvBw;
    private ConsistentMap<LinkKey, Double> localReservedBw;
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(KryoNamespaces.API).register(new Class[]{LinkKey.class}).register(new Class[]{ConnectPoint.class}).build());

    @Activate
    protected void activate() {
        this.netCfgService.addListener((EventListener)this.cfgListener);
        this.localReservedBw = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("local-reserved-bandwith")).withSerializer(SERIALIZER)).build();
        this.unResvBw = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-unreserved-bandwidth")).withSerializer(SERIALIZER)).build();
        this.teCost = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-tecost")).withSerializer(SERIALIZER)).build();
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.netCfgService.removeListener((EventListener)this.cfgListener);
        log.info("Stopped");
    }

    @Override
    public Double getTeCost(LinkKey linkKey) {
        if (this.teCost.get((Object)linkKey) != null) {
            return (Double)this.teCost.get((Object)linkKey).value();
        }
        return null;
    }

    @Override
    public boolean allocLocalReservedBw(LinkKey linkkey, Double bandwidth) {
        Double allocatedBw = null;
        if (this.localReservedBw.get((Object)linkkey) != null) {
            allocatedBw = (Double)this.localReservedBw.get((Object)linkkey).value();
        }
        if (allocatedBw != null) {
            this.localReservedBw.put((Object)linkkey, (Object)(allocatedBw + bandwidth));
        } else {
            this.localReservedBw.put((Object)linkkey, (Object)bandwidth);
        }
        return true;
    }

    @Override
    public boolean releaseLocalReservedBw(LinkKey linkkey, Double bandwidth) {
        Double allocatedBw = null;
        if (this.localReservedBw.get((Object)linkkey) != null) {
            allocatedBw = (Double)this.localReservedBw.get((Object)linkkey).value();
        }
        if (allocatedBw == null || allocatedBw < bandwidth) {
            return false;
        }
        Double releasedBw = allocatedBw - bandwidth;
        if (releasedBw == 0.0) {
            this.localReservedBw.remove((Object)linkkey);
        } else {
            this.localReservedBw.put((Object)linkkey, (Object)releasedBw);
        }
        return true;
    }

    @Override
    public Double getAllocatedLocalReservedBw(LinkKey linkkey) {
        return this.localReservedBw.get((Object)linkkey) != null ? (Double)this.localReservedBw.get((Object)linkkey).value() : null;
    }

    @Override
    public boolean addUnreservedBw(LinkKey linkkey, Set<Double> bandwidth) {
        this.unResvBw.put((Object)linkkey, bandwidth);
        return true;
    }

    @Override
    public boolean removeUnreservedBw(LinkKey linkkey) {
        this.unResvBw.remove((Object)linkkey);
        return true;
    }

    @Override
    public Set<Double> getUnreservedBw(LinkKey linkkey) {
        Preconditions.checkNotNull((Object)linkkey);
        return this.unResvBw.get((Object)linkkey) != null ? (Set)this.unResvBw.get((Object)linkkey).value() : null;
    }

    protected void bindNetCfgService(NetworkConfigService networkConfigService) {
        this.netCfgService = networkConfigService;
    }

    protected void unbindNetCfgService(NetworkConfigService networkConfigService) {
        if (this.netCfgService == networkConfigService) {
            this.netCfgService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(TeLinkConfig.class)) {
                if (event.type() != NetworkConfigEvent.Type.CONFIG_ADDED && event.type() != NetworkConfigEvent.Type.CONFIG_UPDATED && event.type() != NetworkConfigEvent.Type.CONFIG_REMOVED) {
                    return;
                }
                LinkKey linkKey = (LinkKey)event.subject();
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: 
                    case CONFIG_UPDATED: {
                        TeLinkConfig cfg = (TeLinkConfig)DistributedBandwidthMgmtStore.this.netCfgService.getConfig((Object)linkKey, TeLinkConfig.class);
                        if (cfg == null) {
                            log.error("Unable to get the configuration of the link.");
                            return;
                        }
                        LinkedHashSet<Double> unresvBw = new LinkedHashSet<Double>();
                        unresvBw.add(cfg.unResvBandwidth());
                        DistributedBandwidthMgmtStore.this.addUnreservedBw(linkKey, unresvBw);
                        if (cfg.teCost() == 0) break;
                        DistributedBandwidthMgmtStore.this.teCost.put((Object)linkKey, (Object)cfg.teCost());
                        break;
                    }
                    case CONFIG_REMOVED: {
                        DistributedBandwidthMgmtStore.this.removeUnreservedBw(linkKey);
                        DistributedBandwidthMgmtStore.this.localReservedBw.remove((Object)linkKey);
                        DistributedBandwidthMgmtStore.this.teCost.remove((Object)linkKey);
                        break;
                    }
                }
            }
        }
    }
}

