/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bandwidthmgr;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.bandwidthmgr.api.BandwidthMgmtService;
import org.onosproject.bandwidthmgr.api.BandwidthMgmtStore;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class BandwidthManager
implements BandwidthMgmtService {
    private static final Logger log = LoggerFactory.getLogger(BandwidthManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected BandwidthMgmtStore store;

    @Activate
    protected void activate() {
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        log.info("Stopped");
    }

    @Override
    public Double getTeCost(LinkKey linkKey) {
        Preconditions.checkNotNull((Object)linkKey);
        return this.store.getTeCost(linkKey);
    }

    @Override
    public Double getAvailableBandwidth(LinkKey linkKey) {
        Preconditions.checkNotNull((Object)linkKey);
        Set<Double> unResvBw = this.getUnreservedBw(linkKey);
        Double localReservedBw = this.getAllocatedLocalReservedBw(linkKey);
        if (unResvBw != null && localReservedBw != null) {
            return unResvBw.iterator().next() - localReservedBw;
        }
        if (unResvBw != null) {
            return (double)unResvBw.iterator().next();
        }
        return null;
    }

    @Override
    public boolean allocLocalReservedBw(LinkKey linkKey, Double bandwidth) {
        Preconditions.checkNotNull((Object)linkKey);
        Preconditions.checkNotNull((Object)bandwidth);
        return this.store.allocLocalReservedBw(linkKey, bandwidth);
    }

    @Override
    public boolean releaseLocalReservedBw(LinkKey linkkey, Double bandwidth) {
        Preconditions.checkNotNull((Object)linkkey);
        Preconditions.checkNotNull((Object)bandwidth);
        return this.store.releaseLocalReservedBw(linkkey, bandwidth);
    }

    @Override
    public Double getAllocatedLocalReservedBw(LinkKey linkkey) {
        Preconditions.checkNotNull((Object)linkkey);
        return this.store.getAllocatedLocalReservedBw(linkkey);
    }

    @Override
    public boolean addUnreservedBw(LinkKey linkKey, Set<Double> bandwidth) {
        Preconditions.checkNotNull((Object)linkKey);
        Preconditions.checkNotNull(bandwidth);
        return this.store.addUnreservedBw(linkKey, bandwidth);
    }

    @Override
    public boolean removeUnreservedBw(LinkKey linkkey) {
        Preconditions.checkNotNull((Object)linkkey);
        return this.store.removeUnreservedBw(linkkey);
    }

    @Override
    public Set<Double> getUnreservedBw(LinkKey linkkey) {
        Preconditions.checkNotNull((Object)linkkey);
        return this.store.getUnreservedBw(linkkey);
    }

    @Override
    public boolean isBandwidthAvailable(Link link, Double bandwidth) {
        Preconditions.checkNotNull((Object)link);
        Preconditions.checkNotNull((Object)bandwidth);
        LinkKey linkKey = LinkKey.linkKey((Link)link);
        Double localAllocBw = this.getAllocatedLocalReservedBw(linkKey);
        Set<Double> unResvBw = this.getUnreservedBw(linkKey);
        Double prirZeroBw = unResvBw.iterator().next();
        return bandwidth <= prirZeroBw - (localAllocBw != null ? localAllocBw : 0.0);
    }

    protected void bindStore(BandwidthMgmtStore bandwidthMgmtStore) {
        this.store = bandwidthMgmtStore;
    }

    protected void unbindStore(BandwidthMgmtStore bandwidthMgmtStore) {
        if (this.store == bandwidthMgmtStore) {
            this.store = null;
        }
    }
}

