/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netcfgmonitor;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.onosproject.event.EventListener;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class NetCfgEventMonitor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    protected NetworkConfigService networkConfigService;
    private final NetworkConfigListener listener = new InternalListener();

    @Activate
    protected void activate() {
        this.networkConfigService.addListener((EventListener)this.listener);
    }

    @Deactivate
    protected void deactivate() {
        this.networkConfigService.removeListener((EventListener)this.listener);
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private class InternalListener
    implements NetworkConfigListener {
        private InternalListener() {
        }

        public void event(NetworkConfigEvent event) {
            NetCfgEventMonitor.this.log.info("Received event {}", (Object)event);
        }
    }
}

