/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.hp;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFFlowDelete;
import org.projectfloodlight.openflow.protocol.OFGroupDelete;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.TableId;

public class HPSwitchHandshaker
extends AbstractOpenFlowSwitch {
    private AtomicBoolean handshakeComplete = new AtomicBoolean(false);

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        OFFlowDelete fm = this.factory().buildFlowDelete().setTableId(TableId.ALL).setOutGroup(OFGroup.ANY).build();
        this.sendMsg((List)ImmutableList.of((Object)fm));
        OFGroupDelete gm = this.factory().buildGroupDelete().setGroup(OFGroup.ALL).setGroupType(OFGroupType.ALL).build();
        this.sendMsg((List)ImmutableList.of((Object)gm));
        this.handshakeComplete.set(true);
        this.log.info("Handshake with device {} ended", (Object)super.getStringId());
    }

    public boolean isDriverHandshakeComplete() {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        return this.handshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.handshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
    }
}

