/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.hp;

import org.onosproject.drivers.hp.AbstractHPPipeline;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HPPipelineV3800
extends AbstractHPPipeline {
    private static final int HP_TABLE_ZERO = 0;
    private static final int HP_HARDWARE_TABLE = 100;
    private static final int HP_SOFTWARE_TABLE = 200;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected FlowRule.Builder setDefaultTableIdForFlowObjective(FlowRule.Builder ruleBuilder) {
        this.log.debug("Setting default table id to hardware table {}", (Object)100);
        return ruleBuilder.forTable(100);
    }

    @Override
    protected void initializePipeline() {
        this.log.debug("Installing table zero {}", (Object)0);
        this.installHPTableZero();
        this.log.debug("Installing scavenger rule to hardware table {} because it is default objective table", (Object)100);
        this.installHPHardwareTable();
        this.log.debug("Installing software table {}", (Object)200);
        this.installHPSoftwareTable();
    }

    @Override
    public void filter(FilteringObjective filter) {
        this.log.error("Unsupported FilteringObjective: : filtering method send");
    }

    @Override
    protected FlowRule.Builder processEthFiler(FilteringObjective filt, EthCriterion eth, PortCriterion port) {
        this.log.error("Unsupported FilteringObjective: processEthFilter invoked");
        return null;
    }

    @Override
    protected FlowRule.Builder processVlanFiler(FilteringObjective filt, VlanIdCriterion vlan, PortCriterion port) {
        this.log.error("Unsupported FilteringObjective: processVlanFilter invoked");
        return null;
    }

    @Override
    protected FlowRule.Builder processIpFilter(FilteringObjective filt, IPCriterion ip, PortCriterion port) {
        this.log.error("Unsupported FilteringObjective: processIpFilter invoked");
        return null;
    }

    private void installHPTableZero() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(100));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(0).build();
        this.applyRules(true, rule);
        this.log.info("Installed table {}", (Object)0);
    }

    private void installHPHardwareTable() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setOutput(PortNumber.NORMAL);
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(100).build();
        this.applyRules(true, rule);
        this.log.info("Installed table {}", (Object)100);
    }

    private void installHPSoftwareTable() {
        this.log.info("No rules installed in table {}", (Object)200);
    }

    private void applyRules(boolean install, final FlowRule rule) {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        ops = install ? ops.add(rule) : ops.remove(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                HPPipelineV3800.this.log.trace("Provisioned rule: " + rule.toString());
                HPPipelineV3800.this.log.trace("HP3800 driver: provisioned " + rule.tableId() + " table");
            }

            public void onError(FlowRuleOperations ops) {
                HPPipelineV3800.this.log.info("HP3800 driver: failed to provision " + rule.tableId() + " table");
            }
        }));
    }
}

