/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.hp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.meter.MeterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHPPipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    protected static final String APPLICATION_ID = "org.onosproject.drivers.hp.HPPipeline";
    public static final int CACHE_ENTRY_EXPIRATION_PERIOD = 20;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected FlowRuleService flowRuleService;
    protected GroupService groupService;
    protected MeterService meterService;
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId appId;
    protected DeviceService deviceService;
    protected KryoNamespace appKryo = new KryoNamespace.Builder().register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{byte[].class}).build("AbstractHPPipeline");
    private ServiceDirectory serviceDirectory;
    private CoreService coreService;
    private Cache<Integer, NextObjective> pendingAddNext = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
        if (notification.getCause() == RemovalCause.EXPIRED) {
            ((NextObjective)notification.getValue()).context().ifPresent(c -> c.onError((Objective)notification.getValue(), ObjectiveError.FLOWINSTALLATIONFAILED));
        }
    }).build();

    protected abstract FlowRule.Builder setDefaultTableIdForFlowObjective(FlowRule.Builder var1);

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.meterService = (MeterService)this.serviceDirectory.get(MeterService.class);
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
        this.flowObjectiveStore = context.store();
        this.appId = this.coreService.registerApplication(APPLICATION_ID);
        this.initializePipeline();
    }

    protected abstract void initializePipeline();

    protected void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    protected void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    public void forward(ForwardingObjective fwd) {
        if (fwd.treatment() != null) {
            TrafficTreatment.Builder noClearTreatment = DefaultTrafficTreatment.builder();
            fwd.treatment().allInstructions().stream().filter((? super T i) -> i.type() != Instruction.Type.QUEUE).forEach(arg_0 -> ((TrafficTreatment.Builder)noClearTreatment).add(arg_0));
            if (fwd.treatment().metered() != null) {
                noClearTreatment.meter(fwd.treatment().metered().meterId());
            }
            TrafficSelector.Builder noVlanSelector = DefaultTrafficSelector.builder();
            fwd.selector().criteria().stream().filter((? super T c) -> c.type() != Criterion.Type.ETH_TYPE || c.type() == Criterion.Type.ETH_TYPE && ((EthTypeCriterion)c).ethType().toShort() != Ethernet.TYPE_VLAN).forEach(arg_0 -> ((TrafficSelector.Builder)noVlanSelector).add(arg_0));
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(noVlanSelector.build()).withTreatment(noClearTreatment.build()).withPriority(fwd.priority()).withPriority(fwd.priority()).fromApp(fwd.appId());
            this.setDefaultTableIdForFlowObjective(ruleBuilder);
            if (fwd.permanent()) {
                ruleBuilder.makePermanent();
            } else {
                ruleBuilder.makeTemporary(fwd.timeout());
            }
            this.installObjective(ruleBuilder, (Objective)fwd);
        } else {
            TrafficTreatment treatment;
            if (fwd.op() == Objective.Operation.ADD) {
                NextObjective nextObjective = (NextObjective)this.pendingAddNext.getIfPresent((Object)fwd.nextId());
                if (nextObjective == null) {
                    NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
                    if (next == null) {
                        fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
                        return;
                    }
                    treatment = (TrafficTreatment)this.appKryo.deserialize(next.data());
                } else {
                    this.pendingAddNext.invalidate((Object)fwd.nextId());
                    treatment = (TrafficTreatment)nextObjective.next().iterator().next();
                }
            } else {
                NextGroup next = this.flowObjectiveStore.removeNextGroup(fwd.nextId());
                if (next == null) {
                    fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
                    return;
                }
                treatment = (TrafficTreatment)this.appKryo.deserialize(next.data());
            }
            if (treatment == null) {
                fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
                return;
            }
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(fwd.selector()).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(treatment);
            if (fwd.permanent()) {
                ruleBuilder.makePermanent();
            } else {
                ruleBuilder.makeTemporary(fwd.timeout());
            }
            this.installObjective(ruleBuilder, (Objective)fwd);
        }
    }

    protected void installObjective(FlowRule.Builder ruleBuilder, final Objective objective) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        switch (objective.op()) {
            case ADD: {
                this.log.trace("Requested installation of objective " + objective.toString());
                FlowRule addRule = ruleBuilder.build();
                this.log.trace("built rule is " + addRule.toString());
                flowBuilder.add(addRule);
                break;
            }
            case REMOVE: {
                this.log.trace("Requested installation of objective " + objective.toString());
                FlowRule removeRule = ruleBuilder.build();
                this.log.trace("built rule is " + removeRule.toString());
                flowBuilder.remove(removeRule);
                break;
            }
            default: {
                this.log.warn("Unknown operation {}", (Object)objective.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onSuccess(objective));
                AbstractHPPipeline.this.log.trace("Installed objective " + objective.toString());
            }

            public void onError(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onError(objective, ObjectiveError.FLOWINSTALLATIONFAILED));
                AbstractHPPipeline.this.log.trace("Objective installation failed" + objective.toString());
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        switch (nextObjective.op()) {
            case ADD: {
                this.pendingAddNext.put((Object)nextObjective.id(), (Object)nextObjective);
                this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new SingleGroup((TrafficTreatment)nextObjective.next().iterator().next()));
                break;
            }
            case REMOVE: {
                break;
            }
            default: {
                this.log.warn("Unsupported operation {}", (Object)nextObjective.op());
            }
        }
        nextObjective.context().ifPresent(context -> context.onSuccess((Objective)nextObjective));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return ImmutableList.of();
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            this.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    private void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            this.log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            this.fail((Objective)filt, ObjectiveError.UNKNOWN);
            return;
        }
        PortCriterion port = (PortCriterion)filt.key();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Criterion c : filt.conditions()) {
            FlowRule.Builder rule;
            if (c.type() == Criterion.Type.ETH_DST) {
                EthCriterion eth = (EthCriterion)c;
                rule = this.processEthFiler(filt, eth, port);
                rule.forDevice(this.deviceId).fromApp(applicationId);
                ops = install ? ops.add(rule.build()) : ops.remove(rule.build());
                continue;
            }
            if (c.type() == Criterion.Type.VLAN_VID) {
                VlanIdCriterion vlan = (VlanIdCriterion)c;
                rule = this.processVlanFiler(filt, vlan, port);
                rule.forDevice(this.deviceId).fromApp(applicationId);
                ops = install ? ops.add(rule.build()) : ops.remove(rule.build());
                continue;
            }
            if (c.type() == Criterion.Type.IPV4_DST) {
                IPCriterion ip = (IPCriterion)c;
                rule = this.processIpFilter(filt, ip, port);
                rule.forDevice(this.deviceId).fromApp(applicationId);
                ops = install ? ops.add(rule.build()) : ops.remove(rule.build());
                continue;
            }
            this.log.warn("Driver does not currently process filtering condition of type: {}", (Object)c.type());
            this.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                AbstractHPPipeline.this.pass((Objective)filt);
                AbstractHPPipeline.this.log.trace("Applied filtering rules");
            }

            public void onError(FlowRuleOperations ops) {
                AbstractHPPipeline.this.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
                AbstractHPPipeline.this.log.info("Failed to apply filtering rules");
            }
        }));
    }

    protected abstract FlowRule.Builder processEthFiler(FilteringObjective var1, EthCriterion var2, PortCriterion var3);

    protected abstract FlowRule.Builder processVlanFiler(FilteringObjective var1, VlanIdCriterion var2, PortCriterion var3);

    protected abstract FlowRule.Builder processIpFilter(FilteringObjective var1, IPCriterion var2, PortCriterion var3);

    private class SingleGroup
    implements NextGroup {
        private TrafficTreatment nextActions;

        SingleGroup(TrafficTreatment next) {
            this.nextActions = next;
        }

        public byte[] data() {
            return AbstractHPPipeline.this.appKryo.serialize((Object)this.nextActions);
        }

        public TrafficTreatment treatment() {
            return this.nextActions;
        }
    }
}

