/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.service.Serializer;

public interface StoreSerializer
extends Serializer {
    public byte[] encode(Object var1);

    public void encode(Object var1, ByteBuffer var2);

    public void encode(Object var1, OutputStream var2);

    public <T> T decode(byte[] var1);

    public <T> T decode(ByteBuffer var1);

    public <T> T decode(InputStream var1);

    public <T> T copy(T var1);

    public static StoreSerializer using(final KryoNamespace ns) {
        return new StoreSerializer(){

            @Override
            public void encode(Object obj, OutputStream stream) {
                ns.serialize(obj, stream);
            }

            @Override
            public void encode(Object obj, ByteBuffer buffer) {
                ns.serialize(obj, buffer);
            }

            @Override
            public byte[] encode(Object obj) {
                return ns.serialize(obj);
            }

            @Override
            public <T> T decode(InputStream stream) {
                return (T)ns.deserialize(stream);
            }

            @Override
            public <T> T decode(ByteBuffer buffer) {
                return (T)ns.deserialize(buffer);
            }

            @Override
            public <T> T decode(byte[] bytes) {
                return (T)ns.deserialize(bytes);
            }

            @Override
            public <T> T copy(T object) {
                return (T)ns.run(kryo -> kryo.copy(object));
            }
        };
    }
}

