/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import org.onlab.packet.Ip6Address;

public class Ip6AddressSerializer
extends Serializer<Ip6Address> {
    public Ip6AddressSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, Ip6Address object) {
        byte[] octs = object.toOctets();
        output.writeInt(octs.length);
        output.writeBytes(octs);
    }

    public Ip6Address read(Kryo kryo, Input input, Class<Ip6Address> type) {
        int octLen = input.readInt();
        Preconditions.checkArgument((octLen == 16 ? 1 : 0) != 0);
        byte[] octs = new byte[octLen];
        input.readBytes(octs);
        return Ip6Address.valueOf((byte[])octs);
    }
}

