/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.influxdbmetrics;

import java.util.Dictionary;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreService;
import org.onosproject.influxdbmetrics.InfluxDbMetricsReporter;
import org.onosproject.influxdbmetrics.InfluxDbMetricsRetriever;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class InfluxDbMetricsConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 8086;
    private static final String DEFAULT_DATABASE = "onos";
    private static final String DEFAULT_USERNAME = "onos";
    private static final String DEFAULT_PASSWORD = "onos.password";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InfluxDbMetricsReporter influxDbMetricsReporter;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InfluxDbMetricsRetriever influxDbMetricsRetriever;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="address", value={"localhost"}, label="IP address of influxDB server; default is localhost")
    protected String address = "localhost";
    @Property(name="port", intValue={8086}, label="Port number of influxDB server; default is 8086")
    protected int port = 8086;
    @Property(name="database", value={"onos"}, label="Database name of influxDB server; default is onos")
    protected String database = "onos";
    @Property(name="username", value={"onos"}, label="Username of influxDB server; default is onos")
    protected String username = "onos";
    @Property(name="password", value={"onos.password"}, label="Password of influxDB server; default is onos.password")
    protected String password = "onos.password";

    @Activate
    public void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.coreService.registerApplication("org.onosproject.influxdbmetrics");
        this.configReporter(this.influxDbMetricsReporter);
        this.configRetriever(this.influxDbMetricsRetriever);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.configReporter(this.influxDbMetricsReporter);
        this.influxDbMetricsReporter.restartReport();
        this.configRetriever(this.influxDbMetricsRetriever);
    }

    private void configReporter(InfluxDbMetricsReporter reporter) {
        reporter.config(this.address, this.port, this.database, this.username, this.password);
    }

    private void configRetriever(InfluxDbMetricsRetriever retriever) {
        retriever.config(this.address, this.port, this.database, this.username, this.password);
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String addressStr = Tools.get((Dictionary)properties, (String)"address");
        this.address = addressStr != null ? addressStr : DEFAULT_ADDRESS;
        this.log.info("Configured. InfluxDB server address is {}", (Object)this.address);
        String databaseStr = Tools.get((Dictionary)properties, (String)"database");
        this.database = databaseStr != null ? databaseStr : "onos";
        this.log.info("Configured. InfluxDB server database is {}", (Object)this.database);
        String usernameStr = Tools.get((Dictionary)properties, (String)"username");
        this.username = usernameStr != null ? usernameStr : "onos";
        this.log.info("Configured. InfluxDB server username is {}", (Object)this.username);
        String passwordStr = Tools.get((Dictionary)properties, (String)"password");
        this.password = passwordStr != null ? passwordStr : DEFAULT_PASSWORD;
        this.log.info("Configured. InfluxDB server password is {}", (Object)this.password);
        Integer portConfigured = Tools.getIntegerProperty((Dictionary)properties, (String)"port");
        if (portConfigured == null) {
            this.port = 8086;
            this.log.info("InfluxDB port is not configured, default value is {}", (Object)this.port);
        } else {
            this.port = portConfigured;
            this.log.info("Configured. InfluxDB port is configured to {}", (Object)this.port);
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindInfluxDbMetricsReporter(InfluxDbMetricsReporter influxDbMetricsReporter) {
        this.influxDbMetricsReporter = influxDbMetricsReporter;
    }

    protected void unbindInfluxDbMetricsReporter(InfluxDbMetricsReporter influxDbMetricsReporter) {
        if (this.influxDbMetricsReporter == influxDbMetricsReporter) {
            this.influxDbMetricsReporter = null;
        }
    }

    protected void bindInfluxDbMetricsRetriever(InfluxDbMetricsRetriever influxDbMetricsRetriever) {
        this.influxDbMetricsRetriever = influxDbMetricsRetriever;
    }

    protected void unbindInfluxDbMetricsRetriever(InfluxDbMetricsRetriever influxDbMetricsRetriever) {
        if (this.influxDbMetricsRetriever == influxDbMetricsRetriever) {
            this.influxDbMetricsRetriever = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }
}

