/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.influxdbmetrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.izettle.metrics.influxdb.InfluxDbHttpSender;
import com.izettle.metrics.influxdb.InfluxDbReporter;
import com.izettle.metrics.influxdb.InfluxDbSender;
import java.util.Dictionary;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.metrics.MetricsReporter;
import org.onlab.metrics.MetricsService;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.CoreService;
import org.onosproject.influxdbmetrics.InfluxDbMetricsReporter;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultInfluxDbMetricsReporter
implements InfluxDbMetricsReporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int REPORT_PERIOD = 1;
    private static final TimeUnit REPORT_TIME_UNIT = TimeUnit.MINUTES;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_METRIC_NAMES = "default";
    private static final String SEPARATOR = ":";
    private static final int DEFAULT_CONN_TIMEOUT = 1000;
    private static final int DEFAULT_READ_TIMEOUT = 1000;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Property(name="monitorAll", boolValue={true}, label="Enable to monitor all of metrics stored in metric registry default is true")
    protected boolean monitorAll = true;
    @Property(name="metricNames", value={"default"}, label="Names of metric to be monitored in third party monitoring server; default metric names are 'default'")
    protected String metricNames = "default";
    protected String address;
    protected int port;
    protected String database;
    protected String username;
    protected String password;
    private InfluxDbReporter influxDbReporter;
    private InfluxDbHttpSender influxDbHttpSender;

    @Activate
    public void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.coreService.registerApplication("org.onosproject.influxdbmetrics");
        this.metricsService.registerReporter((MetricsReporter)this);
        this.startReport();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.stopReport();
        this.metricsService.unregisterReporter((MetricsReporter)this);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.restartReport();
    }

    public void startReport() {
        this.configSender();
        this.influxDbReporter = this.buildReporter(this.influxDbHttpSender);
        try {
            this.influxDbReporter.start(1L, REPORT_TIME_UNIT);
        }
        catch (Exception e) {
            this.log.error("Errors during reporting to InfluxDB, msg: {}" + e.getMessage());
        }
        this.log.info("Start to report metrics to influxDB.");
    }

    public void stopReport() {
        this.influxDbReporter.stop();
        this.influxDbHttpSender = null;
        this.influxDbReporter = null;
        this.log.info("Stop reporting metrics to influxDB.");
    }

    public void restartReport() {
        this.stopReport();
        this.startReport();
    }

    public void notifyMetricsChange() {
        this.influxDbReporter.stop();
        this.influxDbReporter = this.buildReporter(this.influxDbHttpSender);
        try {
            this.influxDbReporter.start(1L, REPORT_TIME_UNIT);
        }
        catch (Exception e) {
            this.log.error("Errors during reporting to InfluxDB, msg: {}" + e.getMessage());
        }
        this.log.info("Metric registry has been changed, apply changes.");
    }

    @Override
    public void config(String address, int port, String database, String username, String password) {
        this.address = address;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
    }

    protected MetricRegistry filter(MetricRegistry metricRegistry) {
        if (!this.monitorAll) {
            MetricRegistry filtered = new MetricRegistry();
            metricRegistry.getNames().stream().filter((? super T name) -> this.containsName((String)name, this.metricNames)).forEach(name -> filtered.register(name, (Metric)metricRegistry.getMetrics().get(name)));
            return filtered;
        }
        return metricRegistry;
    }

    protected MetricRegistry addHostPrefix(MetricRegistry metricRegistry) {
        MetricRegistry moddedRegistry = new MetricRegistry();
        ControllerNode node = this.clusterService.getLocalNode();
        String prefix = (String)node.id().id() + ".";
        metricRegistry.getNames().forEach(name -> moddedRegistry.register(prefix + name, (Metric)metricRegistry.getMetrics().get(name)));
        return moddedRegistry;
    }

    protected boolean containsName(String full, String prefixes) {
        String[] prefixArray;
        for (String prefix : prefixArray = StringUtils.split((String)prefixes, (String)",")) {
            if (!StringUtils.startsWith((String)full, (String)StringUtils.trimToEmpty((String)prefix))) continue;
            return true;
        }
        return false;
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String metricNameStr = Tools.get((Dictionary)properties, (String)"metricNames");
        this.metricNames = metricNameStr != null ? metricNameStr : DEFAULT_METRIC_NAMES;
        this.log.info("Configured. Metric name is {}", (Object)this.metricNames);
        Boolean monitorAllEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"monitorAll");
        if (monitorAllEnabled == null) {
            this.log.info("Monitor all metrics is not configured, using current value of {}", (Object)this.monitorAll);
        } else {
            this.monitorAll = monitorAllEnabled;
            this.log.info("Configured. Monitor all metrics is {}", (Object)(this.monitorAll ? "enabled" : "disabled"));
        }
    }

    private void configSender() {
        try {
            this.influxDbHttpSender = new InfluxDbHttpSender(DEFAULT_PROTOCOL, this.address, this.port, this.database, this.username + SEPARATOR + this.password, REPORT_TIME_UNIT, 1000, 1000);
        }
        catch (Exception e) {
            this.log.error("Fail to connect to given influxDB server!");
        }
    }

    private InfluxDbReporter buildReporter(InfluxDbHttpSender sender) {
        MetricRegistry mr = this.metricsService.getMetricRegistry();
        return InfluxDbReporter.forRegistry((MetricRegistry)this.addHostPrefix(this.filter(mr))).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build((InfluxDbSender)sender);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }
}

