/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pathpainter;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.topology.GeoDistanceLinkWeight;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.pathpainter.PathLink;
import org.onosproject.pathpainter.PathLinkMap;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.HostHighlight;
import org.onosproject.ui.topo.NodeBadge;
import org.onosproject.ui.topo.TopoJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPainterTopovMessageHandler
extends UiMessageHandler {
    private static final String PAINTER_CLEAR = "ppTopovClear";
    private static final String PAINTER_SET_SRC = "ppTopovSetSrc";
    private static final String PAINTER_SET_DST = "ppTopovSetDst";
    private static final String PAINTER_SWAP_SRC_DST = "ppTopovSwapSrcDst";
    private static final String PAINTER_SET_MODE = "ppTopovSetMode";
    private static final String PAINTER_NEXT_PATH = "ppTopovNextPath";
    private static final String PAINTER_PREV_PATH = "ppTopovPrevPath";
    private static final String ID = "id";
    private static final String MODE = "mode";
    private static final String TYPE = "type";
    private static final String SWITCH = "switch";
    private static final String ENDSTATION = "endstation";
    private static final String DST = "Dst";
    private static final String SRC = "Src";
    private static final int DELAY_MS = 1100;
    private final TopologyListener topologyListener = new InternalTopologyListener();
    private Set<Link> allPathLinks;
    private boolean listenersRemoved;
    private LinkWeight linkData;
    private int highlightDelay;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PathService pathService;
    private ElementId src;
    private ElementId dst;
    private String srcType;
    private String dstType;
    private Mode currentMode = Mode.SHORTEST;
    private List<Path> paths;
    private int pathIndex;
    protected TopologyService topologyService;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.pathService = (PathService)directory.get(PathService.class);
        this.topologyService = (TopologyService)directory.get(TopologyService.class);
        this.linkData = new GeoDistanceLinkWeight((DeviceService)directory.get(DeviceService.class));
        this.addListeners();
    }

    public void destroy() {
        this.removeListeners();
        super.destroy();
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new ClearHandler()), (Object)((Object)new SetSrcHandler()), (Object)((Object)new SetDstHandler()), (Object)((Object)new SwapSrcDstHandler()), (Object)((Object)new NextPathHandler()), (Object)((Object)new PrevPathHandler()), (Object[])new RequestHandler[]{new SetModeHandler()});
    }

    private ElementId elementId(String id) {
        try {
            return DeviceId.deviceId((String)id);
        }
        catch (IllegalArgumentException e) {
            return HostId.hostId((String)id);
        }
    }

    private void findAndSendPaths(Mode mode) {
        this.log.debug("src={}; dst={}; mode={}", new Object[]{this.src, this.dst, this.currentMode});
        if (this.src != null && this.dst != null) {
            this.pathIndex = 0;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (mode.equals((Object)Mode.SHORTEST)) {
                this.paths = ImmutableList.copyOf((Collection)this.pathService.getPaths(this.src, this.dst));
                this.allPathLinks = this.buildPaths((ImmutableSet.Builder<Link>)builder).build();
            } else if (mode.equals((Object)Mode.DISJOINT)) {
                this.paths = ImmutableList.copyOf((Collection)this.pathService.getDisjointPaths(this.src, this.dst));
                this.allPathLinks = this.buildDisjointPaths((ImmutableSet.Builder<Link>)builder).build();
            } else if (mode.equals((Object)Mode.GEODATA)) {
                this.paths = ImmutableList.copyOf((Collection)this.pathService.getPaths(this.src, this.dst, this.linkData));
                this.allPathLinks = this.buildPaths((ImmutableSet.Builder<Link>)builder).build();
            } else {
                this.log.warn("Unsupported MODE");
            }
        } else {
            this.paths = ImmutableList.of();
            this.allPathLinks = ImmutableSet.of();
        }
        this.hilightAndSendPaths();
    }

    private ImmutableSet.Builder<Link> buildPaths(ImmutableSet.Builder<Link> pathBuilder) {
        this.paths.forEach(path -> path.links().forEach(arg_0 -> ((ImmutableSet.Builder)pathBuilder).add(arg_0)));
        return pathBuilder;
    }

    private ImmutableSet.Builder<Link> buildDisjointPaths(ImmutableSet.Builder<Link> pathBuilder) {
        this.paths.forEach(path -> {
            DisjointPath dp = (DisjointPath)path;
            pathBuilder.addAll((Iterable)dp.primary().links());
            pathBuilder.addAll((Iterable)dp.backup().links());
        });
        return pathBuilder;
    }

    private void hilightAndSendPaths() {
        ImmutableSet selectedPathLinks;
        PathLinkMap linkMap = new PathLinkMap();
        this.allPathLinks.forEach(arg_0 -> ((PathLinkMap)linkMap).add(arg_0));
        if (this.currentMode.equals((Object)Mode.DISJOINT)) {
            DisjointPath dp = (DisjointPath)this.paths.get(this.pathIndex);
            selectedPathLinks = this.paths.isEmpty() ? ImmutableSet.of() : Sets.newHashSet((Iterable)dp.primary().links());
            selectedPathLinks.addAll(dp.backup().links());
        } else {
            selectedPathLinks = this.paths.isEmpty() ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)this.paths.get(this.pathIndex).links());
        }
        Highlights highlights = new Highlights();
        if (this.highlightDelay > 0) {
            highlights.delay(this.highlightDelay);
        }
        for (PathLink plink : linkMap.biLinks()) {
            plink.computeHilight((Set<Link>)selectedPathLinks, this.allPathLinks);
            highlights.add(plink.highlight(null));
        }
        if (this.src != null) {
            highlights = this.addBadge(highlights, this.srcType, this.src.toString(), SRC);
        }
        if (this.dst != null) {
            highlights = this.addBadge(highlights, this.dstType, this.dst.toString(), DST);
        }
        this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
    }

    private Highlights addBadge(Highlights highlights, String type, String elemId, String src) {
        if (SWITCH.equals(type)) {
            highlights = this.addDeviceBadge(highlights, elemId, src);
        } else if (ENDSTATION.equals(type)) {
            highlights = this.addHostBadge(highlights, elemId, src);
        }
        return highlights;
    }

    private Highlights addDeviceBadge(Highlights h, String elemId, String type) {
        DeviceHighlight dh = new DeviceHighlight(elemId);
        dh.setBadge(this.createBadge(type));
        h.add(dh);
        return h;
    }

    private Highlights addHostBadge(Highlights h, String elemId, String type) {
        HostHighlight hh = new HostHighlight(elemId);
        hh.setBadge(this.createBadge(type));
        h.add(hh);
        return h;
    }

    private NodeBadge createBadge(String type) {
        return NodeBadge.text((String)type);
    }

    private synchronized void addListeners() {
        this.listenersRemoved = false;
        this.topologyService.addListener((EventListener)this.topologyListener);
    }

    private synchronized void removeListeners() {
        if (!this.listenersRemoved) {
            this.listenersRemoved = true;
            this.topologyService.removeListener((EventListener)this.topologyListener);
        }
    }

    private class InternalTopologyListener
    implements TopologyListener {
        private InternalTopologyListener() {
        }

        public void event(TopologyEvent event) {
            PathPainterTopovMessageHandler.this.highlightDelay = 1100;
            PathPainterTopovMessageHandler.this.findAndSendPaths(PathPainterTopovMessageHandler.this.currentMode);
            PathPainterTopovMessageHandler.this.highlightDelay = 0;
        }
    }

    private final class SetModeHandler
    extends RequestHandler {
        public SetModeHandler() {
            super(PathPainterTopovMessageHandler.PAINTER_SET_MODE);
        }

        public void process(ObjectNode payload) {
            String mode;
            switch (mode = this.string(payload, PathPainterTopovMessageHandler.MODE)) {
                case "shortest": {
                    PathPainterTopovMessageHandler.this.currentMode = Mode.SHORTEST;
                    break;
                }
                case "disjoint": {
                    PathPainterTopovMessageHandler.this.currentMode = Mode.DISJOINT;
                    break;
                }
                case "geodata": {
                    PathPainterTopovMessageHandler.this.currentMode = Mode.GEODATA;
                    break;
                }
                case "srlg": {
                    PathPainterTopovMessageHandler.this.currentMode = Mode.SRLG;
                    break;
                }
                default: {
                    PathPainterTopovMessageHandler.this.currentMode = Mode.INVALID;
                }
            }
            PathPainterTopovMessageHandler.this.findAndSendPaths(PathPainterTopovMessageHandler.this.currentMode);
        }
    }

    private final class PrevPathHandler
    extends RequestHandler {
        public PrevPathHandler() {
            super(PathPainterTopovMessageHandler.PAINTER_PREV_PATH);
        }

        public void process(ObjectNode payload) {
            PathPainterTopovMessageHandler.this.pathIndex = PathPainterTopovMessageHandler.this.pathIndex <= 0 ? PathPainterTopovMessageHandler.this.paths.size() - 1 : PathPainterTopovMessageHandler.this.pathIndex - 1;
            PathPainterTopovMessageHandler.this.hilightAndSendPaths();
        }
    }

    private final class NextPathHandler
    extends RequestHandler {
        public NextPathHandler() {
            super(PathPainterTopovMessageHandler.PAINTER_NEXT_PATH);
        }

        public void process(ObjectNode payload) {
            PathPainterTopovMessageHandler.this.pathIndex = PathPainterTopovMessageHandler.this.pathIndex >= PathPainterTopovMessageHandler.this.paths.size() - 1 ? 0 : PathPainterTopovMessageHandler.this.pathIndex + 1;
            PathPainterTopovMessageHandler.this.hilightAndSendPaths();
        }
    }

    private final class SwapSrcDstHandler
    extends RequestHandler {
        public SwapSrcDstHandler() {
            super(PathPainterTopovMessageHandler.PAINTER_SWAP_SRC_DST);
        }

        public void process(ObjectNode payload) {
            ElementId temp = PathPainterTopovMessageHandler.this.src;
            PathPainterTopovMessageHandler.this.src = PathPainterTopovMessageHandler.this.dst;
            PathPainterTopovMessageHandler.this.dst = temp;
            String s = PathPainterTopovMessageHandler.this.srcType;
            PathPainterTopovMessageHandler.this.srcType = PathPainterTopovMessageHandler.this.dstType;
            PathPainterTopovMessageHandler.this.dstType = s;
            PathPainterTopovMessageHandler.this.findAndSendPaths(PathPainterTopovMessageHandler.this.currentMode);
        }
    }

    private final class SetDstHandler
    extends RequestHandler {
        public SetDstHandler() {
            super(PathPainterTopovMessageHandler.PAINTER_SET_DST);
        }

        public void process(ObjectNode payload) {
            String id = this.string(payload, PathPainterTopovMessageHandler.ID);
            PathPainterTopovMessageHandler.this.dst = PathPainterTopovMessageHandler.this.elementId(id);
            PathPainterTopovMessageHandler.this.dstType = this.string(payload, PathPainterTopovMessageHandler.TYPE);
            if (PathPainterTopovMessageHandler.this.src.equals(PathPainterTopovMessageHandler.this.dst)) {
                PathPainterTopovMessageHandler.this.src = null;
            }
            this.sendMessage(TopoJson.highlightsMessage((Highlights)PathPainterTopovMessageHandler.this.addBadge(new Highlights(), PathPainterTopovMessageHandler.this.dstType, PathPainterTopovMessageHandler.this.dst.toString(), PathPainterTopovMessageHandler.DST)));
            PathPainterTopovMessageHandler.this.findAndSendPaths(PathPainterTopovMessageHandler.this.currentMode);
        }
    }

    private final class SetSrcHandler
    extends RequestHandler {
        public SetSrcHandler() {
            super(PathPainterTopovMessageHandler.PAINTER_SET_SRC);
        }

        public void process(ObjectNode payload) {
            String id = this.string(payload, PathPainterTopovMessageHandler.ID);
            PathPainterTopovMessageHandler.this.src = PathPainterTopovMessageHandler.this.elementId(id);
            PathPainterTopovMessageHandler.this.srcType = this.string(payload, PathPainterTopovMessageHandler.TYPE);
            if (PathPainterTopovMessageHandler.this.src.equals(PathPainterTopovMessageHandler.this.dst)) {
                PathPainterTopovMessageHandler.this.dst = null;
            }
            this.sendMessage(TopoJson.highlightsMessage((Highlights)PathPainterTopovMessageHandler.this.addBadge(new Highlights(), PathPainterTopovMessageHandler.this.srcType, PathPainterTopovMessageHandler.this.src.toString(), PathPainterTopovMessageHandler.SRC)));
            PathPainterTopovMessageHandler.this.findAndSendPaths(PathPainterTopovMessageHandler.this.currentMode);
        }
    }

    private final class ClearHandler
    extends RequestHandler {
        public ClearHandler() {
            super(PathPainterTopovMessageHandler.PAINTER_CLEAR);
        }

        public void process(ObjectNode payload) {
            PathPainterTopovMessageHandler.this.src = null;
            PathPainterTopovMessageHandler.this.dst = null;
            this.sendMessage(TopoJson.highlightsMessage((Highlights)new Highlights()));
        }
    }

    private static enum Mode {
        SHORTEST,
        DISJOINT,
        GEODATA,
        SRLG,
        INVALID;

    }
}

