/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.onosproject.ui.topo.AbstractHighlight;
import org.onosproject.ui.topo.Mod;
import org.onosproject.ui.topo.TopoElementType;

public class LinkHighlight
extends AbstractHighlight {
    private static final String PLAIN = "plain";
    private static final String PRIMARY = "primary";
    private static final String SECONDARY = "secondary";
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private final Flavor flavor;
    private final Set<Mod> mods = new TreeSet<Mod>();
    private String label = "";
    public static final Mod MOD_OPTICAL = new Mod("optical");
    public static final Mod MOD_ANIMATED = new Mod("animated");

    public LinkHighlight(String linkId, Flavor flavor) {
        super(TopoElementType.LINK, linkId);
        this.flavor = (Flavor)((Object)Preconditions.checkNotNull((Object)((Object)flavor)));
    }

    public LinkHighlight addMod(Mod mod) {
        this.mods.add((Mod)Preconditions.checkNotNull((Object)mod));
        return this;
    }

    public LinkHighlight setLabel(String label) {
        this.label = label == null ? EMPTY : label;
        return this;
    }

    public Flavor flavor() {
        return this.flavor;
    }

    public Set<Mod> mods() {
        return Collections.unmodifiableSet(this.mods);
    }

    public String cssClasses() {
        StringBuilder sb = new StringBuilder(this.flavor.toString());
        this.mods.forEach(m -> sb.append(SPACE).append(m));
        return sb.toString();
    }

    public String label() {
        return this.label;
    }

    public static enum Flavor {
        NO_HIGHLIGHT("plain"),
        PRIMARY_HIGHLIGHT("primary"),
        SECONDARY_HIGHLIGHT("secondary");

        private String cssName;

        private Flavor(String s) {
            this.cssName = s;
        }

        public String toString() {
            return this.cssName;
        }
    }
}

