/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.ServiceBundle;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiDeviceLink;
import org.onosproject.ui.model.topo.UiEdgeLink;
import org.onosproject.ui.model.topo.UiElement;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiRegionDeviceLink;
import org.onosproject.ui.model.topo.UiRegionLink;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiTopology
extends UiElement {
    private static final String INDENT_1 = "  ";
    private static final String INDENT_2 = "    ";
    private static final String EOL = String.format("%n", new Object[0]);
    private static final String E_UNMAPPED = "Attempting to retrieve unmapped {}: {}";
    private static final String DEFAULT_TOPOLOGY_ID = "TOPOLOGY-0";
    private static final Logger log = LoggerFactory.getLogger(UiTopology.class);
    private static final Comparator<UiClusterMember> CLUSTER_MEMBER_COMPARATOR = Comparator.comparing(UiClusterMember::idAsString);
    private final Map<NodeId, UiClusterMember> cnodeLookup = new HashMap<NodeId, UiClusterMember>();
    private final Map<RegionId, UiRegion> regionLookup = new HashMap<RegionId, UiRegion>();
    private final Map<DeviceId, UiDevice> deviceLookup = new HashMap<DeviceId, UiDevice>();
    private final Map<HostId, UiHost> hostLookup = new HashMap<HostId, UiHost>();
    private final Map<UiLinkId, UiDeviceLink> devLinkLookup = new HashMap<UiLinkId, UiDeviceLink>();
    private final Map<UiLinkId, UiEdgeLink> edgeLinkLookup = new HashMap<UiLinkId, UiEdgeLink>();
    private final Map<UiLinkId, UiSynthLink> synthMap = new HashMap<UiLinkId, UiSynthLink>();
    private final UiRegion nullRegion = new UiRegion(this, null);
    final ServiceBundle services;

    public UiTopology(ServiceBundle services) {
        this.services = services;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("#cnodes", this.clusterMemberCount()).add("#regions", this.regionCount()).add("#devices", this.deviceLookup.size()).add("#hosts", this.hostLookup.size()).add("#dev-links", this.devLinkLookup.size()).add("#edge-links", this.edgeLinkLookup.size()).add("#synth-links", this.synthMap.size()).toString();
    }

    @Override
    public String idAsString() {
        return DEFAULT_TOPOLOGY_ID;
    }

    public void clear() {
        log.debug("clearing topology model");
        this.cnodeLookup.clear();
        this.regionLookup.clear();
        this.deviceLookup.clear();
        this.hostLookup.clear();
        this.devLinkLookup.clear();
        this.edgeLinkLookup.clear();
        this.synthMap.clear();
        this.nullRegion.destroy();
    }

    public List<UiClusterMember> allClusterMembers() {
        ArrayList<UiClusterMember> members = new ArrayList<UiClusterMember>(this.cnodeLookup.values());
        Collections.sort(members, CLUSTER_MEMBER_COMPARATOR);
        return members;
    }

    public UiClusterMember findClusterMember(NodeId id) {
        return this.cnodeLookup.get(id);
    }

    public void add(UiClusterMember member) {
        this.cnodeLookup.put(member.id(), member);
    }

    public void remove(UiClusterMember member) {
        UiClusterMember m = this.cnodeLookup.remove(member.id());
        if (m != null) {
            m.destroy();
        }
    }

    public int clusterMemberCount() {
        return this.cnodeLookup.size();
    }

    public Set<UiRegion> allRegions() {
        return new HashSet<UiRegion>(this.regionLookup.values());
    }

    public UiRegion nullRegion() {
        return this.nullRegion;
    }

    public UiRegion findRegion(RegionId id) {
        return UiRegion.NULL_ID.equals((Object)id) ? this.nullRegion() : this.regionLookup.get((Object)id);
    }

    public void add(UiRegion uiRegion) {
        this.regionLookup.put(uiRegion.id(), uiRegion);
    }

    public void remove(UiRegion uiRegion) {
        UiRegion r = this.regionLookup.remove((Object)uiRegion.id());
        if (r != null) {
            r.destroy();
        }
    }

    public int regionCount() {
        return this.regionLookup.size();
    }

    public Set<UiDevice> allDevices() {
        return new HashSet<UiDevice>(this.deviceLookup.values());
    }

    public UiDevice findDevice(DeviceId id) {
        return this.deviceLookup.get(id);
    }

    public void add(UiDevice uiDevice) {
        this.deviceLookup.put(uiDevice.id(), uiDevice);
    }

    public void remove(UiDevice uiDevice) {
        UiDevice d = this.deviceLookup.remove(uiDevice.id());
        if (d != null) {
            d.destroy();
        }
    }

    public int deviceCount() {
        return this.deviceLookup.size();
    }

    public Set<UiDeviceLink> allDeviceLinks() {
        return new HashSet<UiDeviceLink>(this.devLinkLookup.values());
    }

    public UiDeviceLink findDeviceLink(UiLinkId id) {
        return this.devLinkLookup.get(id);
    }

    public UiEdgeLink findEdgeLink(UiLinkId id) {
        return this.edgeLinkLookup.get(id);
    }

    public void add(UiDeviceLink uiDeviceLink) {
        this.devLinkLookup.put(uiDeviceLink.id(), uiDeviceLink);
    }

    public void add(UiEdgeLink uiEdgeLink) {
        this.edgeLinkLookup.put(uiEdgeLink.id(), uiEdgeLink);
    }

    public void remove(UiDeviceLink uiDeviceLink) {
        UiDeviceLink link = this.devLinkLookup.remove(uiDeviceLink.id());
        if (link != null) {
            link.destroy();
        }
    }

    public void remove(UiEdgeLink uiEdgeLink) {
        UiEdgeLink link = this.edgeLinkLookup.remove(uiEdgeLink.id());
        if (link != null) {
            link.destroy();
        }
    }

    public int deviceLinkCount() {
        return this.devLinkLookup.size();
    }

    public int edgeLinkCount() {
        return this.edgeLinkLookup.size();
    }

    public Set<UiHost> allHosts() {
        return new HashSet<UiHost>(this.hostLookup.values());
    }

    public UiHost findHost(HostId id) {
        return this.hostLookup.get(id);
    }

    public void add(UiHost uiHost) {
        this.hostLookup.put(uiHost.id(), uiHost);
    }

    public void remove(UiHost uiHost) {
        UiHost h = this.hostLookup.remove(uiHost.id());
        if (h != null) {
            h.destroy();
        }
    }

    public int hostCount() {
        return this.hostLookup.size();
    }

    Set<UiDevice> deviceSet(Set<DeviceId> deviceIds) {
        HashSet<UiDevice> uiDevices = new HashSet<UiDevice>();
        for (DeviceId id : deviceIds) {
            UiDevice d = this.deviceLookup.get(id);
            if (d != null) {
                uiDevices.add(d);
                continue;
            }
            log.warn(E_UNMAPPED, (Object)"device", (Object)id);
        }
        return uiDevices;
    }

    Set<UiHost> hostSet(Set<HostId> hostIds) {
        HashSet<UiHost> uiHosts = new HashSet<UiHost>();
        for (HostId id : hostIds) {
            UiHost h = this.hostLookup.get(id);
            if (h != null) {
                uiHosts.add(h);
                continue;
            }
            log.warn(E_UNMAPPED, (Object)"host", (Object)id);
        }
        return uiHosts;
    }

    Set<UiDeviceLink> linkSet(Set<UiLinkId> uiLinkIds) {
        HashSet<UiDeviceLink> result = new HashSet<UiDeviceLink>();
        for (UiLinkId id : uiLinkIds) {
            UiDeviceLink link = this.devLinkLookup.get(id);
            if (link != null) {
                result.add(link);
                continue;
            }
            log.warn(E_UNMAPPED, (Object)"device link", (Object)id);
        }
        return result;
    }

    public void computeSynthLinks() {
        ArrayList<UiSynthLink> slinks = new ArrayList<UiSynthLink>();
        this.allDeviceLinks().forEach(link -> {
            UiSynthLink synthetic = this.inferSyntheticLink((UiDeviceLink)link);
            slinks.add(synthetic);
            log.debug("Synthetic link: {}", (Object)synthetic);
        });
        slinks.addAll(this.wrapHostLinks(this.nullRegion()));
        for (UiRegion r : this.allRegions()) {
            slinks.addAll(this.wrapHostLinks(r));
        }
        this.synthMap.clear();
        for (UiSynthLink sl : slinks) {
            this.synthMap.put(sl.original().id(), sl);
        }
    }

    private Set<UiSynthLink> wrapHostLinks(UiRegion region) {
        RegionId regionId = region.id();
        return region.hosts().stream().map(h -> this.wrapHostLink(regionId, (UiHost)h)).collect(Collectors.toSet());
    }

    private UiSynthLink wrapHostLink(RegionId regionId, UiHost host) {
        UiEdgeLink elink = new UiEdgeLink(this, host.edgeLinkId());
        return new UiSynthLink(regionId, elink, elink);
    }

    private UiSynthLink inferSyntheticLink(UiDeviceLink link) {
        DeviceId a = link.deviceA();
        DeviceId b = link.deviceB();
        List<RegionId> aBranch = this.ancestors(a);
        List<RegionId> bBranch = this.ancestors(b);
        if (aBranch == null || bBranch == null) {
            return null;
        }
        return this.makeSynthLink(link, aBranch, bBranch);
    }

    UiSynthLink makeSynthLink(UiDeviceLink orig, List<RegionId> aBranch, List<RegionId> bBranch) {
        UiLink link;
        UiLinkId linkId;
        RegionId rB;
        RegionId rA;
        int next;
        int aSize = aBranch.size();
        int bSize = bBranch.size();
        int min = Math.min(aSize, bSize);
        int index = 0;
        RegionId commonRegion = aBranch.get(index);
        while ((next = index + 1) != min && (rA = aBranch.get(next)).equals((Object)(rB = bBranch.get(next)))) {
            commonRegion = rA;
            ++index;
        }
        int endPointIndex = index + 1;
        if (endPointIndex < aSize) {
            RegionId aRegion = aBranch.get(endPointIndex);
            if (endPointIndex < bSize) {
                RegionId bRegion = bBranch.get(endPointIndex);
                linkId = UiLinkId.uiLinkId(aRegion, bRegion);
                link = new UiRegionLink(this, linkId);
            } else {
                DeviceId dB = orig.deviceB();
                PortNumber pB = orig.portB();
                linkId = UiLinkId.uiLinkId(aRegion, dB, pB);
                link = new UiRegionDeviceLink(this, linkId);
            }
        } else {
            DeviceId dA = orig.deviceA();
            PortNumber pA = orig.portA();
            if (endPointIndex < bSize) {
                RegionId bRegion = bBranch.get(endPointIndex);
                linkId = UiLinkId.uiLinkId(bRegion, dA, pA);
                link = new UiRegionDeviceLink(this, linkId);
            } else {
                link = orig;
            }
        }
        return new UiSynthLink(commonRegion, link, orig);
    }

    private List<RegionId> ancestors(DeviceId id) {
        UiDevice dev = this.findDevice(id);
        if (dev == null) {
            log.warn("Unable to find cached device with ID %s", (Object)id);
            return null;
        }
        ArrayList<RegionId> result = new ArrayList<RegionId>();
        for (UiRegion r = dev.uiRegion(); r != null && !r.isRoot(); r = r.parentRegion()) {
            result.add(0, r.id());
        }
        result.add(0, UiRegion.NULL_ID);
        return result;
    }

    public List<UiSynthLink> findSynthLinks(RegionId regionId) {
        return this.synthMap.values().stream().filter(s -> Objects.equals((Object)regionId, (Object)s.regionId())).collect(Collectors.toList());
    }

    public int synthLinkCount() {
        return this.synthMap.size();
    }

    public String dumpString() {
        StringBuilder sb = new StringBuilder("Topology:").append(EOL);
        sb.append(INDENT_1).append("Cluster Members").append(EOL);
        for (UiClusterMember uiClusterMember : this.cnodeLookup.values()) {
            sb.append(INDENT_2).append(uiClusterMember).append(EOL);
        }
        sb.append(INDENT_1).append("Regions").append(EOL);
        for (UiRegion uiRegion : this.regionLookup.values()) {
            sb.append(INDENT_2).append(uiRegion).append(EOL);
        }
        sb.append(INDENT_1).append("Devices").append(EOL);
        for (UiDevice uiDevice : this.deviceLookup.values()) {
            sb.append(INDENT_2).append(uiDevice).append(EOL);
        }
        sb.append(INDENT_1).append("Hosts").append(EOL);
        for (UiHost uiHost : this.hostLookup.values()) {
            sb.append(INDENT_2).append(uiHost).append(EOL);
        }
        sb.append(INDENT_1).append("Device Links").append(EOL);
        for (UiLink uiLink : this.devLinkLookup.values()) {
            sb.append(INDENT_2).append(uiLink).append(EOL);
        }
        sb.append(INDENT_1).append("Edge Links").append(EOL);
        for (UiLink uiLink : this.edgeLinkLookup.values()) {
            sb.append(INDENT_2).append(uiLink).append(EOL);
        }
        sb.append(INDENT_1).append("Synth Links").append(EOL);
        for (UiSynthLink uiSynthLink : this.synthMap.values()) {
            sb.append(INDENT_2).append(uiSynthLink).append(EOL);
        }
        sb.append("------").append(EOL);
        return sb.toString();
    }
}

