/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Versioned;

public final class ConsistentMapBackedJavaMap<K, V>
implements Map<K, V> {
    private final ConsistentMap<K, V> backingMap;

    public ConsistentMapBackedJavaMap(ConsistentMap<K, V> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return Versioned.valueOrNull(this.backingMap.get(key));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return Versioned.valueOrElse(this.backingMap.get(key), defaultValue);
    }

    @Override
    public V put(K key, V value) {
        return Versioned.valueOrNull(this.backingMap.put(key, value));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return Versioned.valueOrNull(this.backingMap.putIfAbsent(key, value));
    }

    @Override
    public V remove(Object key) {
        return Versioned.valueOrNull(this.backingMap.remove(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.backingMap.remove(key, value);
    }

    @Override
    public V replace(K key, V value) {
        return Versioned.valueOrNull(this.backingMap.replace(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.backingMap.replace(key, oldValue, newValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach((k, v) -> this.backingMap.put(k, v));
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Versioned.valueOrNull(this.backingMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return Versioned.valueOrNull(this.backingMap.computeIfAbsent((K)key, mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Versioned.valueOrNull(this.backingMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return Collections2.transform(this.backingMap.values(), v -> v.value());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), ((Versioned)entry.getValue()).value())).collect(Collectors.toSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator<Map.Entry<K, Versioned<V>>> it = this.backingMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, Versioned<V>> entry = it.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue().value());
            if (!it.hasNext()) continue;
            sb.append(',').append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.entrySet().forEach((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.computeIfPresent(key, (k, v) -> v == null ? value : remappingFunction.apply((Object)v, (Object)value));
    }
}

