/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic;

import com.google.common.base.Preconditions;

public final class PollInterval {
    private static final long DEFAULT_POLL_INTERVAL = 10L;
    private static final long DEFAULT_MID_POLL_INTERVAL = 20L;
    private static final long DEFAULT_LONG_POLL_INTERVAL = 30L;
    private static final long DEFAULT_ENTIRE_POLL_INTERVAL = 60L;
    private static PollInterval pollIntervalInstance = new PollInterval(10L, 20L, 30L, 60L);
    private long pollInterval = 10L;
    private long midPollInterval = 20L;
    private long longPollInterval = 30L;
    private long entirePollInterval = 60L;

    public static PollInterval getInstance() {
        return pollIntervalInstance;
    }

    protected PollInterval() {
        this.pollInterval = 10L;
        this.midPollInterval = 20L;
        this.longPollInterval = 30L;
        this.entirePollInterval = 60L;
    }

    private PollInterval(long pollInterval, long midPollInterval, long longPollInterval, long entirePollInterval) {
        Preconditions.checkArgument((pollInterval > 0L ? 1 : 0) != 0, (Object)"Poll interval must be greater than 0");
        Preconditions.checkArgument((midPollInterval > 0L && midPollInterval > pollInterval ? 1 : 0) != 0, (Object)"Mid poll interval must be greater than 0 and pollInterval");
        Preconditions.checkArgument((longPollInterval > 0L && longPollInterval > midPollInterval ? 1 : 0) != 0, (Object)"Long poll interval must be greater than 0 and midPollInterval");
        Preconditions.checkArgument((entirePollInterval > 0L && entirePollInterval > longPollInterval ? 1 : 0) != 0, (Object)"Entire poll interval must be greater than 0 and longPollInterval");
        this.pollInterval = pollInterval;
        this.midPollInterval = midPollInterval;
        this.longPollInterval = longPollInterval;
        this.entirePollInterval = entirePollInterval;
    }

    public void setPollInterval(long newPollInterval) {
        Preconditions.checkArgument((newPollInterval > 0L ? 1 : 0) != 0, (Object)"Poll interval must be greater than 0");
        this.pollInterval = newPollInterval;
    }

    public void setMidPollInterval(long newPollInterval) {
        Preconditions.checkArgument((newPollInterval > 0L && newPollInterval > this.pollInterval ? 1 : 0) != 0, (Object)"Mid poll interval must be greater than 0 and pollInterval");
        this.midPollInterval = newPollInterval;
    }

    public void setLongPollInterval(long newPollInterval) {
        Preconditions.checkArgument((newPollInterval > 0L && newPollInterval > this.midPollInterval ? 1 : 0) != 0, (Object)"Long poll interval must be greater than 0 and midPollInterval");
        this.longPollInterval = newPollInterval;
    }

    public void setEntirePollInterval(long newPollInterval) {
        Preconditions.checkArgument((newPollInterval > 0L && newPollInterval > this.longPollInterval ? 1 : 0) != 0, (Object)"Entire poll interval must be greater than 0 and longPollInterval");
        this.entirePollInterval = newPollInterval;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public long getMidPollInterval() {
        return this.midPollInterval;
    }

    public long getLongPollInterval() {
        return this.longPollInterval;
    }

    public long getEntirePollInterval() {
        return this.entirePollInterval;
    }

    public long getAvgPollInterval() {
        return (this.pollInterval + this.midPollInterval + this.longPollInterval) / 3L;
    }
}

