/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.base.Preconditions;
import org.onosproject.net.packet.PacketContext;

public interface PacketProcessor {
    public static final int ADVISOR_MAX = 0x2AAAAAAA;
    public static final int DIRECTOR_MAX = 0x55555554;
    public static final int OBSERVER_MAX = Integer.MAX_VALUE;

    public static int advisor(int priority) {
        int overallPriority = priority + 1;
        Preconditions.checkArgument((overallPriority > 0 && overallPriority <= 0x2AAAAAAA ? 1 : 0) != 0, (Object)"Priority not within ADVISOR range");
        return overallPriority;
    }

    public static int director(int priority) {
        int overallPriority = 0x2AAAAAAA + priority + 1;
        Preconditions.checkArgument((overallPriority > 0x2AAAAAAA && overallPriority <= 0x55555554 ? 1 : 0) != 0, (Object)"Priority not within DIRECTOR range");
        return overallPriority;
    }

    public static int observer(int priority) {
        int overallPriority = 0x55555554 + priority + 1;
        Preconditions.checkArgument((overallPriority > 0x55555554 ? 1 : 0) != 0, (Object)"Priority not within OBSERVER range");
        return overallPriority;
    }

    public void process(PacketContext var1);
}

