/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.onlab.packet.Ethernet;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.packet.InboundPacket;

public final class DefaultInboundPacket
implements InboundPacket {
    private final ConnectPoint receivedFrom;
    private final Ethernet parsed;
    private final ByteBuffer unparsed;
    private final Optional<Long> cookie;

    public DefaultInboundPacket(ConnectPoint receivedFrom, Ethernet parsed, ByteBuffer unparsed) {
        this(receivedFrom, parsed, unparsed, Optional.empty());
    }

    public DefaultInboundPacket(ConnectPoint receivedFrom, Ethernet parsed, ByteBuffer unparsed, Optional<Long> cookie) {
        this.receivedFrom = receivedFrom;
        this.parsed = parsed;
        this.unparsed = unparsed;
        this.cookie = cookie;
    }

    @Override
    public ConnectPoint receivedFrom() {
        return this.receivedFrom;
    }

    @Override
    public Ethernet parsed() {
        return this.parsed;
    }

    @Override
    public ByteBuffer unparsed() {
        return this.unparsed;
    }

    @Override
    public Optional<Long> cookie() {
        return this.cookie;
    }

    public int hashCode() {
        return Objects.hash(this.receivedFrom, this.parsed, this.unparsed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InboundPacket) {
            DefaultInboundPacket other = (DefaultInboundPacket)obj;
            return Objects.equals(this.receivedFrom, other.receivedFrom) && Objects.equals(this.parsed, other.parsed) && Objects.equals(this.unparsed, other.unparsed);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("receivedFrom", (Object)this.receivedFrom).add("parsed", (Object)this.parsed).toString();
    }
}

