/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentOperationContext;

public class IntentInstallationContext {
    private IntentData toUninstall;
    private IntentData toInstall;
    private Set<IntentOperationContext> pendingContexts = Sets.newConcurrentHashSet();
    private Set<IntentOperationContext> errorContexts = Sets.newConcurrentHashSet();

    public IntentInstallationContext(IntentData toUninstall, IntentData toInstall) {
        this.toUninstall = toUninstall;
        this.toInstall = toInstall;
    }

    public void removePendingContext(IntentOperationContext context) {
        this.pendingContexts.remove(context);
    }

    public void addPendingContext(IntentOperationContext context) {
        this.pendingContexts.add(context);
    }

    public void addErrorContext(IntentOperationContext context) {
        this.errorContexts.add(context);
    }

    public Set<IntentOperationContext> pendingContexts() {
        return ImmutableSet.copyOf(this.pendingContexts);
    }

    public Set<IntentOperationContext> errorContexts() {
        return ImmutableSet.copyOf(this.errorContexts);
    }

    public synchronized boolean isPendingContextsEmpty() {
        return this.pendingContexts.isEmpty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pendingContexts", this.pendingContexts).add("errorContexts", this.errorContexts).toString();
    }

    public Optional<IntentData> toUninstall() {
        return Optional.ofNullable(this.toUninstall);
    }

    public Optional<IntentData> toInstall() {
        return Optional.ofNullable(this.toInstall);
    }
}

