/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.store.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class IntentData {
    private static final Logger log = LoggerFactory.getLogger(IntentData.class);
    private final Intent intent;
    private final IntentState request;
    private IntentState state;
    private final Timestamp version;
    private int internalStateVersion;
    private NodeId origin;
    private int errorCount;
    private List<Intent> installables;

    public static IntentData submit(Intent intent) {
        return new IntentData((Intent)Preconditions.checkNotNull((Object)intent), IntentState.INSTALL_REQ);
    }

    public static IntentData withdraw(Intent intent) {
        return new IntentData((Intent)Preconditions.checkNotNull((Object)intent), IntentState.WITHDRAW_REQ);
    }

    public static IntentData purge(Intent intent) {
        return new IntentData((Intent)Preconditions.checkNotNull((Object)intent), IntentState.PURGE_REQ);
    }

    public static IntentData assign(IntentData data, Timestamp timestamp, NodeId node) {
        IntentData assigned = new IntentData(data, (Timestamp)Preconditions.checkNotNull((Object)timestamp));
        assigned.origin = (NodeId)Preconditions.checkNotNull((Object)node);
        ++assigned.internalStateVersion;
        return assigned;
    }

    public static IntentData copy(IntentData data) {
        return new IntentData(data);
    }

    public static IntentData nextState(IntentData data, IntentState nextState) {
        IntentData next = new IntentData(data);
        next.setState((IntentState)((Object)Preconditions.checkNotNull((Object)((Object)nextState))));
        return next;
    }

    public static IntentData corrupt(IntentData data) {
        IntentData next = new IntentData(data);
        next.setState(IntentState.CORRUPT);
        next.incrementErrorCount();
        return next;
    }

    public static IntentData compiled(IntentData data, List<Intent> installables) {
        return new IntentData(data, (List)Preconditions.checkNotNull(installables));
    }

    private IntentData(Intent intent, IntentState reqState) {
        this.intent = (Intent)Preconditions.checkNotNull((Object)intent);
        this.request = (IntentState)((Object)Preconditions.checkNotNull((Object)((Object)reqState)));
        this.version = null;
        this.state = reqState;
        this.installables = ImmutableList.of();
    }

    private IntentData(IntentData original, Timestamp newReqVersion) {
        this.intent = original.intent;
        this.state = original.state;
        this.request = original.request;
        this.version = newReqVersion;
        this.internalStateVersion = original.internalStateVersion;
        this.origin = original.origin;
        this.installables = original.installables;
        this.errorCount = original.errorCount;
    }

    @Deprecated
    public IntentData(Intent intent, IntentState state, Timestamp version) {
        Preconditions.checkNotNull((Object)intent);
        Preconditions.checkNotNull((Object)((Object)state));
        this.intent = intent;
        this.state = state;
        this.request = state;
        this.version = version;
    }

    @Deprecated
    public IntentData(Intent intent, IntentState state, Timestamp version, NodeId origin) {
        Preconditions.checkNotNull((Object)intent);
        Preconditions.checkNotNull((Object)((Object)state));
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkNotNull((Object)origin);
        this.intent = intent;
        this.state = state;
        this.request = state;
        this.version = version;
        this.origin = origin;
    }

    @Deprecated
    public IntentData(Intent intent, IntentState state, IntentState request, Timestamp version, NodeId origin) {
        Preconditions.checkNotNull((Object)intent);
        Preconditions.checkNotNull((Object)((Object)state));
        Preconditions.checkNotNull((Object)((Object)request));
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkNotNull((Object)origin);
        this.intent = intent;
        this.state = state;
        this.request = request;
        this.version = version;
        this.origin = origin;
    }

    @Deprecated
    public IntentData(IntentData intentData) {
        Preconditions.checkNotNull((Object)intentData);
        this.intent = intentData.intent;
        this.state = intentData.state;
        this.request = intentData.request;
        this.version = intentData.version;
        this.internalStateVersion = intentData.internalStateVersion;
        this.origin = intentData.origin;
        this.installables = intentData.installables;
        this.errorCount = intentData.errorCount;
    }

    @Deprecated
    public IntentData(IntentData original, List<Intent> installables) {
        this(original);
        ++this.internalStateVersion;
        this.installables = ((List)Preconditions.checkNotNull(installables)).isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(installables);
    }

    protected IntentData() {
        this.intent = null;
        this.request = null;
        this.version = null;
    }

    public Intent intent() {
        return this.intent;
    }

    public IntentState state() {
        return this.state;
    }

    public IntentState request() {
        return this.request;
    }

    public Key key() {
        return this.intent.key();
    }

    public Timestamp version() {
        return this.version;
    }

    public int internalStateVersion() {
        return this.internalStateVersion;
    }

    public NodeId origin() {
        return this.origin;
    }

    public void setState(IntentState newState) {
        ++this.internalStateVersion;
        this.state = newState;
    }

    public void incrementErrorCount() {
        ++this.errorCount;
    }

    public void setErrorCount(int newCount) {
        this.errorCount = newCount;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public List<Intent> installables() {
        return this.installables != null ? this.installables : Collections.emptyList();
    }

    public static boolean isUpdateAcceptable(IntentData currentData, IntentData newData) {
        if (currentData == null) {
            return true;
        }
        if (currentData.version().isOlderThan(newData.version())) {
            return true;
        }
        if (currentData.version().isNewerThan(newData.version())) {
            return false;
        }
        assert (currentData.version().equals(newData.version()));
        if (currentData.internalStateVersion >= newData.internalStateVersion) {
            log.trace("{} update not acceptable: current is newer internally", (Object)newData.key());
            return false;
        }
        IntentState currentState = currentData.state();
        IntentState newState = newData.state();
        switch (newState) {
            case INSTALLING: {
                if (currentState == IntentState.INSTALLING) {
                    return false;
                }
            }
            case INSTALLED: {
                if (currentState == IntentState.INSTALLED) {
                    return false;
                }
                if (currentState == IntentState.WITHDRAWING || currentState == IntentState.WITHDRAWN || currentState == IntentState.PURGE_REQ) {
                    log.warn("Invalid state transition from {} to {} for intent {}", new Object[]{currentState, newState, newData.key()});
                    return false;
                }
                return true;
            }
            case WITHDRAWING: {
                if (currentState == IntentState.WITHDRAWING) {
                    return false;
                }
            }
            case WITHDRAWN: {
                if (currentState == IntentState.WITHDRAWN) {
                    return false;
                }
                if (currentState == IntentState.INSTALLING || currentState == IntentState.INSTALLED || currentState == IntentState.PURGE_REQ) {
                    log.warn("Invalid state transition from {} to {} for intent {}", new Object[]{currentState, newState, newData.key()});
                    return false;
                }
                return true;
            }
            case FAILED: {
                return currentState != IntentState.FAILED;
            }
            case CORRUPT: {
                return currentState != IntentState.CORRUPT;
            }
            case PURGE_REQ: {
                return true;
            }
        }
        log.warn("Invalid state {} for intent {}", (Object)newState, (Object)newData.key());
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.intent, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntentData other = (IntentData)obj;
        return Objects.equals(this.intent, other.intent) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key()).add("state", (Object)this.state()).add("version", (Object)this.version()).add("internalStateVersion", this.internalStateVersion).add("intent", (Object)this.intent()).add("origin", (Object)this.origin()).add("installables", this.installables()).toString();
    }
}

