/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class IPDscpCriterion
implements Criterion {
    private static final byte MASK = 63;
    private final byte ipDscp;

    IPDscpCriterion(byte ipDscp) {
        this.ipDscp = (byte)(ipDscp & 0x3F);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.IP_DSCP;
    }

    public byte ipDscp() {
        return this.ipDscp;
    }

    public String toString() {
        return this.type().toString() + ":" + Long.toHexString(this.ipDscp);
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.ipDscp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPDscpCriterion) {
            IPDscpCriterion that = (IPDscpCriterion)obj;
            return Objects.equals(this.ipDscp, that.ipDscp) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

