/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperation;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.NullFlowRuleOperationsContext;

public class FlowRuleOperations {
    private final List<Set<FlowRuleOperation>> stages;
    private final FlowRuleOperationsContext callback;

    private FlowRuleOperations(List<Set<FlowRuleOperation>> stages, FlowRuleOperationsContext cb) {
        this.stages = stages;
        this.callback = cb;
    }

    protected FlowRuleOperations() {
        this.stages = Lists.newArrayList();
        this.callback = null;
    }

    public List<Set<FlowRuleOperation>> stages() {
        return this.stages;
    }

    public FlowRuleOperationsContext callback() {
        return this.callback;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stages", this.stages).toString();
    }

    public static final class Builder {
        private final ImmutableList.Builder<Set<FlowRuleOperation>> listBuilder = ImmutableList.builder();
        private ImmutableSet.Builder<FlowRuleOperation> currentStage = ImmutableSet.builder();

        private Builder() {
        }

        public Builder add(FlowRule flowRule) {
            this.currentStage.add((Object)new FlowRuleOperation(flowRule, FlowRuleOperation.Type.ADD));
            return this;
        }

        public Builder operation(FlowRuleOperation flowRuleOperation) {
            this.currentStage.add((Object)flowRuleOperation);
            return this;
        }

        public Builder modify(FlowRule flowRule) {
            this.currentStage.add((Object)new FlowRuleOperation(flowRule, FlowRuleOperation.Type.MODIFY));
            return this;
        }

        public Builder remove(FlowRule flowRule) {
            this.currentStage.add((Object)new FlowRuleOperation(flowRule, FlowRuleOperation.Type.REMOVE));
            return this;
        }

        private void closeStage() {
            ImmutableSet stage = this.currentStage.build();
            if (!stage.isEmpty()) {
                this.listBuilder.add((Object)stage);
            }
        }

        public Builder newStage() {
            this.closeStage();
            this.currentStage = ImmutableSet.builder();
            return this;
        }

        public FlowRuleOperations build() {
            return this.build(NullFlowRuleOperationsContext.getInstance());
        }

        public FlowRuleOperations build(FlowRuleOperationsContext cb) {
            Preconditions.checkNotNull((Object)cb);
            this.closeStage();
            return new FlowRuleOperations((List)this.listBuilder.build(), cb);
        }
    }
}

