/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.google.common.base.Preconditions;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.LinkKey;
import org.onosproject.net.config.SubjectFactory;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public final class SubjectFactories {
    private static CoreService coreService;
    public static final SubjectFactory<ApplicationId> APP_SUBJECT_FACTORY;
    public static final SubjectFactory<DeviceId> DEVICE_SUBJECT_FACTORY;
    public static final SubjectFactory<ConnectPoint> CONNECT_POINT_SUBJECT_FACTORY;
    public static final SubjectFactory<HostId> HOST_SUBJECT_FACTORY;
    public static final SubjectFactory<LinkKey> LINK_SUBJECT_FACTORY;
    public static final SubjectFactory<RegionId> REGION_SUBJECT_FACTORY;
    public static final SubjectFactory<UiTopoLayoutId> LAYOUT_SUBJECT_FACTORY;

    private SubjectFactories() {
    }

    public static void setCoreService(CoreService service) {
        coreService = service;
    }

    private static String key(ConnectPoint subject) {
        return subject.deviceId() + "/" + subject.port();
    }

    static {
        APP_SUBJECT_FACTORY = new SubjectFactory<ApplicationId>(ApplicationId.class, "apps"){

            @Override
            public ApplicationId createSubject(String key) {
                return coreService.registerApplication(key);
            }

            @Override
            public String subjectKey(ApplicationId subject) {
                return subject.name();
            }
        };
        DEVICE_SUBJECT_FACTORY = new SubjectFactory<DeviceId>(DeviceId.class, "devices"){

            @Override
            public DeviceId createSubject(String key) {
                return DeviceId.deviceId(key);
            }
        };
        CONNECT_POINT_SUBJECT_FACTORY = new SubjectFactory<ConnectPoint>(ConnectPoint.class, "ports"){

            @Override
            public ConnectPoint createSubject(String key) {
                return ConnectPoint.deviceConnectPoint(key);
            }

            @Override
            public String subjectKey(ConnectPoint subject) {
                return SubjectFactories.key(subject);
            }
        };
        HOST_SUBJECT_FACTORY = new SubjectFactory<HostId>(HostId.class, "hosts"){

            @Override
            public HostId createSubject(String key) {
                return HostId.hostId(key);
            }
        };
        LINK_SUBJECT_FACTORY = new SubjectFactory<LinkKey>(LinkKey.class, "links"){

            @Override
            public LinkKey createSubject(String key) {
                String[] cps = key.split("-");
                Preconditions.checkArgument((cps.length == 2 ? 1 : 0) != 0, (String)"Incorrect link key format: %s", (Object)key);
                return LinkKey.linkKey(ConnectPoint.deviceConnectPoint(cps[0]), ConnectPoint.deviceConnectPoint(cps[1]));
            }

            @Override
            public String subjectKey(LinkKey subject) {
                return SubjectFactories.key(subject.src()) + "-" + SubjectFactories.key(subject.dst());
            }
        };
        REGION_SUBJECT_FACTORY = new SubjectFactory<RegionId>(RegionId.class, "regions"){

            @Override
            public RegionId createSubject(String key) {
                return RegionId.regionId(key);
            }
        };
        LAYOUT_SUBJECT_FACTORY = new SubjectFactory<UiTopoLayoutId>(UiTopoLayoutId.class, "layouts"){

            @Override
            public UiTopoLayoutId createSubject(String key) {
                return UiTopoLayoutId.layoutId(key);
            }
        };
    }
}

