/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.google.common.base.Preconditions;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.basics.BasicElementConfig;
import org.onosproject.net.key.DeviceKeyId;

public final class BasicDeviceConfig
extends BasicElementConfig<DeviceId> {
    private static final String TYPE = "type";
    private static final String DRIVER = "driver";
    private static final String MANAGEMENT_ADDRESS = "managementAddress";
    private static final String MANUFACTURER = "manufacturer";
    private static final String HW_VERSION = "hwVersion";
    private static final String SW_VERSION = "swVersion";
    private static final String SERIAL = "serial";
    private static final String DEVICE_KEY_ID = "deviceKeyId";
    private static final int DRIVER_MAX_LENGTH = 256;
    private static final int MANUFACTURER_MAX_LENGTH = 256;
    private static final int HW_VERSION_MAX_LENGTH = 256;
    private static final int SW_VERSION_MAX_LENGTH = 256;
    private static final int SERIAL_MAX_LENGTH = 256;
    private static final int MANAGEMENT_ADDRESS_MAX_LENGTH = 1024;

    @Override
    public boolean isValid() {
        this.type();
        this.deviceKeyId();
        return super.isValid() && this.hasOnlyFields("allowed", "name", "locType", "latitude", "longitude", "gridY", "gridX", "uiType", "rackAddress", "owner", TYPE, DRIVER, MANUFACTURER, HW_VERSION, SW_VERSION, SERIAL, MANAGEMENT_ADDRESS, DEVICE_KEY_ID) && this.isValidLength(DRIVER, 256) && this.isValidLength(MANUFACTURER, 256) && this.isValidLength(HW_VERSION, 256) && this.isValidLength(SW_VERSION, 256) && this.isValidLength(SERIAL, 256) && this.isValidLength(MANAGEMENT_ADDRESS, 1024);
    }

    public Device.Type type() {
        return this.get(TYPE, null, Device.Type.class);
    }

    public BasicDeviceConfig type(Device.Type type) {
        return (BasicDeviceConfig)this.setOrClear(TYPE, type);
    }

    public String driver() {
        return this.get(DRIVER, null);
    }

    public BasicDeviceConfig driver(String driverName) {
        Preconditions.checkArgument((driverName.length() <= 256 ? 1 : 0) != 0, (Object)"driver exceeds maximum length 256");
        return (BasicDeviceConfig)this.setOrClear(DRIVER, driverName);
    }

    public String manufacturer() {
        return this.get(MANUFACTURER, null);
    }

    public BasicDeviceConfig manufacturer(String manufacturerName) {
        Preconditions.checkArgument((manufacturerName.length() <= 256 ? 1 : 0) != 0, (Object)"manufacturer exceeds maximum length 256");
        return (BasicDeviceConfig)this.setOrClear(MANUFACTURER, manufacturerName);
    }

    public String hwVersion() {
        return this.get(HW_VERSION, null);
    }

    public BasicDeviceConfig hwVersion(String hwVersion) {
        Preconditions.checkArgument((hwVersion.length() <= 256 ? 1 : 0) != 0, (Object)"hwVersion exceeds maximum length 256");
        return (BasicDeviceConfig)this.setOrClear(HW_VERSION, hwVersion);
    }

    public String swVersion() {
        return this.get(SW_VERSION, null);
    }

    public BasicDeviceConfig swVersion(String swVersion) {
        Preconditions.checkArgument((swVersion.length() <= 256 ? 1 : 0) != 0, (Object)"swVersion exceeds maximum length 256");
        return (BasicDeviceConfig)this.setOrClear(SW_VERSION, swVersion);
    }

    public String serial() {
        return this.get(SERIAL, null);
    }

    public BasicDeviceConfig serial(String serial) {
        Preconditions.checkArgument((serial.length() <= 256 ? 1 : 0) != 0, (Object)"serial exceeds maximum length 256");
        return (BasicDeviceConfig)this.setOrClear(SERIAL, serial);
    }

    public String managementAddress() {
        return this.get(MANAGEMENT_ADDRESS, null);
    }

    public BasicDeviceConfig managementAddress(String managementAddress) {
        Preconditions.checkArgument((managementAddress.length() <= 1024 ? 1 : 0) != 0, (Object)"serialNumber exceeds maximum length 1024");
        return (BasicDeviceConfig)this.setOrClear(MANAGEMENT_ADDRESS, managementAddress);
    }

    public DeviceKeyId deviceKeyId() {
        String s = this.get(DEVICE_KEY_ID, null);
        return s == null ? null : DeviceKeyId.deviceKeyId(s);
    }

    public BasicDeviceConfig deviceKeyId(DeviceKeyId deviceKeyId) {
        return (BasicDeviceConfig)this.setOrClear(DEVICE_KEY_ID, deviceKeyId != null ? (String)deviceKeyId.id() : null);
    }
}

