/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;

public class FilteredConnectPoint {
    private final ConnectPoint connectPoint;
    private final TrafficSelector trafficSelector;

    public FilteredConnectPoint(ConnectPoint connectPoint) {
        this.connectPoint = connectPoint;
        this.trafficSelector = DefaultTrafficSelector.emptySelector();
    }

    public FilteredConnectPoint(ConnectPoint connectPoint, TrafficSelector trafficSelector) {
        this.connectPoint = connectPoint;
        this.trafficSelector = trafficSelector;
    }

    public TrafficSelector trafficSelector() {
        return this.trafficSelector;
    }

    public ConnectPoint connectPoint() {
        return this.connectPoint;
    }

    public int hashCode() {
        return Objects.hash(this.connectPoint, this.trafficSelector);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("connectPoint", (Object)this.connectPoint).add("trafficSelector", (Object)this.trafficSelector).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilteredConnectPoint) {
            FilteredConnectPoint other = (FilteredConnectPoint)obj;
            return other.connectPoint().equals(this.connectPoint) && other.trafficSelector().equals(this.trafficSelector());
        }
        return false;
    }
}

