/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.provider.ProviderId;

public class DefaultPath
extends DefaultLink
implements Path {
    private final List<Link> links;
    private final Weight cost;

    @Deprecated
    public DefaultPath(ProviderId providerId, List<Link> links, double cost, Annotations ... annotations) {
        super(providerId, DefaultPath.source(links), DefaultPath.destination(links), Link.Type.INDIRECT, Link.State.ACTIVE, annotations);
        this.links = ImmutableList.copyOf(links);
        this.cost = new ScalarWeight(cost);
    }

    public DefaultPath(ProviderId providerId, List<Link> links, Weight cost, Annotations ... annotations) {
        super(providerId, DefaultPath.source(links), DefaultPath.destination(links), Link.Type.INDIRECT, Link.State.ACTIVE, annotations);
        this.links = ImmutableList.copyOf(links);
        this.cost = cost;
    }

    @Override
    public List<Link> links() {
        return this.links;
    }

    @Override
    public double cost() {
        if (this.cost instanceof ScalarWeight) {
            return ((ScalarWeight)this.cost).value();
        }
        return 0.0;
    }

    @Override
    public Weight weight() {
        return this.cost;
    }

    private static ConnectPoint source(List<Link> links) {
        Preconditions.checkNotNull(links, (Object)"List of path links cannot be null");
        Preconditions.checkArgument((!links.isEmpty() ? 1 : 0) != 0, (Object)"List of path links cannot be empty");
        return links.get(0).src();
    }

    private static ConnectPoint destination(List<Link> links) {
        Preconditions.checkNotNull(links, (Object)"List of path links cannot be null");
        Preconditions.checkArgument((!links.isEmpty() ? 1 : 0) != 0, (Object)"List of path links cannot be empty");
        return links.get(links.size() - 1).dst();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", (Object)this.src()).add("dst", (Object)this.dst()).add("type", (Object)this.type()).add("state", (Object)this.state()).add("durable", this.isDurable()).add("links", this.links).add("cost", (Object)this.cost).toString();
    }

    @Override
    public int hashCode() {
        return this.links.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPath) {
            DefaultPath other = (DefaultPath)obj;
            return Objects.equals(this.links, other.links);
        }
        return false;
    }
}

