/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.Version;
import org.onosproject.security.Permission;

public class DefaultApplicationDescription
implements ApplicationDescription {
    private final String name;
    private final Version version;
    private final String title;
    private final String description;
    private final String origin;
    private final String category;
    private final String url;
    private final String readme;
    private final byte[] icon;
    private final ApplicationRole role;
    private final Set<Permission> permissions;
    private final Optional<URI> featuresRepo;
    private final List<String> features;
    private final List<String> requiredApps;

    public DefaultApplicationDescription(String name, Version version, String title, String description, String origin, String category, String url, String readme, byte[] icon, ApplicationRole role, Set<Permission> permissions, URI featuresRepo, List<String> features, List<String> requiredApps) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.version = (Version)Preconditions.checkNotNull((Object)version, (Object)"Version cannot be null");
        this.title = (String)Preconditions.checkNotNull((Object)title, (Object)"Title cannot be null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"Description cannot be null");
        this.origin = (String)Preconditions.checkNotNull((Object)origin, (Object)"Origin cannot be null");
        this.category = (String)Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.url = url;
        this.readme = (String)Preconditions.checkNotNull((Object)readme, (Object)"Readme cannot be null");
        this.icon = icon;
        this.role = (ApplicationRole)((Object)Preconditions.checkNotNull((Object)((Object)role), (Object)"Role cannot be null"));
        this.permissions = (Set)Preconditions.checkNotNull(permissions, (Object)"Permissions cannot be null");
        this.featuresRepo = Optional.ofNullable(featuresRepo);
        this.features = (List)Preconditions.checkNotNull(features, (Object)"Features cannot be null");
        this.requiredApps = (List)Preconditions.checkNotNull(requiredApps, (Object)"Required apps cannot be null");
        Preconditions.checkArgument((!features.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one feature");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String readme() {
        return this.readme;
    }

    @Override
    public byte[] icon() {
        return this.icon;
    }

    @Override
    public String origin() {
        return this.origin;
    }

    @Override
    public ApplicationRole role() {
        return this.role;
    }

    @Override
    public Set<Permission> permissions() {
        return this.permissions;
    }

    @Override
    public Optional<URI> featuresRepo() {
        return this.featuresRepo;
    }

    @Override
    public List<String> features() {
        return this.features;
    }

    @Override
    public List<String> requiredApps() {
        return this.requiredApps;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).add("description", (Object)this.description).add("title", (Object)this.title).add("origin", (Object)this.origin).add("category", (Object)this.category).add("url", (Object)this.url).add("readme", (Object)this.readme).add("role", (Object)this.role).add("permissions", this.permissions).add("featuresRepo", this.featuresRepo).add("features", this.features).add("requiredApps", this.requiredApps).toString();
    }
}

