/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.intentperf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.intentperf.IntentPerfCollector;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.UiView;

@Component(immediate=true, enabled=true)
@Service(value={IntentPerfUi.class})
public class IntentPerfUi {
    private static final String INTENT_PERF_START = "intentPerfStart";
    private static final String INTENT_PERF_STOP = "intentPerfStop";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected UiExtensionService uiExtensionService;
    private final Set<StreamingControl> handlers = Collections.synchronizedSet(new HashSet());
    private List<UiView> views = ImmutableList.of((Object)new UiView(UiView.Category.OTHER, "intentPerf", "Intent Performance"));
    private UiExtension uiExtension = new UiExtension.Builder(this.getClass().getClassLoader(), this.views).messageHandlerFactory(this::newHandlers).build();
    private IntentPerfCollector collector;

    @Activate
    protected void activate() {
        this.uiExtensionService.register(this.uiExtension);
    }

    @Deactivate
    protected void deactivate() {
        this.uiExtensionService.unregister(this.uiExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSample(IntentPerfCollector.Sample sample) {
        Set<StreamingControl> set = this.handlers;
        synchronized (set) {
            this.handlers.forEach(h -> ((StreamingControl)h).send(sample));
        }
    }

    public void setCollector(IntentPerfCollector collector) {
        this.collector = collector;
    }

    private Collection<UiMessageHandler> newHandlers() {
        return ImmutableList.of((Object)((Object)new StreamingControl()));
    }

    protected void bindUiExtensionService(UiExtensionService uiExtensionService) {
        this.uiExtensionService = uiExtensionService;
    }

    protected void unbindUiExtensionService(UiExtensionService uiExtensionService) {
        if (this.uiExtensionService == uiExtensionService) {
            this.uiExtensionService = null;
        }
    }

    private class StreamingControl
    extends UiMessageHandler {
        private boolean streamingEnabled = false;

        private StreamingControl() {
        }

        protected Collection<RequestHandler> createRequestHandlers() {
            return ImmutableSet.of((Object)((Object)new IntentPerfStart()), (Object)((Object)new IntentPerfStop()));
        }

        public void init(UiConnection connection, ServiceDirectory directory) {
            super.init(connection, directory);
            IntentPerfUi.this.handlers.add(this);
        }

        public void destroy() {
            super.destroy();
            IntentPerfUi.this.handlers.remove((Object)this);
        }

        private void send(IntentPerfCollector.Sample sample) {
            if (this.streamingEnabled) {
                this.connection().sendMessage("intentPerfSample", this.sampleNode(sample));
            }
        }

        private ObjectNode sampleNode(IntentPerfCollector.Sample sample) {
            ObjectNode sampleNode = this.objectNode();
            ArrayNode an = this.arrayNode();
            sampleNode.put("time", sample.time);
            sampleNode.set("data", (JsonNode)an);
            for (double d : sample.data) {
                an.add(d);
            }
            return sampleNode;
        }

        private final class IntentPerfStop
        extends RequestHandler {
            private IntentPerfStop() {
                super(IntentPerfUi.INTENT_PERF_STOP);
            }

            public void process(ObjectNode payload) {
                StreamingControl.this.streamingEnabled = false;
            }
        }

        private final class IntentPerfStart
        extends RequestHandler {
            private IntentPerfStart() {
                super(IntentPerfUi.INTENT_PERF_START);
            }

            public void process(ObjectNode payload) {
                StreamingControl.this.streamingEnabled = true;
                this.sendInitData();
            }

            private void sendInitData() {
                ObjectNode rootNode = MAPPER.createObjectNode();
                ArrayNode an = MAPPER.createArrayNode();
                ArrayNode sn = MAPPER.createArrayNode();
                rootNode.set("headers", (JsonNode)an);
                rootNode.set("samples", (JsonNode)sn);
                IntentPerfUi.this.collector.getSampleHeaders().forEach(arg_0 -> ((ArrayNode)an).add(arg_0));
                IntentPerfUi.this.collector.getSamples().forEach(s -> sn.add((JsonNode)StreamingControl.this.sampleNode(s)));
                this.sendMessage("intentPerfInit", rootNode);
            }
        }
    }
}

