/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.intentperf;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.intentperf.IntentPerfCollector;

@Command(scope="onos", name="intent-perf", description="Displays accumulated performance metrics")
public class IntentPerfListCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--summary"}, description="Output just summary", required=false, multiValued=false)
    private boolean summary = false;

    protected void execute() {
        if (this.summary) {
            this.printSummary();
        } else {
            this.printSamples();
        }
    }

    private void printSummary() {
        IntentPerfCollector collector = (IntentPerfCollector)IntentPerfListCommand.get(IntentPerfCollector.class);
        List<String> headers = collector.getSampleHeaders();
        IntentPerfCollector.Sample overall = collector.getOverall();
        double total = 0.0;
        this.print("%12s: %14s", new Object[]{"Node ID", "Overall Rate"});
        for (int i = 0; i < overall.data.length; ++i) {
            if (overall.data[i] >= 0.0) {
                this.print("%12s: %14.2f", new Object[]{headers.get(i), overall.data[i]});
                total += overall.data[i];
                continue;
            }
            this.print("%12s: %14s", new Object[]{headers.get(i), " "});
        }
        this.print("%12s: %14.2f", new Object[]{"total", total});
    }

    private void printSamples() {
        IntentPerfCollector collector = (IntentPerfCollector)IntentPerfListCommand.get(IntentPerfCollector.class);
        List<String> headers = collector.getSampleHeaders();
        List<IntentPerfCollector.Sample> samples = collector.getSamples();
        System.out.print(String.format("%10s  ", "Time"));
        for (String header : headers) {
            System.out.print(String.format("%12s  ", header));
        }
        System.out.println(String.format("%12s", "Total"));
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        for (IntentPerfCollector.Sample sample : samples) {
            double total = 0.0;
            System.out.print(String.format("%10s  ", sdf.format(new Date(sample.time))));
            for (int i = 0; i < sample.data.length; ++i) {
                if (sample.data[i] >= 0.0) {
                    System.out.print(String.format("%12.2f  ", sample.data[i]));
                    total += sample.data[i];
                    continue;
                }
                System.out.print(String.format("%12s  ", " "));
            }
            System.out.println(String.format("%12.2f", total));
        }
    }
}

