/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.intentperf;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.MacAddress;
import org.onlab.util.Counter;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.intentperf.IntentPerfCollector;
import org.onosproject.intentperf.IntentPerfUi;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.WorkPartitionService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={IntentPerfInstaller.class})
public class IntentPerfInstaller {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_NUM_WORKERS = 1;
    private static final int DEFAULT_NUM_KEYS = 40000;
    private static final int DEFAULT_GOAL_CYCLE_PERIOD = 1000;
    private static final int DEFAULT_NUM_NEIGHBORS = 0;
    private static final int START_DELAY = 5000;
    private static final int REPORT_PERIOD = 1000;
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final MessageSubject CONTROL = new MessageSubject("intent-perf-ctl");
    @Property(name="numKeys", intValue={40000}, label="Number of keys (i.e. unique intents) to generate per instance")
    private int numKeys = 40000;
    @Property(name="cyclePeriod", intValue={1000}, label="Goal for cycle period (in ms)")
    private int cyclePeriod = 1000;
    @Property(name="numNeighbors", intValue={0}, label="Number of neighbors to generate intents for")
    private int numNeighbors = 0;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected WorkPartitionService partitionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentPerfCollector sampleCollector;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService communicationService;
    private ExecutorService messageHandlingExecutor;
    private ExecutorService workers;
    private ApplicationId appId;
    private Listener listener;
    private boolean stopped = true;
    private Timer reportTimer;
    private int lastKey = 0;
    private IntentPerfUi perfUi;
    private NodeId nodeId;
    private TimerTask reporterTask;
    final Set<Intent> submitted = Sets.newConcurrentHashSet();
    final Set<Intent> withdrawn = Sets.newConcurrentHashSet();

    @Activate
    public void activate(ComponentContext context) {
        this.configService.registerProperties(this.getClass());
        this.nodeId = this.clusterService.getLocalNode().id();
        this.appId = this.coreService.registerApplication("org.onosproject.intentperf." + this.nodeId.toString());
        this.reportTimer = new Timer("onos-intent-perf-reporter");
        this.workers = Executors.newFixedThreadPool(1, Tools.groupedThreads((String)"onos/intent-perf", (String)"worker-%d"));
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/perf", (String)"command-handler"));
        this.communicationService.addSubscriber(CONTROL, String::new, (Consumer)new InternalControl(), (Executor)this.messageHandlingExecutor);
        this.listener = new Listener();
        this.intentService.addListener((EventListener)this.listener);
        this.modify(context);
    }

    @Deactivate
    public void deactivate() {
        this.stopTestRun();
        this.configService.unregisterProperties(this.getClass(), false);
        this.messageHandlingExecutor.shutdown();
        this.communicationService.removeSubscriber(CONTROL);
        if (this.listener != null) {
            this.reportTimer.cancel();
            this.intentService.removeListener((EventListener)this.listener);
            this.listener = null;
            this.reportTimer = null;
        }
    }

    @Modified
    public void modify(ComponentContext context) {
        int newNumNeighbors;
        int newCyclePeriod;
        int newNumKeys;
        if (context == null) {
            this.logConfig("Reconfigured");
            return;
        }
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"numKeys");
            newNumKeys = Strings.isNullOrEmpty((String)s) ? this.numKeys : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"cyclePeriod");
            newCyclePeriod = Strings.isNullOrEmpty((String)s) ? this.cyclePeriod : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"numNeighbors");
            newNumNeighbors = Strings.isNullOrEmpty((String)s) ? this.numNeighbors : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            this.log.warn("Malformed configuration detected; using defaults", (Throwable)e);
            newNumKeys = 40000;
            newCyclePeriod = 1000;
            newNumNeighbors = 0;
        }
        if (newNumKeys != this.numKeys || newCyclePeriod != this.cyclePeriod || newNumNeighbors != this.numNeighbors) {
            this.numKeys = newNumKeys;
            this.cyclePeriod = newCyclePeriod;
            this.numNeighbors = newNumNeighbors;
            this.logConfig("Reconfigured");
        }
    }

    public void start() {
        if (this.stopped) {
            this.stopped = false;
            this.communicationService.broadcast((Object)START, CONTROL, str -> str.getBytes());
            this.startTestRun();
        }
    }

    public void stop() {
        if (!this.stopped) {
            this.communicationService.broadcast((Object)STOP, CONTROL, str -> str.getBytes());
            this.stopTestRun();
        }
    }

    private void logConfig(String prefix) {
        this.log.info("{} with appId {}; numKeys = {}; cyclePeriod = {} ms; numNeighbors={}", new Object[]{prefix, this.appId.id(), this.numKeys, this.cyclePeriod, this.numNeighbors});
    }

    private void startTestRun() {
        this.sampleCollector.clearSamples();
        this.numNeighbors = Math.min(this.clusterService.getNodes().size() - 1, this.numNeighbors);
        this.reporterTask = new ReporterTask();
        this.reportTimer.scheduleAtFixedRate(this.reporterTask, 1000L - System.currentTimeMillis() % 1000L, 1000L);
        this.stopped = false;
        for (int i = 0; i < 1; ++i) {
            this.workers.submit(new Submitter(this.createIntents(this.numKeys, 2, this.lastKey)));
        }
        this.log.info("Started test run");
    }

    private void stopTestRun() {
        if (this.reporterTask != null) {
            this.reporterTask.cancel();
            this.reporterTask = null;
        }
        try {
            this.workers.awaitTermination(5 * this.cyclePeriod, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Failed to stop worker", (Throwable)e);
        }
        this.sampleCollector.recordSample(0.0, 0.0);
        this.sampleCollector.recordSample(0.0, 0.0);
        this.stopped = true;
        this.log.info("Stopped test run");
    }

    private List<NodeId> getNeighbors() {
        List<NodeId> nodes = this.clusterService.getNodes().stream().map(ControllerNode::id).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(nodes, (node1, node2) -> node1.toString().compareTo(node2.toString()));
        Collections.rotate(nodes, -1 * nodes.indexOf(this.clusterService.getLocalNode().id()));
        this.log.debug("neighbors (raw): {}", (Object)nodes);
        nodes = nodes.subList(0, this.numNeighbors + 1);
        this.log.debug("neighbors: {}", nodes);
        return nodes;
    }

    private Intent createIntent(Key key, long mac, NodeId node, Multimap<NodeId, Device> devices) {
        List deviceList = devices.get((Object)node).stream().collect(Collectors.toList());
        Device device = (Device)deviceList.get(RandomUtils.nextInt((int)deviceList.size()));
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(MacAddress.valueOf((long)mac)).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        ConnectPoint ingress = new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)1L));
        ConnectPoint egress = new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)2L));
        return PointToPointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoint(ingress).egressPoint(egress).build();
    }

    private Set<Intent> createIntents(int numberOfKeys, int pathLength, int firstKey) {
        List<NodeId> neighbors = this.getNeighbors();
        ArrayListMultimap devices = ArrayListMultimap.create();
        this.deviceService.getAvailableDevices().forEach(arg_0 -> this.lambda$createIntents$3((Multimap)devices, arg_0));
        neighbors.forEach(arg_0 -> IntentPerfInstaller.lambda$createIntents$4((Multimap)devices, arg_0));
        long keyPrefix = (long)this.clusterService.getLocalNode().ip().getIp4Address().toInt() << 32;
        int maxKeysPerNode = (int)Math.ceil((double)numberOfKeys / (double)neighbors.size());
        ArrayListMultimap intents = ArrayListMultimap.create();
        int count = 0;
        int k = firstKey;
        while (count < numberOfKeys) {
            Key key = Key.of((long)(keyPrefix + (long)k), (ApplicationId)this.appId);
            NodeId leader = this.partitionService.getLeader((Object)key, Key::hash);
            if (neighbors.contains(leader) && intents.get((Object)leader).size() < maxKeysPerNode) {
                intents.put((Object)leader, (Object)this.createIntent(key, keyPrefix + (long)k, leader, (Multimap<NodeId, Device>)devices));
                this.lastKey = k;
                if (++count % 1000 == 0) {
                    this.log.info("Building intents... {} (attempt: {})", (Object)count, (Object)this.lastKey);
                }
            }
            ++k;
        }
        Preconditions.checkState((intents.values().size() == numberOfKeys ? 1 : 0) != 0, (Object)"Generated wrong number of intents");
        this.log.info("Created {} intents", (Object)numberOfKeys);
        intents.keySet().forEach(arg_0 -> this.lambda$createIntents$5((Multimap)intents, arg_0));
        return Sets.newHashSet((Iterable)intents.values());
    }

    private /* synthetic */ void lambda$createIntents$5(Multimap intents, NodeId node) {
        this.log.info("\t{}\t{}", (Object)node, (Object)intents.get((Object)node).size());
    }

    private static /* synthetic */ void lambda$createIntents$4(Multimap devices, NodeId node) {
        Preconditions.checkState((!devices.get((Object)node).isEmpty() ? 1 : 0) != 0, (String)"There are no devices for {}", (Object)node);
    }

    private /* synthetic */ void lambda$createIntents$3(Multimap devices, Device device) {
        devices.put((Object)this.mastershipService.getMasterFor(device.id()), (Object)device);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindPartitionService(WorkPartitionService workPartitionService) {
        this.partitionService = workPartitionService;
    }

    protected void unbindPartitionService(WorkPartitionService workPartitionService) {
        if (this.partitionService == workPartitionService) {
            this.partitionService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindSampleCollector(IntentPerfCollector intentPerfCollector) {
        this.sampleCollector = intentPerfCollector;
    }

    protected void unbindSampleCollector(IntentPerfCollector intentPerfCollector) {
        if (this.sampleCollector == intentPerfCollector) {
            this.sampleCollector = null;
        }
    }

    protected void bindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        this.communicationService = clusterCommunicationService;
    }

    protected void unbindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        if (this.communicationService == clusterCommunicationService) {
            this.communicationService = null;
        }
    }

    private class ReporterTask
    extends TimerTask {
        private ReporterTask() {
        }

        @Override
        public void run() {
            IntentPerfInstaller.this.listener.report();
        }
    }

    private class InternalControl
    implements Consumer<String> {
        private InternalControl() {
        }

        @Override
        public void accept(String cmd) {
            IntentPerfInstaller.this.log.info("Received command {}", (Object)cmd);
            if (cmd.equals(IntentPerfInstaller.START)) {
                IntentPerfInstaller.this.startTestRun();
            } else {
                IntentPerfInstaller.this.stopTestRun();
            }
        }
    }

    final class Listener
    implements IntentListener {
        private final Counter runningTotal = new Counter();
        private volatile Map<IntentEvent.Type, Counter> counters = this.initCounters();
        private volatile double processedThroughput = 0.0;
        private volatile double requestThroughput = 0.0;

        private Map<IntentEvent.Type, Counter> initCounters() {
            HashMap map = Maps.newHashMap();
            for (IntentEvent.Type type : IntentEvent.Type.values()) {
                map.put(type, new Counter());
            }
            return map;
        }

        public double processedThroughput() {
            return this.processedThroughput;
        }

        public double requestThroughput() {
            return this.requestThroughput;
        }

        public void event(IntentEvent event) {
            if (((Intent)event.subject()).appId().equals(IntentPerfInstaller.this.appId)) {
                if (event.type() == IntentEvent.Type.INSTALLED) {
                    IntentPerfInstaller.this.submitted.add((Intent)event.subject());
                }
                if (event.type() == IntentEvent.Type.WITHDRAWN) {
                    IntentPerfInstaller.this.withdrawn.add((Intent)event.subject());
                }
                this.counters.get(event.type()).add(1L);
            }
        }

        public void report() {
            Map<IntentEvent.Type, Counter> reportCounters = this.counters;
            this.counters = this.initCounters();
            Counter installed = reportCounters.get(IntentEvent.Type.INSTALLED);
            Counter withdrawn = reportCounters.get(IntentEvent.Type.WITHDRAWN);
            this.processedThroughput = installed.throughput() + withdrawn.throughput();
            this.runningTotal.add(installed.total() + withdrawn.total());
            Counter installReq = reportCounters.get(IntentEvent.Type.INSTALL_REQ);
            Counter withdrawReq = reportCounters.get(IntentEvent.Type.WITHDRAW_REQ);
            this.requestThroughput = installReq.throughput() + withdrawReq.throughput();
            StringBuilder stringBuilder = new StringBuilder();
            for (IntentEvent.Type type : IntentEvent.Type.values()) {
                Counter counter = reportCounters.get(type);
                stringBuilder.append(String.format("%s=%.2f;", type, counter.throughput()));
            }
            IntentPerfInstaller.this.log.info("Throughput: OVERALL={}; CURRENT={}; {}", new Object[]{String.format("%.2f", this.runningTotal.throughput()), String.format("%.2f", this.processedThroughput), stringBuilder});
            IntentPerfInstaller.this.sampleCollector.recordSample(this.runningTotal.throughput(), this.processedThroughput);
        }
    }

    final class Submitter
    implements Runnable {
        private long lastDuration;
        private int lastCount;
        private Set<Intent> intents = Sets.newHashSet();
        int cycleCount = 0;

        private Submitter(Set<Intent> intents) {
            this.intents = intents;
            this.lastCount = IntentPerfInstaller.this.numKeys / 4;
            this.lastDuration = 1000L;
        }

        @Override
        public void run() {
            this.prime();
            while (!IntentPerfInstaller.this.stopped) {
                try {
                    this.cycle();
                }
                catch (Exception e) {
                    IntentPerfInstaller.this.log.warn("Exception during cycle", (Throwable)e);
                }
            }
            this.clear();
        }

        private Iterable<Intent> subset(Set<Intent> intents) {
            ArrayList subset = Lists.newArrayList(intents);
            Collections.shuffle(subset);
            return subset.subList(0, Math.min(subset.size(), this.lastCount));
        }

        private void submit(Intent intent) {
            IntentPerfInstaller.this.intentService.submit(intent);
            IntentPerfInstaller.this.withdrawn.remove(intent);
        }

        private void withdraw(Intent intent) {
            IntentPerfInstaller.this.intentService.withdraw(intent);
            IntentPerfInstaller.this.submitted.remove(intent);
        }

        private void prime() {
            int i = 0;
            IntentPerfInstaller.this.withdrawn.addAll(this.intents);
            for (Intent intent : this.intents) {
                this.submit(intent);
                if (i++ < this.intents.size() / 2) continue;
                break;
            }
        }

        private void clear() {
            IntentPerfInstaller.this.submitted.forEach(this::withdraw);
        }

        private void cycle() {
            int difference;
            this.adjustRates();
            long start = System.currentTimeMillis();
            this.subset(IntentPerfInstaller.this.submitted).forEach(this::withdraw);
            this.subset(IntentPerfInstaller.this.withdrawn).forEach(this::submit);
            long delta = System.currentTimeMillis() - start;
            if (delta > (long)(IntentPerfInstaller.this.cyclePeriod * 3) || delta < 0L) {
                IntentPerfInstaller.this.log.warn("Cycle took {} ms", (Object)delta);
            }
            if ((difference = IntentPerfInstaller.this.cyclePeriod - (int)delta) > 0) {
                Tools.delay((int)difference);
            }
            this.lastDuration = delta;
        }

        private void adjustRates() {
            int addDelta = Math.max(1000 - this.cycleCount, 10);
            double multRatio = Math.min(0.8 + (double)this.cycleCount * 2.0E-4, 0.995);
            if (++this.cycleCount % 5 == 0) {
                this.lastCount = IntentPerfInstaller.this.listener.requestThroughput() - IntentPerfInstaller.this.listener.processedThroughput() <= 2000.0 && this.lastDuration <= (long)IntentPerfInstaller.this.cyclePeriod ? Math.min(this.lastCount + addDelta, this.intents.size() / 2) : (int)((double)this.lastCount * multRatio);
                IntentPerfInstaller.this.log.info("last count: {}, last duration: {} ms (sub: {} vs inst: {})", new Object[]{this.lastCount, this.lastDuration, IntentPerfInstaller.this.listener.requestThroughput(), IntentPerfInstaller.this.listener.processedThroughput()});
            }
        }
    }
}

