/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.intentperf;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.SharedExecutors;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.intentperf.IntentPerfUi;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={IntentPerfCollector.class})
public class IntentPerfCollector {
    private static final long SAMPLE_TIME_WINDOW_MS = 5000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_SAMPLES = 1000;
    private final List<Sample> samples = new LinkedList<Sample>();
    private static final MessageSubject SAMPLE = new MessageSubject("intent-perf-sample");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService communicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentPerfUi ui;
    private long newestTime;
    private Sample overall;
    private Sample current;
    private ControllerNode[] nodes;
    private Map<NodeId, Integer> nodeToIndex;
    private NodeId nodeId;

    @Activate
    public void activate() {
        this.nodeId = this.clusterService.getLocalNode().id();
        this.communicationService.addSubscriber(SAMPLE, (ClusterMessageHandler)new InternalSampleCollector(), SharedExecutors.getPoolThreadExecutor());
        this.nodes = this.clusterService.getNodes().toArray(new ControllerNode[0]);
        Arrays.sort(this.nodes, (a, b) -> a.id().toString().compareTo(b.id().toString()));
        this.nodeToIndex = new HashMap<NodeId, Integer>();
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodeToIndex.put(this.nodes[i].id(), i);
        }
        this.clearSamples();
        this.ui.setCollector(this);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.communicationService.removeSubscriber(SAMPLE);
        this.log.info("Stopped");
    }

    public synchronized void clearSamples() {
        this.newestTime = 0L;
        this.overall = new Sample(0L, this.nodes.length);
        this.current = new Sample(0L, this.nodes.length);
        this.samples.clear();
    }

    public void recordSample(double overallRate, double currentRate) {
        long now = System.currentTimeMillis();
        this.addSample(now, this.nodeId, overallRate, currentRate);
        this.broadcastSample(now, this.nodeId, overallRate, currentRate);
    }

    public List<String> getSampleHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (ControllerNode node : this.nodes) {
            headers.add(node.id().toString());
        }
        return headers;
    }

    public synchronized List<Sample> getSamples() {
        return ImmutableList.copyOf(this.samples);
    }

    public synchronized Sample getOverall() {
        return this.overall;
    }

    private synchronized void addSample(long time, NodeId nodeId, double overallRate, double currentRate) {
        Sample fullSample = this.createCurrentSampleIfNeeded(time);
        this.setSampleData(this.current, nodeId, currentRate);
        this.setSampleData(this.overall, nodeId, overallRate);
        this.pruneSamplesIfNeeded();
        if (fullSample != null && this.ui != null) {
            this.ui.reportSample(fullSample);
        }
    }

    private Sample createCurrentSampleIfNeeded(long time) {
        Sample oldSample;
        Sample sample = oldSample = time - this.newestTime > 5000L || this.current.isComplete() ? this.current : null;
        if (oldSample != null) {
            this.newestTime = time;
            this.current = new Sample(time, this.nodes.length);
            if (oldSample.time > 0L) {
                this.samples.add(oldSample);
            }
        }
        return oldSample;
    }

    private void setSampleData(Sample sample, NodeId nodeId, double data) {
        Integer index = this.nodeToIndex.get(nodeId);
        if (index != null) {
            sample.data[index.intValue()] = data;
        }
    }

    private void pruneSamplesIfNeeded() {
        if (this.samples.size() > 1000) {
            this.samples.remove(0);
        }
    }

    private void broadcastSample(long time, NodeId nodeId, double overallRate, double currentRate) {
        String data = String.format("%d|%f|%f", time, overallRate, currentRate);
        this.communicationService.broadcast((Object)data, SAMPLE, str -> str.getBytes());
    }

    protected void bindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        this.communicationService = clusterCommunicationService;
    }

    protected void unbindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        if (this.communicationService == clusterCommunicationService) {
            this.communicationService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindUi(IntentPerfUi intentPerfUi) {
        this.ui = intentPerfUi;
    }

    protected void unbindUi(IntentPerfUi intentPerfUi) {
        if (this.ui == intentPerfUi) {
            this.ui = null;
        }
    }

    private class InternalSampleCollector
    implements ClusterMessageHandler {
        private InternalSampleCollector() {
        }

        public void handle(ClusterMessage message) {
            String[] fields = new String(message.payload()).split("\\|");
            IntentPerfCollector.this.log.debug("Received sample from {}: {}", (Object)message.sender(), (Object)fields);
            IntentPerfCollector.this.addSample(Long.parseLong(fields[0]), message.sender(), Double.parseDouble(fields[1]), Double.parseDouble(fields[2]));
        }
    }

    static class Sample {
        final long time;
        final double[] data;

        public Sample(long time, int nodeCount) {
            this.time = time;
            this.data = new double[nodeCount];
            Arrays.fill(this.data, -1.0);
        }

        public boolean isComplete() {
            for (int i = 0; i < this.data.length; ++i) {
                if (!(this.data[i] < 0.0)) continue;
                return false;
            }
            return true;
        }
    }
}

