/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfdpaGroupHandlerUtility {
    protected static final int L2_INTERFACE_TYPE = 0;
    protected static final int L3_INTERFACE_TYPE = 0x50000000;
    protected static final int L3_UNICAST_TYPE = 0x20000000;
    protected static final int L3_MULTICAST_TYPE = 0x60000000;
    protected static final int MPLS_INTERFACE_TYPE = -1879048192;
    protected static final int MPLS_L3VPN_SUBTYPE = -1845493760;
    protected static final int L3_ECMP_TYPE = 0x70000000;
    protected static final int L2_FLOOD_TYPE = 0x40000000;
    protected static final int TYPE_MASK = 0xFFFFFFF;
    protected static final int SUBTYPE_MASK = 0xFFFFFF;
    protected static final int TYPE_VLAN_MASK = 65535;
    protected static final int THREE_BIT_MASK = 4095;
    protected static final int FOUR_BIT_MASK = 65535;
    protected static final int PORT_LEN = 16;
    protected static final int PORT_LOWER_BITS_MASK = 63;
    protected static final long PORT_HIGHER_BITS_MASK = -64L;
    protected static final String HEX_PREFIX = "0x";
    protected static final Logger log = LoggerFactory.getLogger(OfdpaGroupHandlerUtility.class);

    private OfdpaGroupHandlerUtility() {
    }

    protected static PortNumber readOutPortFromTreatment(TrafficTreatment tt) {
        for (Instruction ins : tt.allInstructions()) {
            if (ins.type() != Instruction.Type.OUTPUT) continue;
            return ((Instructions.OutputInstruction)ins).port();
        }
        return null;
    }

    public static Integer makeMplsLabelGroupId(OfdpaMplsGroupSubType subType, int index) {
        return (index &= 0xFFFFFF) | 0x90000000 | subType.value << 24;
    }

    public static Integer makeMplsForwardingGroupId(OfdpaMplsGroupSubType subType, int index) {
        return (index &= 0xFFFFFF) | 0xA0000000 | subType.value << 24;
    }

    public static Set<PortNumber> getExistingOutputPorts(List<Deque<GroupKey>> allActiveKeys, GroupService groupService, DeviceId deviceId) {
        HashSet existingPorts = Sets.newHashSet();
        allActiveKeys.forEach(keyChain -> {
            GroupKey ifaceGroupKey = (GroupKey)keyChain.peekLast();
            Group ifaceGroup = groupService.getGroup(deviceId, ifaceGroupKey);
            if (ifaceGroup != null && !ifaceGroup.buckets().buckets().isEmpty()) {
                ifaceGroup.buckets().buckets().forEach(bucket -> {
                    PortNumber portNumber = OfdpaGroupHandlerUtility.readOutPortFromTreatment(bucket.treatment());
                    if (portNumber != null) {
                        existingPorts.add(portNumber);
                    }
                });
            }
        });
        return existingPorts;
    }

    public static boolean verifyHashedNextObjective(NextObjective nextObjective) {
        if (nextObjective.type() != NextObjective.Type.HASHED) {
            return false;
        }
        TrafficSelector metaSelector = nextObjective.meta();
        return metaSelector == null || !Ofdpa2Pipeline.isNotMplsBos(metaSelector);
    }

    protected static List<GroupBucket> generateNextGroupBuckets(List<GroupInfo> groupInfos, GroupDescription.Type bucketType) {
        ArrayList newBuckets = Lists.newArrayList();
        groupInfos.forEach(groupInfo -> {
            GroupDescription groupDesc = groupInfo.nextGroupDesc();
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            treatmentBuilder.group(new GroupId(groupDesc.givenGroupId().intValue()));
            GroupBucket newBucket = null;
            switch (bucketType) {
                case ALL: {
                    newBucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatmentBuilder.build());
                    break;
                }
                case INDIRECT: {
                    newBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatmentBuilder.build());
                    break;
                }
                case SELECT: {
                    newBucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)treatmentBuilder.build());
                    break;
                }
                default: {
                    log.warn("Unknown bucket type: {}", (Object)bucketType);
                }
            }
            if (newBucket != null) {
                newBuckets.add(newBucket);
            }
        });
        return ImmutableList.copyOf((Collection)newBuckets);
    }

    public static VlanId extractVlanIdFromGroupId(int groupId) {
        short vlanId = (short)((groupId & 0xFFF0000) >> 16);
        return VlanId.vlanId((short)vlanId);
    }

    public static GroupKey l2FloodGroupKey(VlanId vlanId, DeviceId deviceId) {
        int hash = Objects.hash(deviceId, vlanId);
        hash = 0x40000000 | 0xFFFFFFF & hash;
        return new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)hash));
    }

    public static int l2GroupId(VlanId vlanId, long portNum) {
        return 0 | vlanId.toShort() << 16 | (int)portNum;
    }

    public static int l2InterfaceGroupKey(DeviceId deviceId, VlanId vlanId, long portNumber) {
        int portLowerBits = (int)portNumber & 0x3F;
        long portHigherBits = portNumber & 0xFFFFFFFFFFFFFFC0L;
        int hash = Objects.hash(deviceId, vlanId, portHigherBits);
        return 0 | 0xFFFFFFF & hash << 6 | portLowerBits;
    }

    public static class GroupChecker
    implements Runnable {
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        private Ofdpa2GroupHandler groupHandler;

        public GroupChecker(Ofdpa2GroupHandler groupHandler) {
            this.groupHandler = groupHandler;
        }

        @Override
        public void run() {
            if (this.groupHandler.pendingGroups().size() != 0L) {
                this.log.debug("pending groups being checked: {}", this.groupHandler.pendingGroups().asMap().keySet());
            }
            if (this.groupHandler.pendingAddNextObjectives().size() != 0L) {
                this.log.debug("pending add-next-obj being checked: {}", this.groupHandler.pendingAddNextObjectives().asMap().keySet());
            }
            Set<GroupKey> keys = this.groupHandler.pendingGroups().asMap().keySet().stream().filter(key -> this.groupHandler.groupService.getGroup(this.groupHandler.deviceId, key) != null).collect(Collectors.toSet());
            Set otherkeys = this.groupHandler.pendingAddNextObjectives().asMap().keySet().stream().filter(otherkey -> this.groupHandler.groupService.getGroup(this.groupHandler.deviceId, otherkey) != null).collect(Collectors.toSet());
            keys.addAll(otherkeys);
            keys.forEach(key -> this.groupHandler.processPendingAddGroupsOrNextObjs((GroupKey)key, false));
        }
    }

    public static class GroupChainElem {
        private GroupDescription groupDescription;
        private AtomicInteger waitOnGroups;
        private boolean addBucketToGroup;
        private DeviceId deviceId;

        public GroupChainElem(GroupDescription groupDescription, int waitOnGroups, boolean addBucketToGroup, DeviceId deviceId) {
            this.groupDescription = groupDescription;
            this.waitOnGroups = new AtomicInteger(waitOnGroups);
            this.addBucketToGroup = addBucketToGroup;
            this.deviceId = deviceId;
        }

        int decrementAndGetGroupsWaitedOn() {
            return this.waitOnGroups.decrementAndGet();
        }

        public GroupDescription groupDescription() {
            return this.groupDescription;
        }

        public boolean addBucketToGroup() {
            return this.addBucketToGroup;
        }

        public String toString() {
            return Integer.toHexString(this.groupDescription.givenGroupId()) + " groupKey: " + this.groupDescription.appCookie() + " waiting-on-groups: " + this.waitOnGroups.get() + " addBucketToGroup: " + this.addBucketToGroup + " device: " + this.deviceId;
        }
    }

    public static class OfdpaNextGroup
    implements NextGroup {
        private final NextObjective nextObj;
        private final List<Deque<GroupKey>> gkeys;

        public OfdpaNextGroup(List<Deque<GroupKey>> gkeys, NextObjective nextObj) {
            this.nextObj = nextObj;
            this.gkeys = gkeys;
        }

        public NextObjective nextObjective() {
            return this.nextObj;
        }

        public byte[] data() {
            return Ofdpa2Pipeline.appKryo.serialize(this.gkeys);
        }
    }

    public static class GroupInfo {
        private GroupDescription innerMostGroupDesc;
        private GroupDescription nextGroupDesc;

        GroupInfo(GroupDescription innerMostGroupDesc, GroupDescription nextGroupDesc) {
            this.innerMostGroupDesc = innerMostGroupDesc;
            this.nextGroupDesc = nextGroupDesc;
        }

        public GroupDescription innerMostGroupDesc() {
            return this.innerMostGroupDesc;
        }

        public GroupDescription nextGroupDesc() {
            return this.nextGroupDesc;
        }

        public void nextGroupDesc(GroupDescription nextGroupDesc) {
            this.nextGroupDesc = nextGroupDesc;
        }
    }

    public static enum OfdpaMplsGroupSubType {
        MPLS_INTF(0),
        L2_VPN(1),
        L3_VPN(2),
        MPLS_TUNNEL_LABEL_1(3),
        MPLS_TUNNEL_LABEL_2(4),
        MPLS_SWAP_LABEL(5),
        MPLS_ECMP(8);

        private short value;
        public static final int OFDPA_GROUP_TYPE_SHIFT = 28;
        public static final int OFDPA_MPLS_SUBTYPE_SHIFT = 24;

        private OfdpaMplsGroupSubType(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }
}

