/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.onlab.packet.Ethernet;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa3Pipeline;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa3QmxPipeline
extends Ofdpa3Pipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected void initDriverId() {
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.Ofdpa3QmxPipeline");
    }

    @Override
    protected boolean matchInPortTmacTable() {
        return false;
    }

    @Override
    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4 || ethType.ethType().toShort() == Ethernet.TYPE_IPV6) {
            this.log.warn("Routing table is currently unsupported in dev:{}", (Object)this.deviceId);
            return ImmutableSet.of();
        }
        return super.processEthTypeSpecific(fwd);
    }

    @Override
    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        EthTypeCriterion ethType = (EthTypeCriterion)fwd.selector().getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.log.error("Versatile forwarding objective:{} must include ethType", (Object)fwd.id());
            Ofdpa3QmxPipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return ImmutableSet.of();
        }
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV6) {
            this.log.warn("ACL table for IPv6 is currently unsupported in dev:{}", (Object)this.deviceId);
            return ImmutableSet.of();
        }
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            for (Criterion c : fwd.selector().criteria()) {
                if (!(c instanceof IPCriterion) || ((IPCriterion)c).type() != Criterion.Type.IPV4_DST) continue;
                this.log.warn("ACL table for Dst IPv4 is currently unsupported in dev:{}", (Object)this.deviceId);
                return ImmutableSet.of();
            }
        }
        return super.processVersatile(fwd);
    }
}

