/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Identifier;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.driver.pipeline.ofdpa.OfdpaGroupHandlerUtility;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa2GroupHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected GroupService groupService;
    protected StorageService storageService;
    protected FlowObjectiveStore flowObjectiveStore;
    private AtomicCounter nextIndex;
    protected DeviceId deviceId;
    private Cache<GroupKey, List<OfdpaGroupHandlerUtility.OfdpaNextGroup>> pendingAddNextObjectives;
    private Cache<NextObjective, List<GroupKey>> pendingRemoveNextObjectives;
    private Cache<GroupKey, Set<OfdpaGroupHandlerUtility.GroupChainElem>> pendingGroups;
    private ConcurrentHashMap<GroupKey, Set<NextObjective>> pendingUpdateNextObjectives;
    protected ConcurrentHashMap<Integer, Set<NextObjective>> pendingBuckets = new ConcurrentHashMap();
    private ScheduledExecutorService groupCheckerExecutor = Executors.newScheduledThreadPool(2, Tools.groupedThreads((String)"onos/pipeliner", (String)"ofdpa-%d", (Logger)this.log));

    public Cache<GroupKey, List<OfdpaGroupHandlerUtility.OfdpaNextGroup>> pendingAddNextObjectives() {
        return this.pendingAddNextObjectives;
    }

    public Cache<GroupKey, Set<OfdpaGroupHandlerUtility.GroupChainElem>> pendingGroups() {
        return this.pendingGroups;
    }

    protected boolean supportCopyTtl() {
        return true;
    }

    protected boolean supportSetMplsBos() {
        return true;
    }

    protected boolean requireVlanPopBeforeMplsPush() {
        return false;
    }

    protected void init(DeviceId deviceId, PipelinerContext context) {
        ServiceDirectory serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.flowObjectiveStore = context.store();
        this.groupService = (GroupService)serviceDirectory.get(GroupService.class);
        this.storageService = (StorageService)serviceDirectory.get(StorageService.class);
        this.nextIndex = this.storageService.getAtomicCounter("group-id-index-counter");
        this.pendingAddNextObjectives = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED && Objects.nonNull(notification.getValue())) {
                ((List)notification.getValue()).forEach(ofdpaNextGrp -> Ofdpa2Pipeline.fail((Objective)ofdpaNextGrp.nextObjective(), ObjectiveError.GROUPINSTALLATIONFAILED));
            }
        }).build();
        this.pendingRemoveNextObjectives = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                Ofdpa2Pipeline.fail((Objective)notification.getKey(), ObjectiveError.GROUPREMOVALFAILED);
            }
        }).build();
        this.pendingGroups = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.log.error("Unable to install group with key {} and pending GCEs: {}", notification.getKey(), notification.getValue());
            }
        }).build();
        this.pendingUpdateNextObjectives = new ConcurrentHashMap();
        OfdpaGroupHandlerUtility.GroupChecker groupChecker = new OfdpaGroupHandlerUtility.GroupChecker(this);
        this.groupCheckerExecutor.scheduleAtFixedRate(groupChecker, 0L, 500L, TimeUnit.MILLISECONDS);
        this.groupService.addListener((EventListener)new InnerGroupListener());
    }

    protected void addGroup(NextObjective nextObjective) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) {
                    this.log.error("Next Objectives of type Simple should only have a single Traffic Treatment. Next Objective Id:{}", (Object)nextObjective.id());
                    Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                this.processSimpleNextObjective(nextObjective);
                break;
            }
            case BROADCAST: {
                this.processBroadcastNextObjective(nextObjective);
                break;
            }
            case HASHED: {
                if (!OfdpaGroupHandlerUtility.verifyHashedNextObjective(nextObjective)) {
                    this.log.error("Next Objectives of type hashed not supported. Next Objective Id:{}", (Object)nextObjective.id());
                    Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                this.processHashedNextObjective(nextObjective);
                break;
            }
            case FAILOVER: {
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                this.log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    private void processSimpleNextObjective(NextObjective nextObj) {
        TrafficTreatment treatment = (TrafficTreatment)nextObj.next().iterator().next();
        boolean plainL2 = true;
        for (Instruction ins : treatment.allInstructions()) {
            L2ModificationInstruction l2ins;
            if (ins.type() != Instruction.Type.L2MODIFICATION || (l2ins = (L2ModificationInstruction)ins).subtype() != L2ModificationInstruction.L2SubType.ETH_DST && l2ins.subtype() != L2ModificationInstruction.L2SubType.ETH_SRC) continue;
            plainL2 = false;
            break;
        }
        if (plainL2) {
            this.createL2InterfaceGroup(nextObj);
            return;
        }
        boolean isMpls = false;
        boolean isPw = false;
        if (nextObj.meta() != null) {
            isMpls = Ofdpa2Pipeline.isNotMplsBos(nextObj.meta());
            TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)nextObj.meta().getCriterion(Criterion.Type.TUNNEL_ID);
            if (tunnelIdCriterion != null) {
                isPw = true;
            }
        }
        if (!isPw) {
            OfdpaGroupHandlerUtility.GroupInfo groupInfo = this.createL2L3Chain(treatment, nextObj.id(), nextObj.appId(), isMpls, nextObj.meta());
            if (groupInfo == null) {
                this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                return;
            }
            ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
            gkeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
            gkeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(Collections.singletonList(gkeyChain), nextObj);
            this.updatePendingNextObjective(groupInfo.nextGroupDesc().appCookie(), ofdpaGrp);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        } else {
            this.processPwNextObjective(nextObj);
        }
    }

    private void createL2InterfaceGroup(NextObjective nextObj) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by simple next obj is missing. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        GroupDescription l2InterfaceGroupDesc = groupInfos.get(0).innerMostGroupDesc();
        ArrayList allGroupKeys = Lists.newArrayList();
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(l2InterfaceGroupDesc.appCookie());
        allGroupKeys.add(gkeyChain);
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective(l2InterfaceGroupDesc.appCookie(), ofdpaGrp);
        this.groupService.addGroup(l2InterfaceGroupDesc);
    }

    protected OfdpaGroupHandlerUtility.GroupInfo createL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta) {
        return this.createL2L3ChainInternal(treatment, nextId, appId, mpls, meta, true);
    }

    protected OfdpaGroupHandlerUtility.GroupInfo createL2L3ChainInternal(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta, boolean useSetVlanExtension) {
        DefaultGroupDescription outerGrpDesc;
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder innerTtb = DefaultTrafficTreatment.builder();
        VlanId vlanid = null;
        long portNum = 0L;
        boolean setVlan = false;
        boolean popVlan = false;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: {
                        MacAddress dstMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthDst(dstMac);
                        break;
                    }
                    case ETH_SRC: {
                        MacAddress srcMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthSrc(srcMac);
                        break;
                    }
                    case VLAN_ID: {
                        vlanid = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                        if (useSetVlanExtension) {
                            OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(vlanid);
                            outerTtb.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                        } else {
                            outerTtb.setVlanId(vlanid);
                        }
                        setVlan = true;
                        break;
                    }
                    case VLAN_POP: {
                        innerTtb.popVlan();
                        popVlan = true;
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                portNum = ((Instructions.OutputInstruction)ins).port().toLong();
                innerTtb.add(ins);
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives:  {}", (Object)ins.type());
        }
        if (vlanid == null && meta != null) {
            Criterion vidCriterion = meta.getCriterion(Criterion.Type.VLAN_VID);
            if (vidCriterion != null) {
                vlanid = ((VlanIdCriterion)vidCriterion).vlanId();
            }
            if (vlanid != null && !setVlan) {
                if (useSetVlanExtension) {
                    OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(vlanid);
                    outerTtb.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                } else {
                    outerTtb.setVlanId(vlanid);
                }
            }
        }
        if (vlanid == null) {
            this.log.error("Driver cannot process an L2/L3 group chain without egress vlan information for dev: {} port:{}", (Object)this.deviceId, (Object)portNum);
            return null;
        }
        if (!setVlan && !popVlan) {
            TrafficTreatment.Builder temp = DefaultTrafficTreatment.builder();
            temp.popVlan();
            innerTtb.build().allInstructions().forEach(arg_0 -> ((TrafficTreatment.Builder)temp).add(arg_0));
            innerTtb = temp;
        }
        int l2groupId = OfdpaGroupHandlerUtility.l2GroupId(vlanid, portNum);
        int l2gk = OfdpaGroupHandlerUtility.l2InterfaceGroupKey(this.deviceId, vlanid, portNum);
        DefaultGroupKey l2groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
        if (mpls) {
            int mplsInterfaceIndex = this.getNextAvailableIndex();
            int mplsGroupId = 0x90000000 | 0xFFFFFF & mplsInterfaceIndex;
            DefaultGroupKey mplsGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)mplsInterfaceIndex));
            outerTtb.group(new GroupId(l2groupId));
            GroupBucket mplsinterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(mplsinterfaceGroupBucket)), (GroupKey)mplsGroupKey, Integer.valueOf(mplsGroupId), appId);
            this.log.debug("Trying MPLS-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(mplsGroupId), mplsGroupKey, nextId});
        } else {
            int l3unicastIndex = this.getNextAvailableIndex();
            int l3groupId = 0x20000000 | 0xFFFFFFF & l3unicastIndex;
            DefaultGroupKey l3groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3unicastIndex));
            outerTtb.group(new GroupId(l2groupId));
            GroupBucket l3unicastGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3unicastGroupBucket)), (GroupKey)l3groupkey, Integer.valueOf(l3groupId), appId);
            this.log.debug("Trying L3Unicast: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l3groupId), l3groupkey, nextId});
        }
        OfdpaGroupHandlerUtility.GroupChainElem gce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)outerGrpDesc, 1, false, this.deviceId);
        this.updatePendingGroups((GroupKey)l2groupkey, gce);
        GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)innerTtb.build());
        DefaultGroupDescription l2groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2groupkey, Integer.valueOf(l2groupId), appId);
        this.log.debug("Trying L2Interface: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2groupId), l2groupkey, nextId});
        return new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)l2groupDescription, (GroupDescription)outerGrpDesc);
    }

    private void processBroadcastNextObjective(NextObjective nextObj) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by broadcast next obj is missing. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        IpPrefix ipDst = Ofdpa2Pipeline.readIpDstFromSelector(nextObj.meta());
        if (ipDst != null) {
            if (ipDst.isMulticast()) {
                this.createL3MulticastGroup(nextObj, assignedVlan, groupInfos);
            } else {
                this.log.warn("Broadcast NextObj with non-multicast IP address {}", (Object)nextObj);
                Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            }
        } else {
            this.createL2FloodGroup(nextObj, assignedVlan, groupInfos);
        }
    }

    private List<OfdpaGroupHandlerUtility.GroupInfo> prepareL2InterfaceGroup(NextObjective nextObj, VlanId assignedVlan) {
        ImmutableList.Builder groupInfoBuilder = ImmutableList.builder();
        Collection buckets = nextObj.next();
        for (TrafficTreatment treatment : buckets) {
            TrafficTreatment.Builder newTreatment = DefaultTrafficTreatment.builder();
            PortNumber portNum = null;
            VlanId egressVlan = null;
            for (Instruction ins : treatment.allInstructions()) {
                if (ins.type() == Instruction.Type.L2MODIFICATION) {
                    L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                    switch (l2ins.subtype()) {
                        case VLAN_POP: {
                            newTreatment.add((Instruction)l2ins);
                            break;
                        }
                        case VLAN_ID: {
                            egressVlan = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                            break;
                        }
                        default: {
                            this.log.debug("action {} not permitted for broadcast nextObj", (Object)l2ins.subtype());
                            break;
                        }
                    }
                    continue;
                }
                if (ins.type() == Instruction.Type.OUTPUT) {
                    portNum = ((Instructions.OutputInstruction)ins).port();
                    newTreatment.add(ins);
                    continue;
                }
                this.log.debug("TrafficTreatment of type {} not permitted in  broadcast nextObjective", (Object)ins.type());
            }
            if (portNum == null) {
                this.log.warn("Can't find output port for the bucket {}.", (Object)treatment);
                continue;
            }
            VlanId l2InterfaceGroupVlan = egressVlan != null && !assignedVlan.equals(egressVlan) ? egressVlan : assignedVlan;
            int l2gk = OfdpaGroupHandlerUtility.l2InterfaceGroupKey(this.deviceId, l2InterfaceGroupVlan, portNum.toLong());
            DefaultGroupKey l2InterfaceGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
            int l2InterfaceGroupId = 0 | (l2InterfaceGroupVlan.toShort() & 0xFFF) << 16 | (int)portNum.toLong() & 0xFFFF;
            GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)newTreatment.build());
            DefaultGroupDescription l2InterfaceGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2InterfaceGroupKey, Integer.valueOf(l2InterfaceGroupId), nextObj.appId());
            this.log.debug("Trying L2-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l2InterfaceGroupId), l2InterfaceGroupKey, nextObj.id()});
            groupInfoBuilder.add((Object)new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)l2InterfaceGroupDescription, (GroupDescription)l2InterfaceGroupDescription));
        }
        return groupInfoBuilder.build();
    }

    private void createL2FloodGroup(NextObjective nextObj, VlanId vlanId, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos) {
        Integer l2FloodGroupId = 0x40000000 | vlanId.toShort() << 16;
        GroupKey l2FloodGroupKey = OfdpaGroupHandlerUtility.l2FloodGroupKey(vlanId, this.deviceId);
        List<GroupBucket> l2floodBuckets = OfdpaGroupHandlerUtility.generateNextGroupBuckets(groupInfos, GroupDescription.Type.ALL);
        DefaultGroupDescription l2floodGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(l2floodBuckets), l2FloodGroupKey, l2FloodGroupId, nextObj.appId());
        this.log.debug("Trying L2-Flood: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l2FloodGroupId), l2FloodGroupKey, nextObj.id()});
        ArrayList allGroupKeys = Lists.newArrayList();
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> groupKeyChain = new ArrayDeque<GroupKey>();
            groupKeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            groupKeyChain.addFirst(l2FloodGroupKey);
            allGroupKeys.add(groupKeyChain);
        });
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective(l2FloodGroupKey, ofdpaGrp);
        OfdpaGroupHandlerUtility.GroupChainElem gce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l2floodGroupDescription, groupInfos.size(), false, this.deviceId);
        groupInfos.forEach(groupInfo -> {
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), gce);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    private void createL3MulticastGroup(NextObjective nextObj, VlanId vlanId, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos) {
        ArrayList l3McastBuckets = new ArrayList();
        groupInfos.forEach(groupInfo -> {
            GroupDescription nextGroupDesc = groupInfo.nextGroupDesc() != null ? groupInfo.nextGroupDesc() : groupInfo.innerMostGroupDesc();
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group(new GroupId(nextGroupDesc.givenGroupId().intValue()));
            GroupBucket abucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)ttb.build());
            l3McastBuckets.add(abucket);
        });
        int l3MulticastIndex = this.getNextAvailableIndex();
        int l3MulticastGroupId = 0x60000000 | vlanId.toShort() << 16 | 0xFFFF & l3MulticastIndex;
        DefaultGroupKey l3MulticastGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3MulticastIndex));
        DefaultGroupDescription l3MulticastGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(l3McastBuckets), (GroupKey)l3MulticastGroupKey, Integer.valueOf(l3MulticastGroupId), nextObj.appId());
        ArrayList allGroupKeys = Lists.newArrayList();
        groupInfos.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$createL3MulticastGroup$7((GroupKey)l3MulticastGroupKey, allGroupKeys, arg_0));
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l3MulticastGroupKey, ofdpaGrp);
        OfdpaGroupHandlerUtility.GroupChainElem outerGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3MulticastGroupDesc, groupInfos.size(), false, this.deviceId);
        groupInfos.forEach(groupInfo -> {
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), outerGce);
            if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
                OfdpaGroupHandlerUtility.GroupChainElem innerGce = new OfdpaGroupHandlerUtility.GroupChainElem(groupInfo.nextGroupDesc(), 1, false, this.deviceId);
                this.updatePendingGroups(groupInfo.innerMostGroupDesc().appCookie(), innerGce);
            }
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    protected void processHashedNextObjective(NextObjective nextObj) {
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups = new ArrayList<OfdpaGroupHandlerUtility.GroupInfo>();
        this.createHashBucketChains(nextObj, allGroupKeys, unsentGroups);
        ArrayList<GroupBucket> l3ecmpGroupBuckets = new ArrayList<GroupBucket>();
        for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group(new GroupId(gi.nextGroupDesc().givenGroupId().intValue()));
            GroupBucket sbucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)ttb.build());
            l3ecmpGroupBuckets.add(sbucket);
        }
        int l3ecmpIndex = this.getNextAvailableIndex();
        int l3ecmpGroupId = 0x70000000 | 0xFFFFFFF & l3ecmpIndex;
        DefaultGroupKey l3ecmpGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3ecmpIndex));
        DefaultGroupDescription l3ecmpGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(l3ecmpGroupBuckets), (GroupKey)l3ecmpGroupKey, Integer.valueOf(l3ecmpGroupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l3ecmpGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3ecmpGroupDesc, l3ecmpGroupBuckets.size(), false, this.deviceId);
        allGroupKeys.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$processHashedNextObjective$9((GroupKey)l3ecmpGroupKey, arg_0));
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l3ecmpGroupKey, ofdpaGrp);
        this.log.debug("Trying L3ECMP: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3ecmpGroupId), l3ecmpGroupKey, nextObj.id()});
        for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(gi.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(gi.nextGroupDesc().appCookie(), l3ecmpGce);
            this.groupService.addGroup(gi.innerMostGroupDesc());
        }
    }

    protected void createHashBucketChains(NextObjective nextObj, List<Deque<GroupKey>> allGroupKeys, List<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups) {
        Collection buckets = nextObj.next();
        for (TrafficTreatment bucket : buckets) {
            int labelsPushed = 0;
            MplsLabel innermostLabel = null;
            for (Instruction ins : bucket.allInstructions()) {
                if (ins.type() != Instruction.Type.L2MODIFICATION) continue;
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                if (l2ins.subtype() == L2ModificationInstruction.L2SubType.MPLS_PUSH) {
                    ++labelsPushed;
                }
                if (l2ins.subtype() != L2ModificationInstruction.L2SubType.MPLS_LABEL || innermostLabel != null) continue;
                innermostLabel = ((L2ModificationInstruction.ModMplsLabelInstruction)l2ins).label();
            }
            ArrayDeque<Object> gKeyChain = new ArrayDeque<Object>();
            if (labelsPushed == 0) {
                TrafficSelector metaSelector = nextObj.meta();
                OfdpaGroupHandlerUtility.GroupInfo noLabelGroupInfo = metaSelector != null ? (Ofdpa2Pipeline.isNotMplsBos(metaSelector) ? this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), true, nextObj.meta()) : this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), false, nextObj.meta())) : this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), false, nextObj.meta());
                if (noLabelGroupInfo == null) {
                    this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                    return;
                }
                gKeyChain.addFirst(noLabelGroupInfo.innerMostGroupDesc().appCookie());
                gKeyChain.addFirst(noLabelGroupInfo.nextGroupDesc().appCookie());
                unsentGroups.add(noLabelGroupInfo);
            } else if (labelsPushed == 1) {
                OfdpaGroupHandlerUtility.GroupInfo onelabelGroupInfo = this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), true, nextObj.meta());
                if (onelabelGroupInfo == null) {
                    this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                    return;
                }
                TrafficTreatment.Builder l3vpnTtb = DefaultTrafficTreatment.builder();
                if (this.requireVlanPopBeforeMplsPush()) {
                    l3vpnTtb.popVlan();
                }
                l3vpnTtb.pushMpls().setMpls(innermostLabel).group(new GroupId(onelabelGroupInfo.nextGroupDesc().givenGroupId().intValue()));
                if (this.supportCopyTtl()) {
                    l3vpnTtb.copyTtlOut();
                }
                if (this.supportSetMplsBos()) {
                    l3vpnTtb.setMplsBos(true);
                }
                if (this.requireVlanPopBeforeMplsPush()) {
                    l3vpnTtb.pushVlan().setVlanId(VlanId.vlanId((short)4095));
                }
                GroupBucket l3vpnGrpBkt = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)l3vpnTtb.build());
                int l3vpnIndex = this.getNextAvailableIndex();
                int l3vpnGroupId = 0x92000000 | 0xFFFFFF & l3vpnIndex;
                DefaultGroupKey l3vpnGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3vpnIndex));
                DefaultGroupDescription l3vpnGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3vpnGrpBkt)), (GroupKey)l3vpnGroupKey, Integer.valueOf(l3vpnGroupId), nextObj.appId());
                OfdpaGroupHandlerUtility.GroupChainElem l3vpnGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3vpnGroupDesc, 1, false, this.deviceId);
                this.updatePendingGroups(onelabelGroupInfo.nextGroupDesc().appCookie(), l3vpnGce);
                gKeyChain.addFirst(onelabelGroupInfo.innerMostGroupDesc().appCookie());
                gKeyChain.addFirst(onelabelGroupInfo.nextGroupDesc().appCookie());
                gKeyChain.addFirst(l3vpnGroupKey);
                onelabelGroupInfo.nextGroupDesc((GroupDescription)l3vpnGroupDesc);
                unsentGroups.add(onelabelGroupInfo);
                this.log.debug("Trying L3VPN: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3vpnGroupId), l3vpnGroupKey, nextObj.id()});
            } else {
                this.log.warn("Driver currently does not handle more than 1 MPLS labels. Not processing nextObjective {}", (Object)nextObj.id());
                return;
            }
            allGroupKeys.add(gKeyChain);
        }
    }

    protected void processPwNextObjective(NextObjective nextObjective) {
        this.log.warn("Pseudo wire extensions are not supported in OFDPA 2.0 {}", (Object)nextObjective.id());
    }

    protected void addBucketToGroup(NextObjective nextObjective, NextGroup next) {
        NextObjective objectiveToAdd;
        if (nextObjective.type() != NextObjective.Type.HASHED && nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.warn("AddBuckets not applied to nextType:{} in dev:{} for next:{}", new Object[]{nextObjective.type(), this.deviceId, nextObjective.id()});
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        HashSet duplicateBuckets = Sets.newHashSet();
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        Set<PortNumber> existingPorts = OfdpaGroupHandlerUtility.getExistingOutputPorts(allActiveKeys, this.groupService, this.deviceId);
        HashSet nonDuplicateBuckets = Sets.newHashSet();
        nextObjective.next().forEach(trafficTreatment -> {
            PortNumber portNumber = OfdpaGroupHandlerUtility.readOutPortFromTreatment(trafficTreatment);
            if (portNumber == null) {
                return;
            }
            if (existingPorts.contains(portNumber)) {
                duplicateBuckets.add(trafficTreatment);
            } else {
                nonDuplicateBuckets.add(trafficTreatment);
            }
        });
        if (duplicateBuckets.isEmpty()) {
            objectiveToAdd = nextObjective;
        } else if (!nonDuplicateBuckets.isEmpty()) {
            this.log.debug("Some buckets {} already exist in next id {}, duplicate buckets will be ignored.", (Object)duplicateBuckets, (Object)nextObjective.id());
            DefaultNextObjective.Builder builder = DefaultNextObjective.builder().withType(nextObjective.type()).withId(nextObjective.id()).withMeta(nextObjective.meta()).fromApp(nextObjective.appId());
            nonDuplicateBuckets.forEach(arg_0 -> ((NextObjective.Builder)builder).addTreatment(arg_0));
            ObjectiveContext context = nextObjective.context().orElse(null);
            objectiveToAdd = builder.addToExisting(context);
        } else {
            this.log.debug("buckets already exist {} in next: {} ..ignoring bucket add", (Object)duplicateBuckets, (Object)nextObjective.id());
            Ofdpa2Pipeline.pass((Objective)nextObjective);
            return;
        }
        if (nextObjective.type() == NextObjective.Type.HASHED) {
            this.addBucketToHashGroup(objectiveToAdd, allActiveKeys);
        } else if (nextObjective.type() == NextObjective.Type.BROADCAST) {
            this.addBucketToBroadcastGroup(objectiveToAdd, allActiveKeys);
        }
    }

    private void addBucketToHashGroup(NextObjective nextObjective, List<Deque<GroupKey>> allActiveKeys) {
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups = new ArrayList<OfdpaGroupHandlerUtility.GroupInfo>();
        this.createHashBucketChains(nextObjective, allGroupKeys, unsentGroups);
        List<GroupBucket> newBuckets = OfdpaGroupHandlerUtility.generateNextGroupBuckets(unsentGroups, GroupDescription.Type.SELECT);
        Group l3ecmpGroup = this.retrieveTopLevelGroup(allActiveKeys, nextObjective.id());
        if (l3ecmpGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l3ecmpGroupKey = l3ecmpGroup.appCookie();
        int l3ecmpGroupId = (Integer)l3ecmpGroup.id().id();
        DefaultGroupDescription l3ecmpGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(newBuckets), l3ecmpGroupKey, Integer.valueOf(l3ecmpGroupId), nextObjective.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l3ecmpGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3ecmpGroupDesc, unsentGroups.size(), true, this.deviceId);
        Deque newBucketChain = (Deque)allGroupKeys.get(0);
        newBucketChain.addFirst(l3ecmpGroupKey);
        if (allActiveKeys.size() == 1 && allActiveKeys.get(0).size() == 1) {
            allActiveKeys.clear();
        }
        allActiveKeys.add(newBucketChain);
        this.updatePendingNextObjective(l3ecmpGroupKey, new OfdpaGroupHandlerUtility.OfdpaNextGroup(allActiveKeys, nextObjective));
        this.log.debug("Adding to L3ECMP: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3ecmpGroupId), l3ecmpGroupKey, nextObjective.id()});
        unsentGroups.forEach(groupInfo -> {
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), l3ecmpGce);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    private void addBucketToBroadcastGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by broadcast next obj is missing. Aborting add bucket to broadcast group for next:{} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        IpPrefix ipDst = Ofdpa2Pipeline.readIpDstFromSelector(nextObj.meta());
        if (ipDst != null) {
            if (ipDst.isMulticast()) {
                this.addBucketToL3MulticastGroup(nextObj, allActiveKeys, groupInfos, assignedVlan);
            } else {
                this.log.warn("Broadcast NextObj with non-multicast IP address {}", (Object)nextObj);
                Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            }
        } else {
            this.addBucketToL2FloodGroup(nextObj, allActiveKeys, groupInfos, assignedVlan);
        }
    }

    private void addBucketToL2FloodGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos, VlanId assignedVlan) {
        Group l2FloodGroup = this.retrieveTopLevelGroup(allActiveKeys, nextObj.id());
        if (l2FloodGroup == null) {
            this.log.warn("Can't find L2 flood group while adding bucket to it. NextObj = {}", (Object)nextObj);
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l2floodGroupKey = l2FloodGroup.appCookie();
        int l2floodGroupId = (Integer)l2FloodGroup.id().id();
        List<GroupBucket> newBuckets = OfdpaGroupHandlerUtility.generateNextGroupBuckets(groupInfos, GroupDescription.Type.ALL);
        DefaultGroupDescription l2FloodGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(newBuckets), l2floodGroupKey, Integer.valueOf(l2floodGroupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l2FloodGroupChainElement = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l2FloodGroupDescription, groupInfos.size(), true, this.deviceId);
        this.updatePendingNextObjective(l2floodGroupKey, new OfdpaGroupHandlerUtility.OfdpaNextGroup(allActiveKeys, nextObj));
        VlanId floodGroupVlan = OfdpaGroupHandlerUtility.extractVlanIdFromGroupId(l2floodGroupId);
        if (!floodGroupVlan.equals((Object)assignedVlan)) {
            this.log.warn("VLAN ID {} does not match Flood group {} to which bucket is being added, for next:{} in dev:{}. Abort.", new Object[]{assignedVlan, Integer.toHexString(l2floodGroupId), nextObj.id(), this.deviceId});
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> newBucketChain = new ArrayDeque<GroupKey>();
            newBucketChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            newBucketChain.addFirst(l2floodGroupKey);
            if (allActiveKeys.size() == 1 && ((Deque)allActiveKeys.get(0)).size() == 1) {
                allActiveKeys.clear();
            }
            allActiveKeys.add(newBucketChain);
            this.log.debug("Adding to L2FLOOD: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2floodGroupId), l2floodGroupKey, nextObj.id()});
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), l2FloodGroupChainElement);
            DeviceId innerMostGroupDevice = groupInfo.innerMostGroupDesc().deviceId();
            GroupKey innerMostGroupKey = groupInfo.innerMostGroupDesc().appCookie();
            Group existsL2IGroup = this.groupService.getGroup(innerMostGroupDevice, innerMostGroupKey);
            if (existsL2IGroup != null) {
                this.processPendingAddGroupsOrNextObjs(innerMostGroupKey, true);
            } else {
                this.groupService.addGroup(groupInfo.innerMostGroupDesc());
            }
        });
    }

    private void addBucketToL3MulticastGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos, VlanId assignedVlan) {
        ArrayList newBuckets = Lists.newArrayList();
        groupInfos.forEach(groupInfo -> {
            GroupDescription nextGroupDesc = groupInfo.nextGroupDesc() != null ? groupInfo.nextGroupDesc() : groupInfo.innerMostGroupDesc();
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            treatmentBuilder.group(new GroupId(nextGroupDesc.givenGroupId().intValue()));
            GroupBucket newBucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatmentBuilder.build());
            newBuckets.add(newBucket);
        });
        Group l3mcastGroup = this.retrieveTopLevelGroup(allActiveKeys, nextObj.id());
        if (l3mcastGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l3mcastGroupKey = l3mcastGroup.appCookie();
        int l3mcastGroupId = (Integer)l3mcastGroup.id().id();
        VlanId expectedVlan = OfdpaGroupHandlerUtility.extractVlanIdFromGroupId(l3mcastGroupId);
        if (!expectedVlan.equals((Object)assignedVlan)) {
            this.log.warn("VLAN ID {} does not match L3 Mcast group {} to which bucket is being added, for next:{} in dev:{}. Abort.", new Object[]{assignedVlan, Integer.toHexString(l3mcastGroupId), nextObj.id(), this.deviceId});
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
        }
        DefaultGroupDescription l3mcastGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets((List)newBuckets), l3mcastGroupKey, Integer.valueOf(l3mcastGroupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l3mcastGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3mcastGroupDescription, groupInfos.size(), true, this.deviceId);
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> newBucketChain = new ArrayDeque<GroupKey>();
            newBucketChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
            if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
                newBucketChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            }
            newBucketChain.addFirst(l3mcastGroupKey);
            if (allActiveKeys.size() == 1 && ((Deque)allActiveKeys.get(0)).size() == 1) {
                allActiveKeys.clear();
            }
            allActiveKeys.add(newBucketChain);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), l3mcastGce);
            if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
                OfdpaGroupHandlerUtility.GroupChainElem innerGce = new OfdpaGroupHandlerUtility.GroupChainElem(groupInfo.nextGroupDesc(), 1, false, this.deviceId);
                this.updatePendingGroups(groupInfo.innerMostGroupDesc().appCookie(), innerGce);
            }
            this.log.debug("Adding to L3MCAST: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3mcastGroupId), l3mcastGroupKey, nextObj.id()});
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
        this.updatePendingNextObjective(l3mcastGroupKey, new OfdpaGroupHandlerUtility.OfdpaNextGroup(allActiveKeys, nextObj));
    }

    protected void removeBucketFromGroup(NextObjective nextObjective, NextGroup next) {
        if (nextObjective.type() != NextObjective.Type.HASHED && nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.warn("RemoveBuckets not applied to nextType:{} in dev:{} for next:{}", new Object[]{nextObjective.type(), this.deviceId, nextObjective.id()});
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        HashSet portsToRemove = Sets.newHashSet();
        Collection treatments = nextObjective.next();
        for (TrafficTreatment treatment : treatments) {
            PortNumber portToRemove = OfdpaGroupHandlerUtility.readOutPortFromTreatment(treatment);
            if (portToRemove == null) {
                this.log.warn("treatment {} of next objective {} has no outport.. cannot remove bucketfrom group in dev: {}", new Object[]{treatment, nextObjective.id(), this.deviceId});
                continue;
            }
            portsToRemove.add(portToRemove);
        }
        if (portsToRemove.isEmpty()) {
            this.log.warn("next objective {} has no outport.. cannot remove bucketfrom group in dev: {}", (Object)nextObjective.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
        }
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        ArrayList chainsToRemove = Lists.newArrayList();
        for (Deque gkeys : allActiveKeys) {
            GroupKey groupWithPort = (GroupKey)gkeys.peekLast();
            Group group = this.groupService.getGroup(this.deviceId, groupWithPort);
            if (group == null) {
                this.log.warn("Inconsistent group chain found when removing bucketfor next:{} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
                continue;
            }
            if (group.buckets().buckets().isEmpty()) {
                this.log.warn("Can't get output port information from group {} because there is no bucket in the group.", (Object)group.id().toString());
                continue;
            }
            PortNumber pout = OfdpaGroupHandlerUtility.readOutPortFromTreatment(((GroupBucket)group.buckets().buckets().get(0)).treatment());
            if (!portsToRemove.contains(pout)) continue;
            chainsToRemove.add(gkeys);
        }
        if (chainsToRemove.isEmpty()) {
            this.log.warn("Could not find appropriate group-chain for removing bucket for next id {} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        ArrayList bucketsToRemove = Lists.newArrayList();
        GroupKey modGroupKey = (GroupKey)((Deque)chainsToRemove.get(0)).peekFirst();
        Group modGroup = this.groupService.getGroup(this.deviceId, modGroupKey);
        for (Deque foundChain : chainsToRemove) {
            if (foundChain.size() < 2) {
                this.log.warn("Can't find second group key from chain {}", (Object)foundChain);
                continue;
            }
            GroupKey pointedGroupKey = (GroupKey)foundChain.stream().collect(Collectors.toList()).get(1);
            Group pointedGroup = this.groupService.getGroup(this.deviceId, pointedGroupKey);
            if (pointedGroup == null) continue;
            GroupBucket bucket = nextObjective.type() == NextObjective.Type.HASHED ? DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)DefaultTrafficTreatment.builder().group(pointedGroup.id()).build()) : DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)DefaultTrafficTreatment.builder().group(pointedGroup.id()).build());
            bucketsToRemove.add(bucket);
        }
        GroupBuckets removeBuckets = new GroupBuckets((List)bucketsToRemove);
        List pointedGroupIds = bucketsToRemove.stream().map(GroupBucket::treatment).map(TrafficTreatment::allInstructions).flatMap(Collection::stream).filter(inst -> inst instanceof Instructions.GroupInstruction).map(inst -> (Instructions.GroupInstruction)inst).map(Instructions.GroupInstruction::groupId).map(Identifier::id).map(Integer::toHexString).map(id -> "0x" + id).collect(Collectors.toList());
        this.log.debug("Removing buckets from group id 0x{} pointing to group id(s) {} for next id {} in device {}", new Object[]{Integer.toHexString((Integer)modGroup.id().id()), pointedGroupIds, nextObjective.id(), this.deviceId});
        this.addPendingUpdateNextObjective(modGroupKey, nextObjective);
        this.groupService.removeBucketsFromGroup(this.deviceId, modGroupKey, removeBuckets, modGroupKey, nextObjective.appId());
        allActiveKeys.removeAll(chainsToRemove);
        if (allActiveKeys.isEmpty()) {
            ArrayDeque<GroupKey> top = new ArrayDeque<GroupKey>();
            top.add(modGroupKey);
            allActiveKeys.add(top);
        }
        this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new OfdpaGroupHandlerUtility.OfdpaNextGroup(allActiveKeys, nextObjective));
    }

    protected void removeGroup(NextObjective nextObjective, NextGroup next) {
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        List<GroupKey> groupKeys = allActiveKeys.stream().map(Deque::getFirst).collect(Collectors.toList());
        this.addPendingRemoveNextObjective(nextObjective, groupKeys);
        allActiveKeys.forEach(groupChain -> groupChain.forEach(groupKey -> this.groupService.removeGroup(this.deviceId, groupKey, nextObjective.appId())));
        this.flowObjectiveStore.removeNextGroup(Integer.valueOf(nextObjective.id()));
    }

    protected void updatePendingNextObjective(GroupKey groupKey, OfdpaGroupHandlerUtility.OfdpaNextGroup nextGrp) {
        this.pendingAddNextObjectives.asMap().compute(groupKey, (k, val) -> {
            if (val == null) {
                val = new CopyOnWriteArrayList<OfdpaGroupHandlerUtility.OfdpaNextGroup>();
            }
            val.add(nextGrp);
            return val;
        });
    }

    protected void updatePendingGroups(GroupKey groupKey, OfdpaGroupHandlerUtility.GroupChainElem gce) {
        this.pendingGroups.asMap().compute(groupKey, (k, val) -> {
            if (val == null) {
                val = Sets.newConcurrentHashSet();
            }
            val.add(gce);
            return val;
        });
    }

    protected void addPendingUpdateNextObjective(GroupKey groupKey, NextObjective nextObjective) {
        this.pendingUpdateNextObjectives.compute(groupKey, (gKey, nextObjs) -> {
            if (nextObjs != null) {
                nextObjs.add(nextObjective);
            } else {
                nextObjs = Sets.newHashSet((Object[])new NextObjective[]{nextObjective});
            }
            return nextObjs;
        });
    }

    private void processPendingUpdateNextObjs(GroupKey groupKey) {
        this.pendingUpdateNextObjectives.compute(groupKey, (gKey, nextObjs) -> {
            if (nextObjs != null) {
                nextObjs.forEach(nextObj -> {
                    this.log.debug("Group {} updated, update pending next objective {}.", (Object)groupKey, nextObj);
                    Ofdpa2Pipeline.pass((Objective)nextObj);
                });
            }
            return Sets.newHashSet();
        });
    }

    private void processPendingRemoveNextObjs(GroupKey key) {
        this.pendingRemoveNextObjectives.asMap().forEach((nextObjective, groupKeys) -> {
            if (groupKeys.isEmpty()) {
                this.pendingRemoveNextObjectives.invalidate(nextObjective);
                Ofdpa2Pipeline.pass((Objective)nextObjective);
            } else {
                groupKeys.remove(key);
            }
        });
    }

    protected int getNextAvailableIndex() {
        return (int)this.nextIndex.incrementAndGet();
    }

    protected Group retrieveTopLevelGroup(List<Deque<GroupKey>> allActiveKeys, int nextid) {
        if (allActiveKeys.isEmpty()) {
            this.log.warn("Could not determine top level group while processingnext:{} in dev:{}", (Object)nextid, (Object)this.deviceId);
            return null;
        }
        GroupKey topLevelGroupKey = allActiveKeys.get(0).peekFirst();
        Group topGroup = this.groupService.getGroup(this.deviceId, topLevelGroupKey);
        if (topGroup == null) {
            this.log.warn("Could not find top level group while processing next:{} in dev:{}", (Object)nextid, (Object)this.deviceId);
        }
        return topGroup;
    }

    protected void processPendingAddGroupsOrNextObjs(GroupKey key, boolean added) {
        Set gceSet = (Set)this.pendingGroups.asMap().remove(key);
        if (gceSet != null) {
            for (OfdpaGroupHandlerUtility.GroupChainElem gce : gceSet) {
                this.log.debug("Group service {} group key {} in device {}. Processing next group in group chain with group id 0x{}", new Object[]{added ? "ADDED" : "processed", key, this.deviceId, Integer.toHexString(gce.groupDescription().givenGroupId())});
                this.processGroupChain(gce);
            }
        } else {
            List nextGrpList = (List)this.pendingAddNextObjectives.getIfPresent((Object)key);
            if (nextGrpList != null) {
                this.pendingAddNextObjectives.invalidate((Object)key);
                nextGrpList.forEach(nextGrp -> {
                    this.log.debug("Group service {} group key {} in device:{}. Done implementing next objective: {} <<-->> gid:0x{}", new Object[]{added ? "ADDED" : "processed", key, this.deviceId, nextGrp.nextObjective().id(), Integer.toHexString(this.groupService.getGroup(this.deviceId, key).givenGroupId())});
                    Ofdpa2Pipeline.pass((Objective)nextGrp.nextObjective());
                    this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextGrp.nextObjective().id()), (NextGroup)nextGrp);
                    this.pendingBuckets.compute(nextGrp.nextObjective().id(), (nextId, pendBkts) -> {
                        if (pendBkts != null) {
                            pendBkts.forEach(pendBkt -> this.addBucketToGroup((NextObjective)pendBkt, (NextGroup)nextGrp));
                        }
                        return null;
                    });
                });
            }
        }
    }

    private void processGroupChain(OfdpaGroupHandlerUtility.GroupChainElem gce) {
        int waitOnGroups = gce.decrementAndGetGroupsWaitedOn();
        if (waitOnGroups != 0) {
            this.log.debug("GCE: {} not ready to be processed", (Object)gce);
            return;
        }
        this.log.debug("GCE: {} ready to be processed", (Object)gce);
        if (gce.addBucketToGroup()) {
            this.groupService.addBucketsToGroup(gce.groupDescription().deviceId(), gce.groupDescription().appCookie(), gce.groupDescription().buckets(), gce.groupDescription().appCookie(), gce.groupDescription().appId());
        } else {
            this.groupService.addGroup(gce.groupDescription());
        }
    }

    protected void addPendingRemoveNextObjective(NextObjective nextObjective, List<GroupKey> groupKeys) {
        this.pendingRemoveNextObjectives.put((Object)nextObjective, groupKeys);
    }

    private static /* synthetic */ void lambda$processHashedNextObjective$9(GroupKey l3ecmpGroupKey, Deque gKeyChain) {
        gKeyChain.addFirst(l3ecmpGroupKey);
    }

    private static /* synthetic */ void lambda$createL3MulticastGroup$7(GroupKey l3MulticastGroupKey, List allGroupKeys, OfdpaGroupHandlerUtility.GroupInfo groupInfo) {
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
        if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
            gkeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
        }
        gkeyChain.addFirst(l3MulticastGroupKey);
        allGroupKeys.add(gkeyChain);
    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            Ofdpa2GroupHandler.this.log.trace("received group event of type {}", (Object)event.type());
            switch ((GroupEvent.Type)event.type()) {
                case GROUP_ADDED: {
                    Ofdpa2GroupHandler.this.processPendingAddGroupsOrNextObjs(((Group)event.subject()).appCookie(), true);
                    break;
                }
                case GROUP_REMOVED: {
                    Ofdpa2GroupHandler.this.processPendingRemoveNextObjs(((Group)event.subject()).appCookie());
                    break;
                }
                case GROUP_UPDATED: {
                    Ofdpa2GroupHandler.this.processPendingUpdateNextObjs(((Group)event.subject()).appCookie());
                    break;
                }
            }
        }
    }
}

