/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.pipeline.ofdpa.CpqdOfdpa2GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.packet.PacketPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpqdOfdpa2Pipeline
extends Ofdpa2Pipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int PUNT_TABLE = 63;
    private static final int POP_VLAN_PUNT_GROUP_ID = -1073741824;

    @Override
    protected boolean requireVlanExtensions() {
        return false;
    }

    protected boolean supportCopyTtl() {
        return true;
    }

    protected boolean supportTaggedMpls() {
        return false;
    }

    protected boolean supportPuntGroup() {
        return false;
    }

    @Override
    protected void initDriverId() {
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.CpqdOfdpa2Pipeline");
    }

    @Override
    protected void initGroupHander(PipelinerContext context) {
        this.groupHandler = new CpqdOfdpa2GroupHandler();
        this.groupHandler.init(this.deviceId, context);
    }

    @Override
    protected List<FlowRule> processVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchVlanId(vidCriterion.vlanId());
        treatment.transition(Integer.valueOf(20));
        if (vidCriterion.vlanId() == VlanId.NONE) {
            treatment.pushVlan().setVlanId(assignedVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion.port() == PortNumber.ALL) {
            for (Port port : this.deviceService.getPorts(this.deviceId)) {
                if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                portnums.add(port.number());
            }
        } else {
            portnums.add(portCriterion.port());
        }
        for (PortNumber pnum : portnums) {
            if (this.supportPuntGroup() && vidCriterion.vlanId() == VlanId.NONE) {
                GroupKey groupKey = this.popVlanPuntGroupKey();
                Group group = this.groupService.getGroup(this.deviceId, groupKey);
                if (group != null) {
                    rules.add(this.buildPuntTableRule(pnum, assignedVlan));
                } else {
                    this.log.info("popVlanPuntGroup not found in dev:{}", (Object)this.deviceId);
                    return Collections.emptyList();
                }
            }
            selector.matchInPort(pnum);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            rules.add(rule);
        }
        return rules;
    }

    private FlowRule buildPuntTableRule(PortNumber portNumber, VlanId assignedVlan) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchInPort(portNumber).matchVlanId(assignedVlan);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().group(new GroupId(-1073741824));
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue()).fromApp(this.driverId).makePermanent().forTable(63).build();
    }

    private FlowRule buildArpPunt(VlanId assignedVlan, ApplicationId applicationId) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP).matchVlanId(assignedVlan);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().popVlan().punt();
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue() + 1).fromApp(applicationId).makePermanent().forTable(60).build();
    }

    private FlowRule buildIcmpV6Punt(VlanId assignedVlan, ApplicationId applicationId) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchVlanId(assignedVlan).matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().popVlan().punt();
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue() + 1).fromApp(applicationId).makePermanent().forTable(60).build();
    }

    @Override
    protected List<FlowRule> processEthDstFilter(PortCriterion portCriterion, EthCriterion ethCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        if (portCriterion != null && portCriterion.port() == PortNumber.ANY) {
            return this.processEthDstOnlyFilter(ethCriterion, applicationId);
        }
        if (ethCriterion.mask() != null) {
            return this.processMcastEthDstFilter(ethCriterion, applicationId);
        }
        if (vidCriterion.vlanId() == VlanId.NONE) {
            vidCriterion = (VlanIdCriterion)Criteria.matchVlanId((VlanId)assignedVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion.port() == PortNumber.ALL) {
            for (Port port : this.deviceService.getPorts(this.deviceId)) {
                if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                portnums.add(port.number());
            }
        } else {
            portnums.add(portCriterion.port());
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (PortNumber pnum : portnums) {
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchEthDst(ethCriterion.mac());
            if (!this.supportTaggedMpls()) {
                treatment.popVlan();
            }
            treatment.transition(Integer.valueOf(30));
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.MPLS_UNICAST);
            selector.matchEthDst(ethCriterion.mac());
            if (!this.supportTaggedMpls()) {
                treatment.popVlan();
            }
            treatment.transition(Integer.valueOf(23));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.TYPE_IPV6);
            selector.matchEthDst(ethCriterion.mac());
            if (!this.supportTaggedMpls()) {
                treatment.popVlan();
            }
            treatment.transition(Integer.valueOf(30));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
        }
        return rules;
    }

    @Override
    protected List<FlowRule> processEthDstOnlyFilter(EthCriterion ethCriterion, ApplicationId applicationId) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDst(ethCriterion.mac());
        if (!this.supportTaggedMpls()) {
            treatment.popVlan();
        }
        treatment.transition(Integer.valueOf(30));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        return ImmutableList.builder().add((Object)rule).build();
    }

    @Override
    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        NextGroup next;
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null || ethType.ethType().toShort() != Ethernet.TYPE_IPV4 && ethType.ethType().toShort() != Ethernet.MPLS_UNICAST && ethType.ethType().toShort() != Ethernet.TYPE_IPV6) {
            this.log.warn("processSpecific: Unsupported forwarding objective criteriaethType:{} in dev:{}", (Object)ethType, (Object)this.deviceId);
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        boolean defaultRule = false;
        int forTableId = -1;
        TrafficSelector.Builder filteredSelector = DefaultTrafficSelector.builder();
        TrafficSelector.Builder complementarySelector = DefaultTrafficSelector.builder();
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
            if (ipv4Dst.isMulticast()) {
                if (ipv4Dst.prefixLength() != 32) {
                    this.log.warn("Multicast specific forwarding objective can only be /32");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                VlanId assignedVlan = CpqdOfdpa2Pipeline.readVlanFromSelector(fwd.meta());
                if (assignedVlan == null) {
                    this.log.warn("VLAN ID required by multicast specific fwd obj is missing. Abort.");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                filteredSelector.matchVlanId(assignedVlan);
                filteredSelector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
                forTableId = 40;
                this.log.debug("processing IPv4 multicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            } else {
                if (ipv4Dst.prefixLength() == 0) {
                    filteredSelector.matchEthType(Ethernet.TYPE_IPV4);
                } else {
                    filteredSelector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
                }
                forTableId = 30;
                this.log.debug("processing IPv4 unicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            }
        } else if (ethType.ethType().toShort() == Ethernet.TYPE_IPV6) {
            if (this.buildIpv6Selector(filteredSelector, fwd) < 0) {
                return Collections.emptyList();
            }
            forTableId = 30;
        } else {
            filteredSelector.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(((MplsCriterion)selector.getCriterion(Criterion.Type.MPLS_LABEL)).label());
            MplsBosCriterion bos = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
            if (bos != null) {
                filteredSelector.matchMplsBos(bos.mplsBos());
            }
            forTableId = 24;
            this.log.debug("processing MPLS specific forwarding objective {} -> next:{} in dev {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        }
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction i : fwd.treatment().allInstructions()) {
                L3ModificationInstruction l3instr;
                if (!this.supportCopyTtl() && i instanceof L3ModificationInstruction && ((l3instr = (L3ModificationInstruction)i).subtype().equals((Object)L3ModificationInstruction.L3SubType.TTL_IN) || l3instr.subtype().equals((Object)L3ModificationInstruction.L3SubType.TTL_OUT))) continue;
                tb.deferred().add(i);
            }
        }
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            tb.deferred().group(group.id());
        }
        tb.transition(Integer.valueOf(60));
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector.build()).withTreatment(tb.build()).forTable(forTableId);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ArrayList<FlowRule> flowRuleCollection = new ArrayList<FlowRule>();
        flowRuleCollection.add(ruleBuilder.build());
        if (defaultRule) {
            flowRuleCollection.add(this.defaultRoute(fwd, complementarySelector, forTableId, tb));
            this.log.debug("Default rule 0.0.0.0/0 is being installed two rules");
        }
        return flowRuleCollection;
    }

    @Override
    protected Collection<FlowRule> processEthDstSpecific(ForwardingObjective fwd) {
        NextGroup next;
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector selector = fwd.selector();
        EthCriterion ethCriterion = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null) {
            this.log.warn("Forwarding objective for bridging requires vlan. Not installing fwd:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        if (!ethCriterion.mac().equals((Object)MacAddress.NONE) && !ethCriterion.mac().equals((Object)MacAddress.BROADCAST)) {
            filteredSelectorBuilder.matchEthDst(ethCriterion.mac());
            this.log.debug("processing L2 forwarding objective:{} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            this.log.debug("processing L2 Broadcast forwarding objective:{} -> next:{} in dev:{} for vlan:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId, vlanIdCriterion.vlanId()});
        }
        filteredSelectorBuilder.matchVlanId(vlanIdCriterion.vlanId());
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        if (fwd.treatment() != null) {
            this.log.warn("Ignoring traffic treatment in fwd rule {} meant for L2 tablefor dev:{}. Expecting only nextId", (Object)fwd.id(), (Object)this.deviceId);
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group != null) {
                treatmentBuilder.deferred().group(group.id());
            } else {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
        }
        treatmentBuilder.immediate().transition(Integer.valueOf(60));
        TrafficTreatment filteredTreatment = treatmentBuilder.build();
        DefaultFlowRule.Builder flowRuleBuilder = DefaultFlowRule.builder();
        flowRuleBuilder.fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(filteredTreatment).forTable(50);
        if (fwd.permanent()) {
            flowRuleBuilder.makePermanent();
        } else {
            flowRuleBuilder.makeTemporary(fwd.timeout());
        }
        rules.add(flowRuleBuilder.build());
        return rules;
    }

    @Override
    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.info("Processing versatile forwarding objective");
        EthTypeCriterion ethType = (EthTypeCriterion)fwd.selector().getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.log.error("Versatile forwarding objective must include ethType");
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (fwd.nextId() == null && fwd.treatment() == null) {
            this.log.error("Forwarding objective {} from {} must contain nextId or Treatment", (Object)fwd.selector(), (Object)fwd.appId());
            return Collections.emptySet();
        }
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        fwd.selector().criteria().forEach(criterion -> {
            if (criterion instanceof VlanIdCriterion) {
                return;
            }
            if (criterion instanceof Icmpv6TypeCriterion || criterion instanceof Icmpv6CodeCriterion) {
                this.log.warn("ICMPv6 Type and ICMPv6 Code are not supported");
            } else {
                sbuilder.add(criterion);
            }
        });
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction ins : fwd.treatment().allInstructions()) {
                if (ins instanceof Instructions.OutputInstruction) {
                    Instructions.OutputInstruction o = (Instructions.OutputInstruction)ins;
                    if (o.port() == PortNumber.CONTROLLER) {
                        ttBuilder.transition(Integer.valueOf(63));
                        continue;
                    }
                    this.log.warn("Only allowed treatments in versatile forwarding objectives are punts to the controller");
                    continue;
                }
                this.log.warn("Cannot process instruction in versatile fwd {}", (Object)ins);
            }
            if (fwd.treatment().clearedDeferred()) {
                ttBuilder.wipeDeferred();
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            ttBuilder.deferred().group(group.id());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(ttBuilder.build()).makePermanent().forTable(60);
        return Collections.singletonList(ruleBuilder.build());
    }

    @Override
    protected void initializePipeline() {
        this.initTableMiss(0, 10, null);
        this.initTableMiss(10, 60, null);
        this.initTableMiss(20, 50, null);
        this.initTableMiss(30, 60, null);
        this.initTableMiss(40, 60, null);
        this.initTableMiss(23, 24, null);
        this.initTableMiss(24, 60, null);
        this.initTableMiss(50, 60, null);
        this.initTableMiss(60, -1, null);
        if (this.supportPuntGroup()) {
            this.initTableMiss(63, -1, DefaultTrafficTreatment.builder().punt().build());
            this.initPopVlanPuntGroup();
        } else {
            this.initTableMiss(63, -1, DefaultTrafficTreatment.builder().popVlan().punt().build());
        }
    }

    private void initTableMiss(final int thisTable, int nextTable, TrafficTreatment treatment) {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector selector = DefaultTrafficSelector.builder().build();
        if (treatment == null) {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            if (nextTable > 0) {
                tBuilder.transition(Integer.valueOf(nextTable));
            }
            treatment = tBuilder.build();
        }
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).withTreatment(treatment).withPriority(0).fromApp(this.driverId).makePermanent().forTable(thisTable).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized table {} on {}", (Object)thisTable, (Object)CpqdOfdpa2Pipeline.this.deviceId);
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.warn("Failed to initialize table {} on {}", (Object)thisTable, (Object)CpqdOfdpa2Pipeline.this.deviceId);
            }
        }));
    }

    private void initPopVlanPuntGroup() {
        GroupKey groupKey = this.popVlanPuntGroupKey();
        TrafficTreatment bucketTreatment = DefaultTrafficTreatment.builder().popVlan().punt().build();
        GroupBucket bucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)bucketTreatment);
        DefaultGroupDescription groupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(bucket)), groupKey, Integer.valueOf(-1073741824), this.driverId);
        this.groupService.addGroup((GroupDescription)groupDesc);
        this.log.info("Initialized pop vlan punt group on {}", (Object)this.deviceId);
    }

    private GroupKey popVlanPuntGroupKey() {
        int hash = 0xC0000000 | Objects.hash(this.deviceId) & 0xFFFF;
        return new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)hash));
    }
}

