/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.driver.pipeline.ofdpa.OfdpaGroupHandlerUtility;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpqdOfdpa2GroupHandler
extends Ofdpa2GroupHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected OfdpaGroupHandlerUtility.GroupInfo createL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta) {
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder innerTtb = DefaultTrafficTreatment.builder();
        VlanId vlanid = null;
        long portNum = 0L;
        boolean setVlan = false;
        boolean popVlan = false;
        MacAddress srcMac = MacAddress.ZERO;
        MacAddress dstMac = MacAddress.ZERO;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: {
                        dstMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthDst(dstMac);
                        break;
                    }
                    case ETH_SRC: {
                        srcMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthSrc(srcMac);
                        break;
                    }
                    case VLAN_ID: {
                        vlanid = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                        outerTtb.setVlanId(vlanid);
                        setVlan = true;
                        break;
                    }
                    case VLAN_POP: {
                        innerTtb.popVlan();
                        popVlan = true;
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                portNum = ((Instructions.OutputInstruction)ins).port().toLong();
                innerTtb.add(ins);
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives:  {}", (Object)ins.type());
        }
        if (vlanid == null && meta != null) {
            Criterion vidCriterion = meta.getCriterion(Criterion.Type.VLAN_VID);
            if (vidCriterion != null) {
                vlanid = ((VlanIdCriterion)vidCriterion).vlanId();
            }
            if (vlanid != null && !setVlan) {
                outerTtb.setVlanId(vlanid);
            }
        }
        if (vlanid == null) {
            this.log.error("Driver cannot process an L2/L3 group chain without egress vlan information for dev: {} port:{}", (Object)this.deviceId, (Object)portNum);
            return null;
        }
        if (!setVlan && !popVlan) {
            TrafficTreatment.Builder temp = DefaultTrafficTreatment.builder();
            temp.popVlan();
            innerTtb.build().allInstructions().forEach(i -> temp.add(i));
            innerTtb = temp;
        }
        int l2groupId = 0 | vlanid.toShort() << 16 | (int)portNum;
        int l2gk = OfdpaGroupHandlerUtility.l2InterfaceGroupKey(this.deviceId, vlanid, portNum);
        DefaultGroupKey l2groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
        DefaultGroupDescription outerGrpDesc = null;
        if (mpls) {
            int mplsInterfaceIndex = this.getNextAvailableIndex();
            int mplsgroupId = 0x90000000 | 0xFFFFFF & mplsInterfaceIndex;
            DefaultGroupKey mplsgroupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)mplsInterfaceIndex));
            outerTtb.group(new GroupId(l2groupId));
            GroupBucket mplsinterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(mplsinterfaceGroupBucket)), (GroupKey)mplsgroupkey, Integer.valueOf(mplsgroupId), appId);
            this.log.debug("Trying MPLS-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(mplsgroupId), mplsgroupkey, nextId});
        } else {
            int l3unicastIndex = this.getNextAvailableIndex();
            int l3groupId = 0x20000000 | 0xFFFFFFF & l3unicastIndex;
            DefaultGroupKey l3groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3unicastIndex));
            outerTtb.group(new GroupId(l2groupId));
            GroupBucket l3unicastGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3unicastGroupBucket)), (GroupKey)l3groupkey, Integer.valueOf(l3groupId), appId);
            this.log.debug("Trying L3Unicast: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l3groupId), l3groupkey, nextId});
        }
        OfdpaGroupHandlerUtility.GroupChainElem gce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)outerGrpDesc, 1, false, this.deviceId);
        this.updatePendingGroups((GroupKey)l2groupkey, gce);
        GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)innerTtb.build());
        DefaultGroupDescription l2groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2groupkey, Integer.valueOf(l2groupId), appId);
        this.log.debug("Trying L2Interface: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2groupId), l2groupkey, nextId});
        return new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)l2groupDescription, (GroupDescription)outerGrpDesc);
    }

    @Override
    protected void processHashedNextObjective(NextObjective nextObjective) {
        TrafficSelector metaSelector = nextObjective.meta();
        if (metaSelector != null && Ofdpa2Pipeline.isNotMplsBos(metaSelector)) {
            ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
            ArrayList<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups = new ArrayList<OfdpaGroupHandlerUtility.GroupInfo>();
            this.createHashBucketChains(nextObjective, allGroupKeys, unsentGroups);
            ArrayList<GroupBucket> mplsEcmpGroupBuckets = new ArrayList<GroupBucket>();
            for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
                TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
                ttb.group(new GroupId(gi.nextGroupDesc().givenGroupId().intValue()));
                GroupBucket sbucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)ttb.build());
                mplsEcmpGroupBuckets.add(sbucket);
            }
            int mplsEcmpIndex = this.getNextAvailableIndex();
            int mplsEcmpGroupId = OfdpaGroupHandlerUtility.makeMplsForwardingGroupId(OfdpaGroupHandlerUtility.OfdpaMplsGroupSubType.MPLS_ECMP, mplsEcmpIndex);
            DefaultGroupKey mplsEmpGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)mplsEcmpIndex));
            DefaultGroupDescription mplsEcmpGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(mplsEcmpGroupBuckets), (GroupKey)mplsEmpGroupKey, Integer.valueOf(mplsEcmpGroupId), nextObjective.appId());
            OfdpaGroupHandlerUtility.GroupChainElem mplsEcmpGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)mplsEcmpGroupDesc, mplsEcmpGroupBuckets.size(), false, this.deviceId);
            allGroupKeys.forEach(arg_0 -> CpqdOfdpa2GroupHandler.lambda$processHashedNextObjective$1((GroupKey)mplsEmpGroupKey, arg_0));
            OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObjective);
            this.updatePendingNextObjective((GroupKey)mplsEmpGroupKey, ofdpaGrp);
            this.log.debug("Trying MPLS-ECMP: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(mplsEcmpGroupId), mplsEmpGroupKey, nextObjective.id()});
            for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
                this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(gi.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
                this.updatePendingGroups(gi.nextGroupDesc().appCookie(), mplsEcmpGce);
                this.groupService.addGroup(gi.innerMostGroupDesc());
            }
            return;
        }
        super.processHashedNextObjective(nextObjective);
    }

    private static /* synthetic */ void lambda$processHashedNextObjective$1(GroupKey mplsEmpGroupKey, Deque gkeyChain) {
        gkeyChain.addFirst(mplsEmpGroupKey);
    }
}

