/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftRouterPipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    protected static final int FILTER_TABLE = 0;
    protected static final int FIB_TABLE = 1;
    private static final int DROP_PRIORITY = 0;
    private static final int DEFAULT_PRIORITY = 32768;
    private static final int HIGHEST_PRIORITY = 65535;
    private ServiceDirectory serviceDirectory;
    protected FlowRuleService flowRuleService;
    private CoreService coreService;
    private FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId appId;
    private ApplicationId driverId;
    private KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{DummyGroup.class}).build();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.flowObjectiveStore = context.store();
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.SoftRouterPipeline");
        this.initializePipeline();
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            this.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    public void forward(final ForwardingObjective fwd) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(fwd);
        switch (fwd.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}", (Object)fwd.op());
            }
        }
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                SoftRouterPipeline.this.pass((Objective)fwd);
            }

            public void onError(FlowRuleOperations ops) {
                SoftRouterPipeline.this.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) {
                    this.log.error("Next Objectives of type Simple should only have a single Traffic Treatment. Next Objective Id:{}", (Object)nextObjective.id());
                    this.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                this.processSimpleNextObjective(nextObjective);
                break;
            }
            case HASHED: 
            case BROADCAST: 
            case FAILOVER: {
                this.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                this.log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                this.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    private void initializePipeline() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        treatment.drop();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(0).build();
        ops = ops.add(rule);
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(1).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                SoftRouterPipeline.this.log.info("Provisioned drop rules in both tables");
            }

            public void onError(FlowRuleOperations ops) {
                SoftRouterPipeline.this.log.info("Failed to provision drop rules");
            }
        }));
    }

    private void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        EthCriterion e = null;
        VlanIdCriterion v = null;
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            this.log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            this.fail((Objective)filt, ObjectiveError.UNKNOWN);
            return;
        }
        PortCriterion p = (PortCriterion)filt.key();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Criterion c : filt.conditions()) {
            if (c.type() == Criterion.Type.ETH_DST || c.type() == Criterion.Type.ETH_DST_MASKED) {
                e = (EthCriterion)c;
                continue;
            }
            if (c.type() == Criterion.Type.VLAN_VID) {
                v = (VlanIdCriterion)c;
                continue;
            }
            this.log.error("Unsupported filter {}", (Object)c);
            this.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
            return;
        }
        this.log.debug("Modifying Port/VLAN/MAC filtering rules in filter table: {}/{}/{}", new Object[]{p.port(), v.vlanId(), e.mac()});
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchInPort(p.port());
        if (e.mask() != null) {
            selector.matchEthDstMasked(e.mac(), e.mask());
        } else {
            selector.matchEthDst(e.mac());
        }
        selector.matchVlanId(v.vlanId());
        if (!v.vlanId().equals((Object)VlanId.NONE)) {
            treatment.popVlan();
        }
        treatment.transition(Integer.valueOf(1));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(0).build();
        ops = install ? ops.add(rule) : ops.remove(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                SoftRouterPipeline.this.log.info("Applied filtering rules");
                SoftRouterPipeline.this.pass((Objective)filt);
            }

            public void onError(FlowRuleOperations ops) {
                SoftRouterPipeline.this.log.info("Failed to apply filtering rules");
                SoftRouterPipeline.this.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                return this.processVersatile(fwd);
            }
        }
        this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return Collections.emptySet();
    }

    private Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.debug("Received versatile fwd: to next:{}", (Object)fwd.nextId());
        ArrayList<FlowRule> flowrules = new ArrayList<FlowRule>();
        if (fwd.nextId() == null && fwd.treatment() == null) {
            this.log.error("Forwarding objective {} from {} must contain nextId or Treatment", (Object)fwd.selector(), (Object)fwd.appId());
            return Collections.emptySet();
        }
        int tableId = 0;
        if (fwd.treatment() != null && this.containsPunt(fwd.treatment()) && fwd.selector() != null && this.matchesIp(fwd.selector()) && !this.matchesControlTraffic(fwd.selector())) {
            tableId = 1;
        }
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            fwd.treatment().immediate().forEach(ins -> ttBuilder.add(ins));
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
            if (next == null) {
                this.log.error("next-id {} does not exist in store", (Object)fwd.nextId());
                return Collections.emptySet();
            }
            TrafficTreatment nt = (TrafficTreatment)this.appKryo.deserialize(next.data());
            if (nt == null) {
                this.log.error("Error in deserializing next-id {}", (Object)fwd.nextId());
                return Collections.emptySet();
            }
            for (Instruction ins2 : nt.allInstructions()) {
                if (!(ins2 instanceof Instructions.OutputInstruction)) continue;
                ttBuilder.add(ins2);
            }
        }
        FlowRule rule = DefaultFlowRule.builder().withSelector(fwd.selector()).withTreatment(ttBuilder.build()).forTable(tableId).makePermanent().forDevice(this.deviceId).fromApp(fwd.appId()).withPriority(fwd.priority()).build();
        flowrules.add(rule);
        return flowrules;
    }

    private boolean containsPunt(TrafficTreatment treatment) {
        return treatment.immediate().stream().anyMatch(i -> i.type().equals((Object)Instruction.Type.OUTPUT) && ((Instructions.OutputInstruction)i).port().equals((Object)PortNumber.CONTROLLER));
    }

    private boolean matchesIp(TrafficSelector selector) {
        EthTypeCriterion c = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        return c != null && (c.ethType().equals((Object)EthType.EtherType.IPV4.ethType()) || c.ethType().equals((Object)EthType.EtherType.IPV6.ethType()));
    }

    private boolean matchesControlTraffic(TrafficSelector selector) {
        Icmpv6TypeCriterion ic;
        IPProtocolCriterion i;
        EthTypeCriterion c = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (c != null && c.ethType().equals((Object)EthType.EtherType.ARP.ethType())) {
            return true;
        }
        return c != null && c.ethType().equals((Object)EthType.EtherType.IPV6.ethType()) && (i = (IPProtocolCriterion)selector.getCriterion(Criterion.Type.IP_PROTO)) != null && i.protocol() == 58 && (ic = (Icmpv6TypeCriterion)selector.getCriterion(Criterion.Type.ICMPV6_TYPE)).icmpv6Type() != -128 && ic.icmpv6Type() != -127;
    }

    private Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        TrafficSelector.Builder filteredSelector;
        IpPrefix ipPrefix;
        this.log.debug("Processing specific forwarding objective to next:{}", (Object)fwd.nextId());
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null || ethType.ethType().toShort() != Ethernet.TYPE_IPV4 && ethType.ethType().toShort() != Ethernet.TYPE_IPV6) {
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            ipPrefix = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
            filteredSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4);
        } else {
            ipPrefix = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV6_DST)).ip();
            filteredSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV6);
        }
        if (ipPrefix.prefixLength() != 0) {
            if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
                filteredSelector.matchIPDst(ipPrefix);
            } else {
                filteredSelector.matchIPv6Dst(ipPrefix);
            }
        }
        TrafficTreatment tt = null;
        if (fwd.nextId() != null) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
            if (next == null) {
                this.log.error("next-id {} does not exist in store", (Object)fwd.nextId());
                return Collections.emptySet();
            }
            tt = (TrafficTreatment)this.appKryo.deserialize(next.data());
            if (tt == null) {
                this.log.error("Error in deserializing next-id {}", (Object)fwd.nextId());
                return Collections.emptySet();
            }
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector.build());
        if (tt != null) {
            ruleBuilder.withTreatment(tt);
        }
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ruleBuilder.forTable(1);
        return Collections.singletonList(ruleBuilder.build());
    }

    private void processSimpleNextObjective(NextObjective nextObj) {
        this.log.debug("Received nextObj {}", (Object)nextObj.id());
        Tools.delay((int)50);
        TrafficTreatment treatment = (TrafficTreatment)nextObj.next().iterator().next();
        this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObj.id()), (NextGroup)new DummyGroup(treatment));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return Collections.emptyList();
    }

    private class DummyGroup
    implements NextGroup {
        TrafficTreatment nextActions;

        public DummyGroup(TrafficTreatment next) {
            this.nextActions = next;
        }

        public byte[] data() {
            return SoftRouterPipeline.this.appKryo.serialize((Object)this.nextActions);
        }
    }
}

