/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.Optional;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.pipeline.DefaultSingleTablePipeline;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackPipeline
extends DefaultSingleTablePipeline
implements Pipeliner {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId appId;
    protected FlowRuleService flowRuleService;
    private static final int SRC_VNI_TABLE = 0;
    private static final int ACL_TABLE = 1;
    private static final int JUMP_TABLE = 2;
    private static final int ROUTING_TABLE = 3;
    private static final int FORWARDING_TABLE = 4;
    private static final int DUMMY_TABLE = 10;
    private static final int LAST_TABLE = 4;
    private static final int DROP_PRIORITY = 0;
    private static final int HIGH_PRIORITY = 30000;
    private static final int TIME_OUT = 0;
    private static final String VIRTUAL_GATEWAY_MAC = "fe:00:00:00:00:02";

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        super.init(deviceId, context);
        ServiceDirectory serviceDirectory = context.directory();
        this.deviceId = deviceId;
        CoreService coreService = (CoreService)serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)serviceDirectory.get(FlowRuleService.class);
        this.flowObjectiveStore = context.store();
        this.appId = coreService.registerApplication("org.onosproject.driver.OpenstackPipeline");
        this.initializePipeline();
    }

    @Override
    public void filter(FilteringObjective filteringObjective) {
        super.filter(filteringObjective);
    }

    @Override
    public void next(NextObjective nextObjective) {
        super.next(nextObjective);
    }

    @Override
    public void forward(ForwardingObjective forwardingObjective) {
        FlowRule flowRule;
        switch (forwardingObjective.flag()) {
            case SPECIFIC: {
                flowRule = this.processSpecific(forwardingObjective);
                break;
            }
            case VERSATILE: {
                flowRule = this.processVersatile(forwardingObjective);
                break;
            }
            default: {
                this.fail((Objective)forwardingObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding flag {}", (Object)forwardingObjective.flag());
                return;
            }
        }
        if (forwardingObjective.op().equals((Object)Objective.Operation.ADD)) {
            this.applyRules(true, flowRule);
        } else {
            this.applyRules(false, flowRule);
        }
    }

    private void initializePipeline() {
        this.connectTables(0, 1);
        this.connectTables(1, 2);
        this.setUpTableMissEntry(1);
        this.setupJumpTable();
    }

    private void connectTables(int fromTable, int toTable) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(toTable));
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(fromTable).build();
        this.applyRules(true, flowRule);
    }

    private void setUpTableMissEntry(int table) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.drop();
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(table).build();
        this.applyRules(true, flowRule);
    }

    private void setupJumpTable() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthDst(MacAddress.valueOf((String)VIRTUAL_GATEWAY_MAC));
        treatment.transition(Integer.valueOf(3));
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(30000).fromApp(this.appId).makePermanent().forTable(2).build();
        this.applyRules(true, flowRule);
        selector = DefaultTrafficSelector.builder();
        treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(4));
        flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(2).build();
        this.applyRules(true, flowRule);
    }

    private void applyRules(boolean install, FlowRule flowRule) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        flowOpsBuilder = install ? flowOpsBuilder.add(flowRule) : flowOpsBuilder.remove(flowRule);
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                OpenstackPipeline.this.log.debug("Provisioned vni or forwarding table");
            }

            public void onError(FlowRuleOperations ops) {
                OpenstackPipeline.this.log.debug("Failed to privision vni or forwarding table");
            }
        }));
    }

    private FlowRule processVersatile(ForwardingObjective forwardingObjective) {
        this.log.debug("Processing versatile forwarding objective");
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(forwardingObjective.selector()).withTreatment(forwardingObjective.treatment()).withPriority(forwardingObjective.priority()).fromApp(forwardingObjective.appId()).forTable(0);
        if (forwardingObjective.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(0);
        }
        return ruleBuilder.build();
    }

    private FlowRule processSpecific(ForwardingObjective forwardingObjective) {
        this.log.debug("Processing specific forwarding objective");
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        Optional<Instruction> group = forwardingObjective.treatment().immediate().stream().filter((? super T i) -> i.type() == Instruction.Type.GROUP).findAny();
        int tableType = this.tableType(forwardingObjective);
        if (tableType != 4 && !group.isPresent()) {
            treatment.transition(Integer.valueOf(this.nextTable(tableType)));
        }
        forwardingObjective.treatment().allInstructions().stream().filter((? super T i) -> i.type() != Instruction.Type.NOACTION).forEach(arg_0 -> ((TrafficTreatment.Builder)treatment).add(arg_0));
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(forwardingObjective.selector()).withTreatment(treatment.build()).withPriority(forwardingObjective.priority()).fromApp(forwardingObjective.appId()).forTable(tableType);
        if (forwardingObjective.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(0);
        }
        return ruleBuilder.build();
    }

    private int tableType(ForwardingObjective fo) {
        IPCriterion ipSrc = (IPCriterion)fo.selector().getCriterion(Criterion.Type.IPV4_SRC);
        IPCriterion ipDst = (IPCriterion)fo.selector().getCriterion(Criterion.Type.IPV4_DST);
        TunnelIdCriterion tunnelId = (TunnelIdCriterion)fo.selector().getCriterion(Criterion.Type.TUNNEL_ID);
        VlanIdCriterion vlanId = (VlanIdCriterion)fo.selector().getCriterion(Criterion.Type.VLAN_VID);
        PortCriterion inPort = (PortCriterion)fo.selector().getCriterion(Criterion.Type.IN_PORT);
        Optional<Instruction> output = fo.treatment().immediate().stream().filter((? super T i) -> i.type() == Instruction.Type.OUTPUT).findAny();
        Optional<Instruction> group = fo.treatment().immediate().stream().filter((? super T i) -> i.type() == Instruction.Type.GROUP).findAny();
        if (inPort != null) {
            return 0;
        }
        if (tunnelId != null && ipSrc != null && ipDst != null || vlanId != null && ipSrc != null && ipDst != null || ipSrc != null && group.isPresent()) {
            return 3;
        }
        if (output.isPresent() || ipDst != null && group.isPresent()) {
            return 4;
        }
        if (ipSrc != null && ipSrc.ip().prefixLength() == 32 && ipDst != null && ipDst.ip().prefixLength() == 32 || ipSrc != null && ipSrc.ip().prefixLength() == 32 && ipDst == null || ipDst != null && ipDst.ip().prefixLength() == 32 && ipSrc == null || ipDst != null && ipDst.ip().prefixLength() == 32 && ipSrc != null || ipSrc != null && ipSrc.ip().prefixLength() == 32 && ipDst != null) {
            return 1;
        }
        return 10;
    }

    private int nextTable(int baseTable) {
        return baseTable + 1;
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }
}

