/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import org.onlab.packet.VlanId;
import org.onosproject.driver.extensions.Ofdpa3MatchMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3MatchOvid;
import org.onosproject.net.behaviour.ExtensionSelectorResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.openflow.controller.ExtensionSelectorInterpreter;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaMplsL2Port;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaOvid;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

public class Ofdpa3ExtensionSelectorInterpreter
extends AbstractHandlerBehaviour
implements ExtensionSelectorInterpreter,
ExtensionSelectorResolver {
    public boolean supported(ExtensionSelectorType extensionSelectorType) {
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_OVID.type())) {
            return true;
        }
        return extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_MPLS_L2_PORT.type());
    }

    public OFOxm<?> mapSelector(OFFactory factory, ExtensionSelector extensionSelector) {
        ExtensionSelectorType type = extensionSelector.type();
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_OVID.type())) {
            VlanId vlanId = ((Ofdpa3MatchOvid)extensionSelector).vlanId();
            if (vlanId.equals((Object)VlanId.NONE)) {
                throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
            }
            if (vlanId.equals((Object)VlanId.ANY)) {
                throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
            }
            int mask = 4096;
            short oVid = (short)(mask | vlanId.toShort());
            return factory.oxms().ofdpaOvid(U16.ofRaw((short)oVid));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_MPLS_L2_PORT.type())) {
            int mplsL2Port = ((Ofdpa3MatchMplsL2Port)extensionSelector).mplsL2Port();
            if (mplsL2Port >= 0 && mplsL2Port <= 65535 || mplsL2Port >= 131072 && mplsL2Port <= 196607) {
                return factory.oxms().ofdpaMplsL2Port(U32.ofRaw((int)mplsL2Port));
            }
            throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
        }
        throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
    }

    public ExtensionSelector mapOxm(OFOxm<?> oxm) {
        if (oxm.getMatchField().equals(MatchField.OFDPA_OVID)) {
            if (oxm.isMasked()) {
                throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
            }
            OFOxmOfdpaOvid ovid = (OFOxmOfdpaOvid)oxm;
            int mask = 4095;
            short oVid = (short)(mask & ovid.getValue().getRaw());
            VlanId vlanId = VlanId.vlanId((short)oVid);
            return new Ofdpa3MatchOvid(vlanId);
        }
        if (oxm.getMatchField().equals(MatchField.OFDPA_MPLS_L2_PORT)) {
            if (oxm.isMasked()) {
                throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
            }
            OFOxmOfdpaMplsL2Port mplsl2port = (OFOxmOfdpaMplsL2Port)oxm;
            Integer mplsL2Port = mplsl2port.getValue().getRaw();
            if (mplsL2Port >= 0 && mplsL2Port <= 65535 || mplsL2Port >= 131072 && mplsL2Port <= 196607) {
                return new Ofdpa3MatchMplsL2Port(mplsL2Port);
            }
            throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
        }
        throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
    }

    public ExtensionSelector getExtensionSelector(ExtensionSelectorType type) {
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_OVID.type())) {
            return new Ofdpa3MatchOvid();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_MPLS_L2_PORT.type())) {
            return new Ofdpa3MatchMplsL2Port();
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + type.toString());
    }
}

