/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.flow.AbstractExtension;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.store.serializers.IpAddressSerializer;

public class NiciraNat
extends AbstractExtension
implements ExtensionTreatment {
    private int flags;
    private int presentFlags;
    private int portMin;
    private int portMax;
    private IpAddress ipAddressMin;
    private IpAddress ipAddressMax;
    private final KryoNamespace appKryo = new KryoNamespace.Builder().register((Serializer)new IpAddressSerializer(), new Class[]{IpAddress.class}).register(new Class[]{byte[].class}).build();

    public NiciraNat() {
        this.flags = 0;
        this.presentFlags = 0;
        this.portMin = 0;
        this.portMax = 0;
        this.ipAddressMin = IpAddress.valueOf((int)0);
        this.ipAddressMax = IpAddress.valueOf((int)0);
    }

    public NiciraNat(int flags, int presentFlags, int portMin, int portMax, IpAddress ipAddressMin, IpAddress ipAddressMax) {
        this.flags = flags;
        this.presentFlags = presentFlags;
        this.portMin = portMin;
        this.portMax = portMax;
        this.ipAddressMin = ipAddressMin;
        this.ipAddressMax = ipAddressMax;
    }

    public ExtensionTreatmentType type() {
        return ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NAT.type();
    }

    public int niciraNatFlags() {
        return this.flags;
    }

    public int niciraNatPresentFlags() {
        return this.presentFlags;
    }

    public int niciraNatPortMin() {
        return this.portMin;
    }

    public int niciraNatPortMax() {
        return this.portMax;
    }

    public IpAddress niciraNatIpAddressMin() {
        return this.ipAddressMin;
    }

    public IpAddress niciraNatIpAddressMax() {
        return this.ipAddressMax;
    }

    public void deserialize(byte[] data) {
        Map values = (Map)this.appKryo.deserialize(data);
        this.flags = (Integer)values.get("flags");
        this.presentFlags = (Integer)values.get("presentFlags");
        this.portMin = (Integer)values.get("portMin");
        this.portMax = (Integer)values.get("portMax");
        this.ipAddressMin = (IpAddress)values.get("ipAddressMin");
        this.ipAddressMax = (IpAddress)values.get("ipAddressMax");
    }

    public byte[] serialize() {
        HashMap values = Maps.newHashMap();
        values.put("flags", this.flags);
        values.put("presentFlags", this.presentFlags);
        values.put("portMin", this.portMin);
        values.put("portMax", this.portMax);
        values.put("ipAddressMin", this.ipAddressMin);
        values.put("ipAddressMax", this.ipAddressMax);
        return this.appKryo.serialize((Object)values);
    }

    public int hashCode() {
        return Objects.hash(this.type(), this.flags, this.presentFlags, this.portMin, this.portMax, this.ipAddressMin, this.ipAddressMax);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NiciraNat) {
            NiciraNat that = (NiciraNat)((Object)obj);
            return Objects.equals(this.flags, that.flags) && Objects.equals(this.presentFlags, that.presentFlags) && Objects.equals(this.portMin, that.portMin) && Objects.equals(this.portMax, that.portMax) && Objects.equals(this.ipAddressMin, that.ipAddressMin) && Objects.equals(this.ipAddressMax, that.ipAddressMax) && Objects.equals(this.type(), that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("flags", this.flags).add("present_flags", this.presentFlags).add("portMin", this.portMin).add("portMax", this.portMax).add("ipAddressMin", (Object)this.ipAddressMin).add("ipAddressMax", (Object)this.ipAddressMax).toString();
    }
}

