/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.flow.AbstractExtension;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;

public class NiciraMatchCtState
extends AbstractExtension
implements ExtensionSelector {
    private long ctState;
    private long ctStateMask;
    private final KryoNamespace appKryo = new KryoNamespace.Builder().build();

    NiciraMatchCtState() {
        this.ctState = 0L;
        this.ctStateMask = -1L;
    }

    public NiciraMatchCtState(long ctState, long mask) {
        this.ctState = ctState;
        this.ctStateMask = mask;
    }

    public long ctState() {
        return this.ctState;
    }

    public long ctStateMask() {
        return this.ctStateMask;
    }

    public ExtensionSelectorType type() {
        return ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_STATE.type();
    }

    public void deserialize(byte[] data) {
        Map values = (Map)this.appKryo.deserialize(data);
        this.ctState = (Long)values.get("ctState");
        this.ctStateMask = (Long)values.get("ctStateMask");
    }

    public byte[] serialize() {
        HashMap values = Maps.newHashMap();
        values.put("ctState", this.ctState);
        values.put("ctStateMask", this.ctStateMask);
        return this.appKryo.serialize((Object)values);
    }

    public int hashCode() {
        return Objects.hash(this.ctState, this.ctStateMask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NiciraMatchCtState) {
            NiciraMatchCtState that = (NiciraMatchCtState)((Object)obj);
            return Objects.equals(this.ctState, that.ctState) && Objects.equals(this.ctStateMask, that.ctStateMask);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("ctState", this.ctState).add("mask", this.ctStateMask).toString();
    }
}

