/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.MoveExtensionTreatment;
import org.onosproject.driver.extensions.NiciraMatchNshSi;
import org.onosproject.driver.extensions.NiciraMatchNshSpi;
import org.onosproject.driver.extensions.NiciraResubmit;
import org.onosproject.driver.extensions.NiciraResubmitTable;
import org.onosproject.driver.extensions.NiciraSetNshContextHeader;
import org.onosproject.driver.extensions.NiciraSetNshSi;
import org.onosproject.driver.extensions.NiciraSetNshSpi;
import org.onosproject.driver.extensions.NiciraSetTunnelDst;
import org.onosproject.driver.extensions.Ofdpa3MatchMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3MatchOvid;
import org.onosproject.driver.extensions.Ofdpa3SetMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3SetMplsType;
import org.onosproject.driver.extensions.Ofdpa3SetOvid;
import org.onosproject.driver.extensions.Ofdpa3SetQosIndex;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.driver.extensions.OplinkAttenuation;
import org.onosproject.driver.extensions.codec.MoveExtensionTreatmentCodec;
import org.onosproject.driver.extensions.codec.NiciraMatchNshSiCodec;
import org.onosproject.driver.extensions.codec.NiciraMatchNshSpiCodec;
import org.onosproject.driver.extensions.codec.NiciraResubmitCodec;
import org.onosproject.driver.extensions.codec.NiciraResubmitTableCodec;
import org.onosproject.driver.extensions.codec.NiciraSetNshContextHeaderCodec;
import org.onosproject.driver.extensions.codec.NiciraSetNshSiCodec;
import org.onosproject.driver.extensions.codec.NiciraSetNshSpiCodec;
import org.onosproject.driver.extensions.codec.NiciraSetTunnelDstCodec;
import org.onosproject.driver.extensions.codec.Ofdpa3MatchMplsL2PortCodec;
import org.onosproject.driver.extensions.codec.Ofdpa3MatchOvidCodec;
import org.onosproject.driver.extensions.codec.Ofdpa3SetMplsL2PortCodec;
import org.onosproject.driver.extensions.codec.Ofdpa3SetMplsTypeCodec;
import org.onosproject.driver.extensions.codec.Ofdpa3SetOvidCodec;
import org.onosproject.driver.extensions.codec.Ofdpa3SetQosIndexCodec;
import org.onosproject.driver.extensions.codec.OfdpaMatchVlanVidCodec;
import org.onosproject.driver.extensions.codec.OfdpaSetVlanVidCodec;
import org.onosproject.driver.extensions.codec.OplinkAttenuationCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DefaultCodecRegister {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CodecService codecService;

    @Activate
    public void activate() {
        this.codecService.registerCodec(MoveExtensionTreatment.class, (JsonCodec)new MoveExtensionTreatmentCodec());
        this.codecService.registerCodec(NiciraMatchNshSi.class, (JsonCodec)new NiciraMatchNshSiCodec());
        this.codecService.registerCodec(NiciraMatchNshSpi.class, (JsonCodec)new NiciraMatchNshSpiCodec());
        this.codecService.registerCodec(NiciraResubmit.class, (JsonCodec)new NiciraResubmitCodec());
        this.codecService.registerCodec(NiciraResubmitTable.class, (JsonCodec)new NiciraResubmitTableCodec());
        this.codecService.registerCodec(NiciraSetNshSi.class, (JsonCodec)new NiciraSetNshSiCodec());
        this.codecService.registerCodec(NiciraSetNshSpi.class, (JsonCodec)new NiciraSetNshSpiCodec());
        this.codecService.registerCodec(NiciraSetTunnelDst.class, (JsonCodec)new NiciraSetTunnelDstCodec());
        this.codecService.registerCodec(NiciraSetNshContextHeader.class, (JsonCodec)new NiciraSetNshContextHeaderCodec());
        this.codecService.registerCodec(OfdpaMatchVlanVid.class, (JsonCodec)new OfdpaMatchVlanVidCodec());
        this.codecService.registerCodec(OfdpaSetVlanVid.class, (JsonCodec)new OfdpaSetVlanVidCodec());
        this.codecService.registerCodec(Ofdpa3SetMplsType.class, (JsonCodec)new Ofdpa3SetMplsTypeCodec());
        this.codecService.registerCodec(Ofdpa3MatchOvid.class, (JsonCodec)new Ofdpa3MatchOvidCodec());
        this.codecService.registerCodec(Ofdpa3SetOvid.class, (JsonCodec)new Ofdpa3SetOvidCodec());
        this.codecService.registerCodec(Ofdpa3SetQosIndex.class, (JsonCodec)new Ofdpa3SetQosIndexCodec());
        this.codecService.registerCodec(Ofdpa3MatchMplsL2Port.class, (JsonCodec)new Ofdpa3MatchMplsL2PortCodec());
        this.codecService.registerCodec(Ofdpa3SetMplsL2Port.class, (JsonCodec)new Ofdpa3SetMplsL2PortCodec());
        this.codecService.registerCodec(OplinkAttenuation.class, (JsonCodec)new OplinkAttenuationCodec());
        this.log.info("Registered default driver codecs.");
    }

    @Deactivate
    public void deactivate() {
        this.codecService.unregisterCodec(MoveExtensionTreatment.class);
        this.codecService.unregisterCodec(NiciraMatchNshSi.class);
        this.codecService.unregisterCodec(NiciraMatchNshSpi.class);
        this.codecService.unregisterCodec(NiciraResubmit.class);
        this.codecService.unregisterCodec(NiciraResubmitTable.class);
        this.codecService.unregisterCodec(NiciraSetNshSi.class);
        this.codecService.unregisterCodec(NiciraSetNshSpi.class);
        this.codecService.unregisterCodec(NiciraSetTunnelDst.class);
        this.codecService.unregisterCodec(NiciraSetNshContextHeader.class);
        this.codecService.unregisterCodec(OfdpaMatchVlanVid.class);
        this.codecService.unregisterCodec(OfdpaSetVlanVid.class);
        this.codecService.unregisterCodec(Ofdpa3SetMplsType.class);
        this.codecService.unregisterCodec(Ofdpa3MatchOvid.class);
        this.codecService.unregisterCodec(Ofdpa3SetOvid.class);
        this.codecService.unregisterCodec(Ofdpa3SetQosIndex.class);
        this.codecService.unregisterCodec(Ofdpa3MatchMplsL2Port.class);
        this.codecService.unregisterCodec(Ofdpa3SetMplsL2Port.class);
        this.codecService.unregisterCodec(OplinkAttenuation.class);
        this.log.info("Unregistered default driver codecs.");
    }

    protected void bindCodecService(CodecService codecService) {
        this.codecService = codecService;
    }

    protected void unbindCodecService(CodecService codecService) {
        if (this.codecService == codecService) {
            this.codecService = null;
        }
    }
}

