/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyStore;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.driver.OpenFlowAgent;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.RoleHandler;
import org.onosproject.openflow.controller.impl.OpenflowPipelineFactory;
import org.onosproject.openflow.controller.impl.RoleManager;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    protected static final Logger log = LoggerFactory.getLogger(Controller.class);
    @Deprecated
    protected static final OFFactory FACTORY13 = OFFactories.getFactory((OFVersion)OFVersion.OF_13);
    @Deprecated
    protected static final OFFactory FACTORY10 = OFFactories.getFactory((OFVersion)OFVersion.OF_10);
    private static final boolean TLS_DISABLED = false;
    private static final short MIN_KS_LENGTH = 6;
    protected HashMap<String, String> controllerNodeIPsCache;
    private ChannelGroup cg;
    protected List<Integer> openFlowPorts = ImmutableList.of((Object)6633, (Object)6653);
    protected int workerThreads = 0;
    protected long systemStartTime;
    private OpenFlowAgent agent;
    private NioServerSocketChannelFactory execFactory;
    protected String ksLocation;
    protected String tsLocation;
    protected char[] ksPwd;
    protected char[] tsPwd;
    protected SSLContext sslContext;
    protected static final int SEND_BUFFER_SIZE = 0x400000;
    private DriverService driverService;
    private boolean enableOfTls = false;

    @Deprecated
    public OFFactory getOFMessageFactory10() {
        return FACTORY10;
    }

    @Deprecated
    public OFFactory getOFMessageFactory13() {
        return FACTORY13;
    }

    public void run() {
        try {
            ServerBootstrap bootstrap = this.createServerBootStrap();
            bootstrap.setOption("reuseAddr", (Object)true);
            bootstrap.setOption("child.keepAlive", (Object)true);
            bootstrap.setOption("child.tcpNoDelay", (Object)true);
            bootstrap.setOption("child.sendBufferSize", (Object)0x400000);
            OpenflowPipelineFactory pfact = new OpenflowPipelineFactory(this, null, this.sslContext);
            bootstrap.setPipelineFactory((ChannelPipelineFactory)pfact);
            this.cg = new DefaultChannelGroup();
            this.openFlowPorts.forEach(port -> {
                InetSocketAddress sa = new InetSocketAddress((int)port);
                this.cg.add((Object)bootstrap.bind((SocketAddress)sa));
                log.info("Listening for switch connections on {}", (Object)sa);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ServerBootstrap createServerBootStrap() {
        if (this.workerThreads == 0) {
            this.execFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"boss-%d", (Logger)log)), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"worker-%d", (Logger)log)));
            return new ServerBootstrap((ChannelFactory)this.execFactory);
        }
        this.execFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"boss-%d", (Logger)log)), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"worker-%d", (Logger)log)), this.workerThreads);
        return new ServerBootstrap((ChannelFactory)this.execFactory);
    }

    public void setConfigParams(Dictionary<?, ?> properties) {
        String ports = Tools.get(properties, (String)"openflowPorts");
        if (!Strings.isNullOrEmpty((String)ports)) {
            this.openFlowPorts = Stream.of(ports.split(",")).map(s -> Integer.parseInt(s)).collect(Collectors.toList());
        }
        log.debug("OpenFlow ports set to {}", this.openFlowPorts);
        String threads = Tools.get(properties, (String)"workerThreads");
        if (!Strings.isNullOrEmpty((String)threads)) {
            this.workerThreads = Integer.parseInt(threads);
        }
        log.debug("Number of worker threads set to {}", (Object)this.workerThreads);
    }

    public void init() {
        this.controllerNodeIPsCache = new HashMap();
        this.systemStartTime = System.currentTimeMillis();
        try {
            this.getTlsParameters();
            if (this.enableOfTls) {
                this.initSsl();
            }
        }
        catch (Exception ex) {
            log.error("SSL init failed: {}", (Object)ex.getMessage());
        }
    }

    private void getTlsParameters() {
        String tempString = System.getProperty("enableOFTLS");
        this.enableOfTls = Strings.isNullOrEmpty((String)tempString) ? false : Boolean.parseBoolean(tempString);
        log.info("OpenFlow Security is {}", (Object)(this.enableOfTls ? "enabled" : "disabled"));
        if (this.enableOfTls) {
            this.ksLocation = System.getProperty("javax.net.ssl.keyStore");
            if (Strings.isNullOrEmpty((String)this.ksLocation)) {
                this.enableOfTls = false;
                return;
            }
            this.tsLocation = System.getProperty("javax.net.ssl.trustStore");
            if (Strings.isNullOrEmpty((String)this.tsLocation)) {
                this.enableOfTls = false;
                return;
            }
            this.ksPwd = System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
            if (6 > this.ksPwd.length) {
                this.enableOfTls = false;
                return;
            }
            this.tsPwd = System.getProperty("javax.net.ssl.trustStorePassword").toCharArray();
            if (6 > this.tsPwd.length) {
                this.enableOfTls = false;
                return;
            }
        }
    }

    private void initSsl() throws Exception {
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(new FileInputStream(this.tsLocation), this.tsPwd);
        tmFactory.init(ts);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(this.ksLocation), this.ksPwd);
        kmf.init(ks, this.ksPwd);
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(kmf.getKeyManagers(), tmFactory.getTrustManagers(), null);
    }

    public Map<String, Long> getMemory() {
        HashMap<String, Long> m = new HashMap<String, Long>();
        Runtime runtime = Runtime.getRuntime();
        m.put("total", runtime.totalMemory());
        m.put("free", runtime.freeMemory());
        return m;
    }

    public Long getSystemUptime() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        return rb.getUptime();
    }

    public long getSystemStartTime() {
        return this.systemStartTime;
    }

    protected OpenFlowSwitchDriver getOFSwitchInstance(long dpid, OFDescStatsReply desc, OFVersion ofv) {
        Driver driver;
        Dpid dpidObj = new Dpid(dpid);
        try {
            driver = this.driverService.getDriver(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpidObj)));
        }
        catch (ItemNotFoundException e) {
            driver = this.driverService.getDriver(desc.getMfrDesc(), desc.getHwDesc(), desc.getSwDesc());
        }
        if (driver == null) {
            log.error("No OpenFlow driver for {} : {}", (Object)dpid, (Object)desc);
            return null;
        }
        log.info("Driver {} assigned to device {}", (Object)driver.name(), (Object)dpidObj);
        if (!driver.hasBehaviour(OpenFlowSwitchDriver.class)) {
            log.error("Driver {} does not support OpenFlowSwitchDriver behaviour", (Object)driver.name());
            return null;
        }
        DefaultDriverHandler handler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, DeviceId.deviceId((URI)Dpid.uri((Dpid)dpidObj))));
        OpenFlowSwitchDriver ofSwitchDriver = (OpenFlowSwitchDriver)driver.createBehaviour((DriverHandler)handler, OpenFlowSwitchDriver.class);
        ofSwitchDriver.init(dpidObj, desc, ofv);
        ofSwitchDriver.setAgent(this.agent);
        ofSwitchDriver.setRoleHandler((RoleHandler)new RoleManager(ofSwitchDriver));
        log.info("OpenFlow handshaker found for device {}: {}", (Object)dpid, (Object)ofSwitchDriver);
        return ofSwitchDriver;
    }

    public void start(OpenFlowAgent ag, DriverService driverService) {
        log.info("Starting OpenFlow IO");
        this.agent = ag;
        this.driverService = driverService;
        this.init();
        this.run();
    }

    public void stop() {
        log.info("Stopping OpenFlow IO");
        this.cg.close();
        this.execFactory.shutdown();
    }
}

