/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.bgpvrfaf.importroutes;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.bgpvrfaf.importroutes.ImportRoute;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.bgpvrfaf.importroutes.ImportRouteKeys;
import org.onosproject.yang.gen.v1.nebgpcommtype.rev20141225.nebgpcommtype.BgpcommImRouteProtocol;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

public class DefaultImportRoute
extends InnerModelObject
implements ImportRoute,
MultiInstanceObject<ImportRouteKeys> {
    protected BgpcommImRouteProtocol importProtocol;
    protected String importProcessId;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public BgpcommImRouteProtocol importProtocol() {
        return this.importProtocol;
    }

    @Override
    public String importProcessId() {
        return this.importProcessId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public void importProtocol(BgpcommImRouteProtocol importProtocol) {
        this.valueLeafFlags.set(ImportRoute.LeafIdentifier.IMPORTPROTOCOL.getLeafIndex());
        this.importProtocol = importProtocol;
    }

    @Override
    public void importProcessId(String importProcessId) {
        this.valueLeafFlags.set(ImportRoute.LeafIdentifier.IMPORTPROCESSID.getLeafIndex());
        this.importProcessId = importProcessId;
    }

    public int hashCode() {
        return Objects.hash(this.importProtocol, this.importProcessId, this.valueLeafFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultImportRoute) {
            DefaultImportRoute other = (DefaultImportRoute)obj;
            return Objects.equals(this.importProtocol, other.importProtocol) && Objects.equals(this.importProcessId, other.importProcessId) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("importProtocol=" + this.importProtocol).add("importProcessId=" + this.importProcessId).add("valueLeafFlags=" + this.valueLeafFlags).toString();
    }

    @Override
    public boolean isLeafValueSet(ImportRoute.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

