/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.MappingService;
import org.onosproject.mapping.MappingStore;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.MappingValue;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="mappings", description="Lists mappings")
public class MappingsListCommand
extends AbstractShellCommand {
    private static final String DB = "database";
    private static final String CACHE = "cache";
    private static final String SUMMARY_FORMAT = "deviceId=%s, mappingCount=%d";
    private static final String MAPPING_ID_FORMAT = "  id=%s";
    private static final String MAPPING_STATE_FORMAT = "  state=%s";
    private static final String MAPPING_KEY_FORMAT = "  key=%s";
    private static final String MAPPING_VALUE_FORMAT = "  value=";
    private static final String MAPPING_ACTION_FORMAT = "    action=%s";
    private static final String MAPPING_TREATMENTS_FORMAT = "    treatments=";
    private static final String MAPPING_TREATMENT_LONG_FORMAT = "      address=%s, instructions=%s";
    private static final String MAPPING_TREATMENT_SHORT_FORMAT = "      %s";
    private static final String JSON_FORMAT = "%s";
    private static final String TYPE_NOT_NULL = "Mapping store type should not be null";
    private static final String TYPE_ILLEGAL = "Mapping store type is not correct";
    @Argument(index=0, name="type", description="Shows mappings with specified type", required=true, multiValued=false)
    private String type = null;
    @Argument(index=1, name="deviceId", description="Device identity", required=false, multiValued=false)
    private String deviceId = null;
    @Option(name="-s", aliases={"--short"}, description="Print more succinct output for each mapping", required=false, multiValued=false)
    private boolean shortOutput = false;
    private MappingService mappingService = (MappingService)AbstractShellCommand.get(MappingService.class);
    private List<MappingEntry> mappings;

    protected void execute() {
        MappingStore.Type typeEnum = this.getTypeEnum(this.type);
        DeviceService deviceService = (DeviceService)MappingsListCommand.get(DeviceService.class);
        Iterable devices = deviceService.getDevices();
        if (this.outputJson()) {
            this.print(JSON_FORMAT, new Object[]{this.json(typeEnum, devices)});
        } else if (this.deviceId != null) {
            this.mappings = Lists.newArrayList((Iterable)this.mappingService.getMappingEntries(typeEnum, DeviceId.deviceId((String)this.deviceId)));
            this.printMappings(DeviceId.deviceId((String)this.deviceId), this.mappings);
        } else {
            for (Device d : devices) {
                this.mappings = Lists.newArrayList((Iterable)this.mappingService.getMappingEntries(typeEnum, d.id()));
                this.printMappings(d.id(), this.mappings);
            }
        }
    }

    private void printMappings(DeviceId deviceId, List<MappingEntry> mappings) {
        this.print(SUMMARY_FORMAT, new Object[]{deviceId, mappings.size()});
        for (MappingEntry m : mappings) {
            this.print(MAPPING_ID_FORMAT, new Object[]{Long.toHexString(m.id().value())});
            this.print(MAPPING_STATE_FORMAT, new Object[]{m.state().name()});
            this.print(MAPPING_KEY_FORMAT, new Object[]{this.printMappingKey(m.key())});
            this.printMappingValue(m.value());
        }
    }

    private String printMappingKey(MappingKey key) {
        StringBuilder builder = new StringBuilder();
        if (key.address() != null) {
            builder.append(key.address().toString());
        }
        return builder.toString();
    }

    private void printMappingValue(MappingValue value) {
        this.print(MAPPING_VALUE_FORMAT, new Object[0]);
        if (value.action() != null) {
            this.print(MAPPING_ACTION_FORMAT, new Object[]{value.action().toString()});
        }
        if (!value.treatments().isEmpty()) {
            this.print(MAPPING_TREATMENTS_FORMAT, new Object[0]);
            for (MappingTreatment treatment : value.treatments()) {
                this.printMappingTreatment(treatment);
            }
        }
    }

    private void printMappingTreatment(MappingTreatment treatment) {
        if (treatment != null) {
            if (this.shortOutput) {
                this.print(MAPPING_TREATMENT_SHORT_FORMAT, new Object[]{treatment.address()});
            } else {
                this.print(MAPPING_TREATMENT_LONG_FORMAT, new Object[]{treatment.address(), treatment.instructions()});
            }
        }
    }

    private MappingStore.Type getTypeEnum(String type) {
        if (type == null) {
            throw new IllegalArgumentException(TYPE_NOT_NULL);
        }
        switch (type) {
            case "database": {
                return MappingStore.Type.MAP_DATABASE;
            }
            case "cache": {
                return MappingStore.Type.MAP_CACHE;
            }
        }
        throw new IllegalArgumentException(TYPE_ILLEGAL);
    }

    private ObjectNode json(ObjectMapper mapper, Device device, List<MappingEntry> mappings) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode array = mapper.createArrayNode();
        mappings.forEach(mapping -> array.add((JsonNode)this.jsonForEntity(mapping, MappingEntry.class)));
        result.put("device", device.id().toString()).put("mappingCount", mappings.size()).set("mappings", (JsonNode)array);
        return result;
    }

    private JsonNode json(MappingStore.Type type, Iterable<Device> devices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add((JsonNode)this.json(mapper, device, Lists.newArrayList((Iterable)this.mappingService.getMappingEntries(type, device.id()))));
        }
        return result;
    }
}

