/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.cli;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.mapping.MappingStore;

public class MappingStoreTypeCompleter
extends AbstractChoicesCompleter {
    private static final List<MappingStore.Type> STORE_TYPES = ImmutableList.of((Object)MappingStore.Type.MAP_CACHE, (Object)MappingStore.Type.MAP_DATABASE);
    private static final String MAP_PREFIX = "map_";

    protected List<String> choices() {
        return STORE_TYPES.stream().map(type -> this.removeMapPrefix(type.toString().toLowerCase())).collect(Collectors.toList());
    }

    private String removeMapPrefix(String type) {
        return StringUtils.replaceAll((String)type, (String)MAP_PREFIX, (String)"");
    }
}

