/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.protocol.restconf.server.rpp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.server.ChunkedOutput;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.restconf.api.Patch;
import org.onosproject.restconf.api.RestconfException;
import org.onosproject.restconf.api.RestconfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class RestconfWebResource
extends AbstractWebResource {
    @Context
    UriInfo uriInfo;
    private final RestconfService service = (RestconfService)this.get(RestconfService.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @GET
    @Produces(value={"application/json"})
    @Path(value="data/{identifier : .+}")
    public Response handleGetRequest(@PathParam(value="identifier") String uriString) {
        this.log.debug("handleGetRequest: {}", (Object)uriString);
        try {
            ObjectNode node = this.service.runGetOperationOnDataResource(uriString);
            return RestconfWebResource.ok((Object)node).build();
        }
        catch (RestconfException e) {
            this.log.error("ERROR: handleGetRequest: {}", (Object)e.getMessage());
            this.log.debug("Exception in handleGetRequest:", (Throwable)e);
            return e.getResponse();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="streams/{streamId}")
    public ChunkedOutput<String> handleNotificationRegistration(@PathParam(value="streamId") String streamId) {
        ChunkedOutput output = new ChunkedOutput(String.class);
        try {
            this.service.subscribeEventStream(streamId, output);
        }
        catch (RestconfException e) {
            this.log.error("ERROR: handleNotificationRegistration: {}", (Object)e.getMessage());
            this.log.debug("Exception in handleNotificationRegistration:", (Throwable)e);
            try {
                output.close();
            }
            catch (IOException ex) {
                this.log.error("ERROR: handleNotificationRegistration:", (Throwable)ex);
            }
        }
        return output;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="data/{identifier : .+}")
    public Response handlePostRequest(@PathParam(value="identifier") String uriString, InputStream stream) {
        this.log.debug("handlePostRequest: {}", (Object)uriString);
        try {
            ObjectNode rootNode = (ObjectNode)this.mapper().readTree(stream);
            this.service.runPostOperationOnDataResource(uriString, rootNode);
            return Response.created((URI)this.uriInfo.getRequestUri()).build();
        }
        catch (JsonProcessingException e) {
            this.log.error("ERROR: handlePostRequest ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (RestconfException e) {
            this.log.error("ERROR: handlePostRequest: {}", (Object)e.getMessage());
            this.log.debug("Exception in handlePostRequest:", (Throwable)e);
            return e.getResponse();
        }
        catch (IOException ex) {
            this.log.error("ERROR: handlePostRequest ", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="data/{identifier : .+}")
    public Response handlePutRequest(@PathParam(value="identifier") String uriString, InputStream stream) {
        this.log.debug("handlePutRequest: {}", (Object)uriString);
        try {
            ObjectNode rootNode = (ObjectNode)this.mapper().readTree(stream);
            this.service.runPutOperationOnDataResource(uriString, rootNode);
            return Response.created((URI)this.uriInfo.getRequestUri()).build();
        }
        catch (JsonProcessingException e) {
            this.log.error("ERROR: handlePutRequest ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (RestconfException e) {
            this.log.error("ERROR: handlePutRequest: {}", (Object)e.getMessage());
            this.log.debug("Exception in handlePutRequest:", (Throwable)e);
            return e.getResponse();
        }
        catch (IOException ex) {
            this.log.error("ERROR: handlePutRequest ", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="data/{identifier : .+}")
    public Response handleDeleteRequest(@PathParam(value="identifier") String uriString) {
        this.log.debug("handleDeleteRequest: {}", (Object)uriString);
        try {
            this.service.runDeleteOperationOnDataResource(uriString);
            return Response.ok().build();
        }
        catch (RestconfException e) {
            this.log.error("ERROR: handleDeleteRequest: {}", (Object)e.getMessage());
            this.log.debug("Exception in handleDeleteRequest:", (Throwable)e);
            return e.getResponse();
        }
    }

    @Patch
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="data/{identifier : .+}")
    public Response handlePatchRequest(@PathParam(value="identifier") String uriString, InputStream stream) {
        this.log.debug("handlePatchRequest: {}", (Object)uriString);
        try {
            ObjectNode rootNode = (ObjectNode)this.mapper().readTree(stream);
            this.service.runPatchOperationOnDataResource(uriString, rootNode);
            return Response.ok().build();
        }
        catch (JsonProcessingException e) {
            this.log.error("ERROR: handlePatchRequest ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (RestconfException e) {
            this.log.error("ERROR: handlePatchRequest: {}", (Object)e.getMessage());
            this.log.debug("Exception in handlePatchRequest:", (Throwable)e);
            return e.getResponse();
        }
        catch (IOException ex) {
            this.log.error("ERROR: handlePatchRequest ", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

