/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.intentsync;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.intentsync.IntentSynchronizationAdminService;
import org.onosproject.intentsync.IntentSynchronizationService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentUtils;
import org.onosproject.net.intent.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class IntentSynchronizer
implements IntentSynchronizationService,
IntentSynchronizationAdminService {
    private static final Logger log = LoggerFactory.getLogger(IntentSynchronizer.class);
    private static final String APP_NAME = "org.onosproject.intentsynchronizer";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    private NodeId localNodeId;
    private ApplicationId appId;
    private final InternalLeadershipListener leadershipEventListener = new InternalLeadershipListener();
    private final Map<Key, Intent> intents = new ConcurrentHashMap<Key, Intent>();
    private ExecutorService intentsSynchronizerExecutor;
    private volatile boolean isElectedLeader = false;
    private volatile boolean isActivatedLeader = false;

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.intentsSynchronizerExecutor = this.createExecutor();
        this.leadershipService.addListener((EventListener)this.leadershipEventListener);
        this.leadershipService.runForLeadership(this.appId.name());
        log.info("Started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        this.leadershipService.withdraw(this.appId.name());
        this.leadershipService.removeListener((EventListener)this.leadershipEventListener);
        IntentSynchronizer intentSynchronizer = this;
        synchronized (intentSynchronizer) {
            this.intentsSynchronizerExecutor.shutdownNow();
        }
        log.info("Stopped");
    }

    protected ExecutorService createExecutor() {
        return Executors.newSingleThreadExecutor(Tools.groupedThreads((String)("onos/" + this.appId), (String)"sync", (Logger)log));
    }

    @Override
    public void removeIntents() {
        if (!this.isElectedLeader) {
            return;
        }
        log.debug("Intent Synchronizer shutdown: withdrawing all intents...");
        for (Map.Entry<Key, Intent> entry : this.intents.entrySet()) {
            this.intentService.withdraw(entry.getValue());
            log.debug("Intent Synchronizer withdrawing intent: {}", (Object)entry.getValue());
        }
        this.intents.clear();
        log.info("Tried to clean all intents");
    }

    @Override
    public void removeIntentsByAppId(ApplicationId appId) {
        if (!this.isElectedLeader) {
            return;
        }
        log.debug("Withdrawing intents for app {}...", (Object)appId);
        this.intents.entrySet().stream().filter(intent -> ((Intent)intent.getValue()).appId().equals(appId)).forEach(intent -> {
            log.debug("Intent Synchronizer withdrawing intent: {}", intent);
            this.intentService.withdraw((Intent)intent.getValue());
            this.intents.remove(intent.getKey(), intent.getValue());
            log.info("Tried to clean intents for app: {}", (Object)appId);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Intent intent) {
        IntentSynchronizer intentSynchronizer = this;
        synchronized (intentSynchronizer) {
            this.intents.put(intent.key(), intent);
            if (this.isElectedLeader && this.isActivatedLeader) {
                log.trace("Submitting intent: {}", (Object)intent);
                this.intentService.submit(intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withdraw(Intent intent) {
        IntentSynchronizer intentSynchronizer = this;
        synchronized (intentSynchronizer) {
            this.intents.remove(intent.key(), intent);
            if (this.isElectedLeader && this.isActivatedLeader) {
                log.trace("Withdrawing intent: {}", (Object)intent);
                this.intentService.withdraw(intent);
            }
        }
    }

    private void leaderChanged(boolean isLeader) {
        log.debug("Leader changed: {}", (Object)isLeader);
        if (!isLeader) {
            this.isElectedLeader = false;
            this.isActivatedLeader = false;
            return;
        }
        this.isActivatedLeader = false;
        this.isElectedLeader = true;
        this.intentsSynchronizerExecutor.execute(this::synchronizeIntents);
    }

    private void synchronizeIntents() {
        HashMap serviceIntents = new HashMap();
        this.intentService.getIntents().forEach(i -> {
            if (i.appId().equals(this.appId)) {
                serviceIntents.put(i.key(), i);
            }
        });
        LinkedList<Intent> intentsToAdd = new LinkedList<Intent>();
        LinkedList<Intent> intentsToRemove = new LinkedList<Intent>();
        for (Intent localIntent : this.intents.values()) {
            Intent serviceIntent = (Intent)serviceIntents.remove(localIntent.key());
            if (serviceIntent == null) {
                intentsToAdd.add(localIntent);
                continue;
            }
            IntentState state = this.intentService.getIntentState(serviceIntent.key());
            if (IntentUtils.intentsAreEqual((Intent)serviceIntent, (Intent)localIntent) && state != null && state != IntentState.WITHDRAW_REQ && state != IntentState.WITHDRAWING && state != IntentState.WITHDRAWN) continue;
            intentsToAdd.add(localIntent);
        }
        for (Intent serviceIntent : serviceIntents.values()) {
            IntentState state = this.intentService.getIntentState(serviceIntent.key());
            if (state == null || state == IntentState.WITHDRAW_REQ || state == IntentState.WITHDRAWING || state == IntentState.WITHDRAWN) continue;
            intentsToRemove.add(serviceIntent);
        }
        log.debug("Intent Synchronizer: submitting {}, withdrawing {}", (Object)intentsToAdd.size(), (Object)intentsToRemove.size());
        for (Intent intent : intentsToRemove) {
            this.intentService.withdraw(intent);
            log.trace("Intent Synchronizer: withdrawing intent: {}", (Object)intent);
        }
        if (!this.isElectedLeader) {
            log.debug("Intent Synchronizer: cannot withdraw intents: not elected leader anymore");
            this.isActivatedLeader = false;
            return;
        }
        for (Intent intent : intentsToAdd) {
            this.intentService.submit(intent);
            log.trace("Intent Synchronizer: submitting intent: {}", (Object)intent);
        }
        if (!this.isElectedLeader) {
            log.debug("Intent Synchronizer: cannot submit intents: not elected leader anymore");
            this.isActivatedLeader = false;
            return;
        }
        this.isActivatedLeader = this.isElectedLeader;
        log.debug("Intent synchronization completed");
    }

    @Override
    public void modifyPrimary(boolean isPrimary) {
        this.leaderChanged(isPrimary);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    private class InternalLeadershipListener
    implements LeadershipEventListener {
        private InternalLeadershipListener() {
        }

        public boolean isRelevant(LeadershipEvent event) {
            return ((Leadership)event.subject()).topic().equals(IntentSynchronizer.this.appId.name());
        }

        public void event(LeadershipEvent event) {
            switch ((LeadershipEvent.Type)event.type()) {
                case LEADER_CHANGED: 
                case LEADER_AND_CANDIDATES_CHANGED: {
                    if (IntentSynchronizer.this.localNodeId.equals((Object)((Leadership)event.subject()).leaderNodeId())) {
                        log.info("IntentSynchronizer gained leadership");
                        IntentSynchronizer.this.leaderChanged(true);
                        break;
                    }
                    log.info("IntentSynchronizer leader changed. New leader is {}", (Object)((Leadership)event.subject()).leaderNodeId());
                    IntentSynchronizer.this.leaderChanged(false);
                }
            }
        }
    }
}

