/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.onlab.packet.IpAddress;
import org.onlab.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LispRouterId
extends Identifier<IpAddress> {
    private static final Logger log = LoggerFactory.getLogger(LispRouterId.class);
    private static final String SCHEME = "lisp";
    private static final IpAddress UNKNOWN = IpAddress.valueOf((String)"0.0.0.0");

    public LispRouterId() {
        super((Object)UNKNOWN);
    }

    public LispRouterId(IpAddress value) {
        super((Object)value);
    }

    public LispRouterId(String value) {
        super((Object)IpAddress.valueOf((String)value));
    }

    public static LispRouterId routerId(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return new LispRouterId(IpAddress.valueOf((String)uri.getSchemeSpecificPart()));
    }

    public static URI uri(LispRouterId routerId) {
        return LispRouterId.uri((IpAddress)routerId.id());
    }

    public static URI uri(IpAddress ipAddress) {
        try {
            return new URI(SCHEME, ipAddress.toString(), null);
        }
        catch (URISyntaxException e) {
            log.warn("Failed to parse the IP address.", (Throwable)e);
            return null;
        }
    }
}

