/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl;

import org.onlab.packet.IpAddress;
import org.onosproject.lisp.ctl.DefaultLispRouter;
import org.onosproject.lisp.ctl.LispRouter;
import org.onosproject.lisp.ctl.LispRouterAgent;
import org.onosproject.lisp.ctl.LispRouterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LispRouterFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private LispRouterAgent agent;

    private LispRouterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAgent(LispRouterAgent agent) {
        LispRouterAgent lispRouterAgent = agent;
        synchronized (lispRouterAgent) {
            if (this.agent == null) {
                this.agent = agent;
            } else {
                this.log.warn("LISP Router Agent has already been set.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAgent() {
        LispRouterAgent lispRouterAgent = this.agent;
        synchronized (lispRouterAgent) {
            if (this.agent != null) {
                this.agent = null;
            } else {
                this.log.warn("LISP Router Agent is not configured.");
            }
        }
    }

    public LispRouter getRouterInstance(IpAddress routerId) {
        DefaultLispRouter router = new DefaultLispRouter(new LispRouterId(routerId));
        router.setAgent(this.agent);
        return router;
    }

    public static LispRouterFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private static final class SingletonHelper {
        private static final String ILLEGAL_ACCESS_MSG = "Should not instantiate this class.";
        private static final LispRouterFactory INSTANCE = new LispRouterFactory();

        private SingletonHelper() {
            throw new IllegalAccessError(ILLEGAL_ACCESS_MSG);
        }
    }
}

