/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.tl1.device.impl;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.tl1.device.impl.Tl1DeviceConfig;
import org.onosproject.provider.tl1.device.impl.Tl1ProviderConfig;
import org.onosproject.tl1.Tl1Controller;
import org.onosproject.tl1.Tl1Device;
import org.onosproject.tl1.Tl1Listener;
import org.onosproject.tl1.impl.DefaultTl1Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class Tl1DeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private static final String APP_NAME = "org.onosproject.tl1";
    protected static final String TL1 = "tl1";
    private static final String PROVIDER = "org.onosproject.provider.tl1.device";
    private static final String UNKNOWN = "unknown";
    private static final int REACHABILITY_TIMEOUT = 2000;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceAdminService deviceAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected Tl1Controller controller;
    private ApplicationId appId;
    private NetworkConfigListener cfgListener = new InnerConfigListener();
    private Tl1Listener tl1Listener = new InnerTl1Listener();
    private DeviceProviderService providerService;
    private final List<ConfigFactory> factories = ImmutableList.of((Object)new ConfigFactory<ApplicationId, Tl1ProviderConfig>(SubjectFactories.APP_SUBJECT_FACTORY, Tl1ProviderConfig.class, "tl1_devices", true){

        public Tl1ProviderConfig createConfig() {
            return new Tl1ProviderConfig();
        }
    }, (Object)new ConfigFactory<DeviceId, Tl1DeviceConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, Tl1DeviceConfig.class, "tl1"){

        public Tl1DeviceConfig createConfig() {
            return new Tl1DeviceConfig();
        }
    });

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.cfgRegistry.addListener((EventListener)this.cfgListener);
        this.controller.addListener(this.tl1Listener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).registerConfigFactory(arg_0));
        this.registerDevices();
        this.connectDevices();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.controller.removeListener(this.tl1Listener);
        this.cfgRegistry.removeListener((EventListener)this.cfgListener);
        this.controller.getDeviceIds().forEach(deviceId -> {
            this.controller.removeDevice(deviceId);
            this.deviceAdminService.removeDevice(deviceId);
        });
        this.providerRegistry.unregister((Provider)this);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).unregisterConfigFactory(arg_0));
        this.providerService = null;
        this.log.info("Stopped");
    }

    public Tl1DeviceProvider() {
        super(new ProviderId(TL1, PROVIDER));
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        switch (newRole) {
            case MASTER: {
                this.controller.connectDevice(deviceId);
                this.providerService.receivedRoleReply(deviceId, newRole, MastershipRole.MASTER);
                this.log.debug("Accepting mastership role change to {} for device {}", (Object)newRole, (Object)deviceId);
                break;
            }
            case STANDBY: {
                this.controller.disconnectDevice(deviceId);
                this.providerService.receivedRoleReply(deviceId, newRole, MastershipRole.STANDBY);
                break;
            }
            case NONE: {
                this.controller.disconnectDevice(deviceId);
                this.providerService.receivedRoleReply(deviceId, newRole, MastershipRole.NONE);
                break;
            }
            default: {
                this.log.error("Invalid mastership state: {}", (Object)newRole);
            }
        }
    }

    public boolean isReachable(DeviceId deviceId) {
        try {
            Tl1Device device = (Tl1Device)this.controller.getDevice(deviceId).get();
            if (device.isConnected()) {
                return true;
            }
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(device.ip().toInetAddress(), device.port()), 2000);
            socket.close();
            return true;
        }
        catch (IOException | IllegalArgumentException | NoSuchElementException e) {
            this.log.error("Cannot reach device {}", (Object)deviceId, (Object)e);
            return false;
        }
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
    }

    void registerDevices() {
        Tl1ProviderConfig cfg = (Tl1ProviderConfig)this.cfgRegistry.getConfig((Object)this.appId, Tl1ProviderConfig.class);
        if (cfg == null) {
            return;
        }
        try {
            cfg.readDevices().forEach(this::connectDevice);
        }
        catch (ConfigException e) {
            this.log.error("Cannot parse network configuration", (Throwable)e);
        }
    }

    private void connectDevices() {
        Set deviceSubjects = this.cfgRegistry.getSubjects(DeviceId.class, Tl1DeviceConfig.class);
        deviceSubjects.forEach(deviceId -> {
            Tl1DeviceConfig config = (Tl1DeviceConfig)this.cfgRegistry.getConfig(deviceId, Tl1DeviceConfig.class);
            this.connectDevice((Tl1Device)new DefaultTl1Device(config.ip(), config.port(), config.username(), config.password()));
        });
    }

    private void connectDevice(Tl1Device device) {
        try {
            DeviceId deviceId = DeviceId.deviceId((URI)new URI(TL1, device.ip() + ":" + device.port(), null));
            if (this.controller.addDevice(deviceId, device)) {
                DefaultAnnotations ann = DefaultAnnotations.builder().set("protocol", TL1.toUpperCase()).build();
                DefaultDeviceDescription dd = new DefaultDeviceDescription(deviceId.uri(), Device.Type.SWITCH, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, new ChassisId(), false, new SparseAnnotations[]{ann});
                this.providerService.deviceConnected(deviceId, (DeviceDescription)dd);
            }
        }
        catch (URISyntaxException e) {
            this.log.error("Skipping device {}", (Object)device, (Object)e);
        }
    }

    void updateDevice(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (!device.is(DeviceDescriptionDiscovery.class)) {
            return;
        }
        try {
            DeviceDescriptionDiscovery discovery = (DeviceDescriptionDiscovery)device.as(DeviceDescriptionDiscovery.class);
            DeviceDescription dd = discovery.discoverDeviceDetails();
            if (dd == null) {
                return;
            }
            this.providerService.deviceConnected(deviceId, (DeviceDescription)new DefaultDeviceDescription(dd, true, new SparseAnnotations[]{dd.annotations()}));
            this.providerService.updatePorts(deviceId, discovery.discoverPortDetails());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.log.error("Cannot update device description {}", (Object)deviceId, (Object)e);
        }
    }

    protected void bindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgRegistry = networkConfigRegistry;
    }

    protected void unbindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgRegistry == networkConfigRegistry) {
            this.cfgRegistry = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceAdminService(DeviceAdminService deviceAdminService) {
        this.deviceAdminService = deviceAdminService;
    }

    protected void unbindDeviceAdminService(DeviceAdminService deviceAdminService) {
        if (this.deviceAdminService == deviceAdminService) {
            this.deviceAdminService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindController(Tl1Controller tl1Controller) {
        this.controller = tl1Controller;
    }

    protected void unbindController(Tl1Controller tl1Controller) {
        if (this.controller == tl1Controller) {
            this.controller = null;
        }
    }

    private class InnerTl1Listener
    implements Tl1Listener {
        private InnerTl1Listener() {
        }

        public void deviceConnected(DeviceId deviceId) {
            Tl1DeviceProvider.this.updateDevice(deviceId);
        }

        public void deviceDisconnected(DeviceId deviceId) {
            Tl1DeviceProvider.this.providerService.deviceDisconnected(deviceId);
        }
    }

    private class InnerConfigListener
    implements NetworkConfigListener {
        private InnerConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED) {
                if (event.configClass().equals(Tl1DeviceConfig.class)) {
                    Tl1DeviceProvider.this.connectDevices();
                } else {
                    Tl1DeviceProvider.this.log.warn("Injecting device via this Json is deprecated, please put configuration under devices/");
                    Tl1DeviceProvider.this.registerDevices();
                }
            } else if (event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) {
                if (event.configClass().equals(Tl1DeviceConfig.class)) {
                    Tl1DeviceProvider.this.connectDevices();
                } else {
                    Tl1DeviceProvider.this.log.warn("Injecting device via this Json is deprecated, please put configuration under devices/");
                    Tl1DeviceProvider.this.registerDevices();
                }
            } else if (event.type() == NetworkConfigEvent.Type.CONFIG_REMOVED) {
                Tl1DeviceProvider.this.controller.getDeviceIds().forEach(deviceId -> {
                    Tl1DeviceProvider.this.controller.removeDevice(deviceId);
                    Tl1DeviceProvider.this.deviceAdminService.removeDevice(deviceId);
                });
            }
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return !(!event.configClass().equals(Tl1DeviceConfig.class) && !event.configClass().equals(Tl1ProviderConfig.class) || event.type() != NetworkConfigEvent.Type.CONFIG_ADDED && event.type() != NetworkConfigEvent.Type.CONFIG_UPDATED && event.type() != NetworkConfigEvent.Type.CONFIG_REMOVED);
        }
    }
}

